/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.Arrays;
import org.jooq.BindContext;
import org.jooq.DataType;
import org.jooq.Field;
import org.jooq.RenderContext;
import org.jooq.SQLDialect;
import org.jooq.impl.AbstractField;
import org.jooq.impl.DSL;
import org.jooq.impl.SQLDataType;

class Cast<T>
extends AbstractField<T> {
    private static final long serialVersionUID = -6776617606751542856L;
    private final Field<?> field;

    public Cast(Field<?> field, DataType<T> type) {
        super("cast", type);
        this.field = field;
    }

    private final DataType<T> getSQLDataType() {
        return this.getDataType().getSQLDataType();
    }

    @Override
    public final void toSQL(RenderContext context) {
        RenderContext.CastMode castMode = context.castMode();
        if (context.configuration().dialect() == SQLDialect.DERBY) {
            if (this.field.getDataType().isNumeric() && SQLDataType.VARCHAR.equals(this.getSQLDataType())) {
                ((RenderContext)context.keyword("trim").sql("(").keyword("cast").sql("(").keyword("cast").sql("(").castMode(RenderContext.CastMode.NEVER).visit(this.field)).castMode(castMode).sql(" ").keyword("as").sql(" char(38))").sql(" ").keyword("as").sql(" ").keyword(this.getDataType(context.configuration()).getCastTypeName(context.configuration())).sql("))");
                return;
            }
            if (this.field.getDataType().isString() && Arrays.asList(SQLDataType.FLOAT, SQLDataType.DOUBLE, SQLDataType.REAL).contains(this.getSQLDataType())) {
                ((RenderContext)context.keyword("cast").sql("(").keyword("cast").sql("(").castMode(RenderContext.CastMode.NEVER).visit(this.field)).castMode(castMode).sql(" ").keyword("as").sql(" ").keyword("decimal").sql(") ").keyword("as").sql(" ").keyword(this.getDataType(context.configuration()).getCastTypeName(context.configuration())).sql(")");
                return;
            }
            if (this.field.getDataType().isNumeric() && SQLDataType.BOOLEAN.equals(this.getSQLDataType())) {
                context.visit(this.asDecodeNumberToBoolean());
                return;
            }
            if (this.field.getDataType().isString() && SQLDataType.BOOLEAN.equals(this.getSQLDataType())) {
                context.visit(this.asDecodeVarcharToBoolean());
                return;
            }
        }
        ((RenderContext)context.keyword("cast").sql("(").castMode(RenderContext.CastMode.NEVER).visit(this.field)).castMode(castMode).sql(" ").keyword("as").sql(" ").keyword(this.getDataType(context.configuration()).getCastTypeName(context.configuration())).sql(")");
    }

    private Field<Boolean> asDecodeNumberToBoolean() {
        return DSL.decode().value(this.field).when((Field<?>)DSL.inline(0), DSL.inline(false)).when(DSL.inline((Integer)null), DSL.inline((Boolean)null)).otherwise(DSL.inline(true));
    }

    private Field<Boolean> asDecodeVarcharToBoolean() {
        Field<String> s = this.field;
        return DSL.decode().when(s.equal(DSL.inline("0")), DSL.inline(false)).when(DSL.lower(s).equal(DSL.inline("false")), DSL.inline(false)).when(DSL.lower(s).equal(DSL.inline("f")), DSL.inline(false)).when(s.isNull(), DSL.inline((Boolean)null)).otherwise(DSL.inline(true));
    }

    @Override
    public final void bind(BindContext context) {
        if (context.configuration().dialect() == SQLDialect.DERBY) {
            if (this.field.getDataType().isNumeric() && SQLDataType.BOOLEAN.equals(this.getSQLDataType())) {
                context.visit(this.asDecodeNumberToBoolean());
                return;
            }
            if (this.field.getDataType().isString() && SQLDataType.BOOLEAN.equals(this.getSQLDataType())) {
                context.visit(this.asDecodeVarcharToBoolean());
                return;
            }
        }
        context.visit(this.field);
    }
}

