/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jooq.BindContext;
import org.jooq.Clause;
import org.jooq.Condition;
import org.jooq.Context;
import org.jooq.Operator;
import org.jooq.RenderContext;
import org.jooq.impl.AbstractCondition;
import org.jooq.impl.DSL;
import org.jooq.impl.Utils;

class CombinedCondition
extends AbstractCondition {
    private static final long serialVersionUID = -7373293246207052549L;
    private static final Clause[] CLAUSES_AND = new Clause[]{Clause.CONDITION, Clause.CONDITION_AND};
    private static final Clause[] CLAUSES_OR = new Clause[]{Clause.CONDITION, Clause.CONDITION_OR};
    private final Operator operator;
    private final List<Condition> conditions;

    CombinedCondition(Operator operator, Collection<? extends Condition> conditions) {
        if (operator == null) {
            throw new IllegalArgumentException("The argument 'operator' must not be null");
        }
        if (conditions == null) {
            throw new IllegalArgumentException("The argument 'conditions' must not be null");
        }
        for (Condition condition : conditions) {
            if (condition != null) continue;
            throw new IllegalArgumentException("The argument 'conditions' must not contain null");
        }
        this.operator = operator;
        this.conditions = new ArrayList<Condition>();
        this.init(operator, conditions);
    }

    private final void init(Operator op, Collection<? extends Condition> cond) {
        for (Condition condition : cond) {
            if (condition instanceof CombinedCondition) {
                CombinedCondition combinedCondition = (CombinedCondition)condition;
                if (combinedCondition.operator == op) {
                    this.conditions.addAll(combinedCondition.conditions);
                    continue;
                }
                this.conditions.add(condition);
                continue;
            }
            this.conditions.add(condition);
        }
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return this.operator == Operator.AND ? CLAUSES_AND : CLAUSES_OR;
    }

    @Override
    public final void bind(BindContext context) {
        Utils.visitAll(context, this.conditions);
    }

    @Override
    public final void toSQL(RenderContext context) {
        if (this.conditions.isEmpty()) {
            context.visit(DSL.trueCondition());
        } else if (this.conditions.size() == 1) {
            context.visit(this.conditions.get(0));
        } else {
            context.sql("(").formatIndentStart().formatNewLine();
            String operatorName = this.operator.name().toLowerCase() + " ";
            String separator = "";
            for (int i = 0; i < this.conditions.size(); ++i) {
                if (i > 0) {
                    context.formatSeparator();
                }
                context.keyword(separator);
                context.visit(this.conditions.get(i));
                separator = operatorName;
            }
            context.formatIndentEnd().formatNewLine().sql(")");
        }
    }
}

