/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Pattern;
import org.jooq.BindContext;
import org.jooq.Clause;
import org.jooq.Configuration;
import org.jooq.Context;
import org.jooq.Param;
import org.jooq.QueryPart;
import org.jooq.QueryPartInternal;
import org.jooq.RenderContext;
import org.jooq.SQLDialect;
import org.jooq.VisitContext;
import org.jooq.VisitListener;
import org.jooq.VisitListenerProvider;
import org.jooq.conf.ParamType;
import org.jooq.conf.RenderKeywordStyle;
import org.jooq.conf.RenderNameStyle;
import org.jooq.conf.Settings;
import org.jooq.exception.ControlFlowSignal;
import org.jooq.impl.AbstractContext;
import org.jooq.tools.JooqLogger;
import org.jooq.tools.StringUtils;

class DefaultRenderContext
extends AbstractContext<RenderContext>
implements RenderContext {
    private static final JooqLogger log = JooqLogger.getLogger(DefaultRenderContext.class);
    private static final Pattern IDENTIFIER_PATTERN = Pattern.compile("[A-Za-z][A-Za-z0-9_]*");
    private static final Pattern NEWLINE = Pattern.compile("[\\n\\r]");
    private static final Set<String> SQLITE_KEYWORDS = new HashSet<String>();
    private final StringBuilder sql;
    private ParamType paramType;
    private int params;
    private boolean qualify = true;
    private int alias;
    private RenderContext.CastMode castMode = RenderContext.CastMode.DEFAULT;
    private SQLDialect[] castDialects;
    private int indent;
    private Stack<Integer> indentLock = new Stack();
    private int printMargin = 80;
    private RenderKeywordStyle cachedRenderKeywordStyle;
    private RenderNameStyle cachedRenderNameStyle;
    private boolean cachedRenderFormatted;
    final VisitListener[] visitListeners;
    private final DefaultVisitContext visitContext;
    private final Deque<Clause> visitClauses;
    private final Deque<QueryPart> visitParts;

    DefaultRenderContext(Configuration configuration) {
        super(configuration);
        Settings settings = configuration.settings();
        this.sql = new StringBuilder();
        this.cachedRenderKeywordStyle = settings.getRenderKeywordStyle();
        this.cachedRenderFormatted = Boolean.TRUE.equals(settings.isRenderFormatted());
        this.cachedRenderNameStyle = settings.getRenderNameStyle();
        VisitListenerProvider[] providers = configuration.visitListenerProviders();
        this.visitListeners = new VisitListener[providers.length];
        this.visitContext = new DefaultVisitContext();
        this.visitClauses = new ArrayDeque<Clause>();
        this.visitParts = new ArrayDeque<QueryPart>();
        for (int i = 0; i < providers.length; ++i) {
            this.visitListeners[i] = providers[i].provide();
        }
    }

    DefaultRenderContext(RenderContext context) {
        this(context.configuration());
        this.paramType(context.paramType());
        this.qualify(context.qualify());
        this.castMode(context.castMode());
        this.declareFields(context.declareFields());
        this.declareTables(context.declareTables());
        this.data().putAll(context.data());
    }

    @Override
    public final RenderContext start(Clause clause) {
        if (clause != null) {
            this.visitClauses.addLast(clause);
            for (VisitListener listener : this.visitListeners) {
                listener.clauseStart(this.visitContext);
            }
        }
        return this;
    }

    @Override
    public final RenderContext end(Clause clause) {
        if (clause != null) {
            for (VisitListener listener : this.visitListeners) {
                listener.clauseEnd(this.visitContext);
            }
            if (this.visitClauses.removeLast() != clause) {
                throw new IllegalStateException("Mismatch between visited clauses!");
            }
        }
        return this;
    }

    @Override
    public final RenderContext visit(QueryPart part) {
        if (part != null) {
            QueryPart replacement;
            QueryPart original;
            Clause[] clauses;
            Clause[] clauseArray = clauses = this.visitListeners.length > 0 ? this.clause(part) : null;
            if (clauses != null) {
                for (int i = 0; i < clauses.length; ++i) {
                    this.start(clauses[i]);
                }
            }
            if ((original = part) == (replacement = this.start(part))) {
                super.visit(original);
            } else {
                this.visit(replacement);
            }
            this.end(replacement);
            if (clauses != null) {
                for (int i = clauses.length - 1; i >= 0; --i) {
                    this.end(clauses[i]);
                }
            }
        }
        return this;
    }

    private final QueryPart start(QueryPart part) {
        this.visitParts.addLast(part);
        for (VisitListener listener : this.visitListeners) {
            listener.visitStart(this.visitContext);
        }
        return this.visitParts.peekLast();
    }

    private final void end(QueryPart part) {
        for (VisitListener listener : this.visitListeners) {
            listener.visitEnd(this.visitContext);
        }
        if (this.visitParts.removeLast() != part) {
            throw new RuntimeException("Mismatch between visited query parts");
        }
    }

    private final Clause[] clause(QueryPart part) {
        if (part instanceof QueryPartInternal && this.data("org.jooq.configuration.omit-clause-event-emission") == null) {
            return ((QueryPartInternal)part).clauses(this);
        }
        return null;
    }

    @Override
    public final String peekAlias() {
        return "alias_" + (this.alias + 1);
    }

    @Override
    public final String nextAlias() {
        return "alias_" + ++this.alias;
    }

    @Override
    public final String render() {
        return this.sql.toString();
    }

    @Override
    public final String render(QueryPart part) {
        RenderContext local = new DefaultRenderContext(this).visit(part);
        return local.render();
    }

    @Override
    public final RenderContext keyword(String keyword) {
        if (RenderKeywordStyle.UPPER == this.cachedRenderKeywordStyle) {
            return this.sql(keyword.toUpperCase());
        }
        return this.sql(keyword.toLowerCase());
    }

    @Override
    public final RenderContext sql(String s) {
        return this.sql(s, s == null || !this.cachedRenderFormatted);
    }

    @Override
    public final RenderContext sql(String s, boolean literal) {
        if (literal) {
            this.sql.append(s);
        } else {
            this.sql.append(NEWLINE.matcher(s).replaceAll("$0" + this.indentation()));
        }
        return this;
    }

    @Override
    public final RenderContext sql(char c) {
        this.sql.append(c);
        return this;
    }

    @Override
    public final RenderContext sql(int i) {
        this.sql.append(i);
        return this;
    }

    @Override
    public final RenderContext formatNewLine() {
        if (this.cachedRenderFormatted) {
            this.sql.append("\n");
            this.sql.append(this.indentation());
        }
        return this;
    }

    @Override
    public final RenderContext formatNewLineAfterPrintMargin() {
        if (this.cachedRenderFormatted && this.printMargin > 0 && this.sql.length() - this.sql.lastIndexOf("\n") > this.printMargin) {
            this.formatNewLine();
        }
        return this;
    }

    private final String indentation() {
        return StringUtils.leftPad("", this.indent, " ");
    }

    @Override
    public final RenderContext format(boolean format) {
        this.cachedRenderFormatted = format;
        return this;
    }

    @Override
    public final boolean format() {
        return this.cachedRenderFormatted;
    }

    @Override
    public final RenderContext formatSeparator() {
        if (this.cachedRenderFormatted) {
            this.formatNewLine();
        } else {
            this.sql.append(" ");
        }
        return this;
    }

    @Override
    public final RenderContext formatIndentStart() {
        return this.formatIndentStart(2);
    }

    @Override
    public final RenderContext formatIndentEnd() {
        return this.formatIndentEnd(2);
    }

    @Override
    public final RenderContext formatIndentStart(int i) {
        if (this.cachedRenderFormatted) {
            this.indent += i;
        }
        return this;
    }

    @Override
    public final RenderContext formatIndentEnd(int i) {
        if (this.cachedRenderFormatted) {
            this.indent -= i;
        }
        return this;
    }

    @Override
    public final RenderContext formatIndentLockStart() {
        if (this.cachedRenderFormatted) {
            this.indentLock.push(this.indent);
            String[] lines = this.sql.toString().split("[\\n\\r]");
            this.indent = lines[lines.length - 1].length();
        }
        return this;
    }

    @Override
    public final RenderContext formatIndentLockEnd() {
        if (this.cachedRenderFormatted) {
            this.indent = this.indentLock.pop();
        }
        return this;
    }

    @Override
    public final RenderContext formatPrintMargin(int margin) {
        this.printMargin = margin;
        return this;
    }

    @Override
    public final RenderContext literal(String literal) {
        boolean needsQuote;
        if (literal == null) {
            return this;
        }
        boolean bl = needsQuote = RenderNameStyle.QUOTED == this.cachedRenderNameStyle && this.configuration.dialect() != SQLDialect.SQLITE || this.configuration.dialect() == SQLDialect.SQLITE && SQLITE_KEYWORDS.contains(literal.toUpperCase()) || !IDENTIFIER_PATTERN.matcher(literal).matches();
        if (RenderNameStyle.LOWER == this.cachedRenderNameStyle) {
            literal = literal.toLowerCase();
        } else if (RenderNameStyle.UPPER == this.cachedRenderNameStyle) {
            literal = literal.toUpperCase();
        }
        if (!needsQuote) {
            this.sql(literal);
        } else {
            switch (this.configuration.dialect().family()) {
                case MARIADB: 
                case MYSQL: {
                    this.sql("`").sql(StringUtils.replace(literal, "`", "``")).sql("`");
                    break;
                }
                default: {
                    this.sql('\"').sql(StringUtils.replace(literal, "\"", "\"\"")).sql('\"');
                }
            }
        }
        return this;
    }

    @Override
    @Deprecated
    public final RenderContext sql(QueryPart part) {
        return this.visit(part);
    }

    @Override
    protected final void visit0(QueryPartInternal internal) {
        this.checkForceInline(internal);
        internal.toSQL(this);
    }

    private final void checkForceInline(QueryPart part) throws ForceInlineSignal {
        if (this.paramType == ParamType.INLINED) {
            return;
        }
        if (part instanceof Param) {
            if (((Param)part).isInline()) {
                return;
            }
            switch (this.configuration().dialect().family()) {
                case SQLITE: {
                    this.checkForceInline(999);
                    return;
                }
            }
            return;
        }
    }

    private final void checkForceInline(int max) throws ForceInlineSignal {
        if (Boolean.TRUE.equals(this.data("org.jooq.configuration.count-bind-values")) && ++this.params > max) {
            throw new ForceInlineSignal();
        }
    }

    @Override
    public final boolean inline() {
        return this.paramType == ParamType.INLINED;
    }

    @Override
    @Deprecated
    public final RenderContext inline(boolean i) {
        this.paramType = i ? ParamType.INLINED : ParamType.INDEXED;
        return this;
    }

    @Override
    public final ParamType paramType() {
        return this.paramType;
    }

    @Override
    public final RenderContext paramType(ParamType p) {
        this.paramType = p;
        return this;
    }

    @Override
    public final boolean qualify() {
        return this.qualify;
    }

    @Override
    public final RenderContext qualify(boolean q) {
        this.qualify = q;
        return this;
    }

    @Override
    public final boolean namedParams() {
        return this.paramType == ParamType.NAMED;
    }

    @Override
    @Deprecated
    public final RenderContext namedParams(boolean r) {
        this.paramType = r ? ParamType.NAMED : ParamType.INDEXED;
        return this;
    }

    @Override
    public final RenderContext.CastMode castMode() {
        return this.castMode;
    }

    @Override
    public final RenderContext castMode(RenderContext.CastMode mode) {
        this.castMode = mode;
        this.castDialects = null;
        return this;
    }

    @Override
    public final Boolean cast() {
        switch (this.castMode) {
            case ALWAYS: {
                return true;
            }
            case NEVER: {
                return false;
            }
            case SOME: {
                return Arrays.asList(this.castDialects).contains((Object)this.configuration.dialect());
            }
        }
        return null;
    }

    @Override
    public final RenderContext castModeSome(SQLDialect ... dialects) {
        this.castMode = RenderContext.CastMode.SOME;
        this.castDialects = dialects;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("rendering    [");
        sb.append(this.render());
        sb.append("]\n");
        sb.append("parameters   [");
        sb.append((Object)this.paramType);
        sb.append("]\n");
        this.toString(sb);
        return sb.toString();
    }

    static {
        SQLITE_KEYWORDS.addAll(Arrays.asList("ABORT", "ACTION", "ADD", "AFTER", "ALL", "ALTER", "ANALYZE", "AND", "AS", "ASC", "ATTACH", "AUTOINCREMENT", "BEFORE", "BEGIN", "BETWEEN", "BY", "CASCADE", "CASE", "CAST", "CHECK", "COLLATE", "COLUMN", "COMMIT", "CONFLICT", "CONSTRAINT", "CREATE", "CROSS", "CURRENT_DATE", "CURRENT_TIME", "CURRENT_TIMESTAMP", "DATABASE", "DEFAULT", "DEFERRABLE", "DEFERRED", "DELETE", "DESC", "DETACH", "DISTINCT", "DROP", "EACH", "ELSE", "END", "ESCAPE", "EXCEPT", "EXCLUSIVE", "EXISTS", "EXPLAIN", "FAIL", "FOR", "FOREIGN", "FROM", "FULL", "GLOB", "GROUP", "HAVING", "IF", "IGNORE", "IMMEDIATE", "IN", "INDEX", "INDEXED", "INITIALLY", "INNER", "INSERT", "INSTEAD", "INTERSECT", "INTO", "IS", "ISNULL", "JOIN", "KEY", "LEFT", "LIKE", "LIMIT", "MATCH", "NATURAL", "NO", "NOT", "NOTNULL", "NULL", "OF", "OFFSET", "ON", "OR", "ORDER", "OUTER", "PLAN", "PRAGMA", "PRIMARY", "QUERY", "RAISE", "REFERENCES", "REGEXP", "REINDEX", "RELEASE", "RENAME", "REPLACE", "RESTRICT", "RIGHT", "ROLLBACK", "ROW", "SAVEPOINT", "SELECT", "SET", "TABLE", "TEMP", "TEMPORARY", "THEN", "TO", "TRANSACTION", "TRIGGER", "UNION", "UNIQUE", "UPDATE", "USING", "VACUUM", "VALUES", "VIEW", "VIRTUAL", "WHEN", "WHERE"));
    }

    class ForceInlineSignal
    extends ControlFlowSignal {
        private static final long serialVersionUID = -9131368742983295195L;

        public ForceInlineSignal() {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Re-render query", "Forcing bind variable inlining as " + (Object)((Object)DefaultRenderContext.this.configuration().dialect()) + " does not support " + DefaultRenderContext.this.params + " bind variables (or more) in a single query");
            }
        }
    }

    private class DefaultVisitContext
    implements VisitContext {
        private DefaultVisitContext() {
        }

        @Override
        public final Map<Object, Object> data() {
            return DefaultRenderContext.this.data();
        }

        @Override
        public final Object data(Object key) {
            return DefaultRenderContext.this.data(key);
        }

        @Override
        public final Object data(Object key, Object value) {
            return DefaultRenderContext.this.data(key, value);
        }

        @Override
        public final Configuration configuration() {
            return DefaultRenderContext.this.configuration();
        }

        @Override
        public final Clause clause() {
            return (Clause)((Object)DefaultRenderContext.this.visitClauses.peekLast());
        }

        @Override
        public final Clause[] clauses() {
            return DefaultRenderContext.this.visitClauses.toArray(new Clause[DefaultRenderContext.this.visitClauses.size()]);
        }

        @Override
        public final QueryPart queryPart() {
            return (QueryPart)DefaultRenderContext.this.visitParts.peekLast();
        }

        @Override
        public final void queryPart(QueryPart part) {
            DefaultRenderContext.this.visitParts.pollLast();
            DefaultRenderContext.this.visitParts.addLast(part);
        }

        @Override
        public final QueryPart[] queryParts() {
            return DefaultRenderContext.this.visitParts.toArray(new QueryPart[DefaultRenderContext.this.visitParts.size()]);
        }

        @Override
        public final Context<?> context() {
            return DefaultRenderContext.this;
        }

        @Override
        public final RenderContext renderContext() {
            return DefaultRenderContext.this;
        }

        @Override
        public final BindContext bindContext() {
            throw new UnsupportedOperationException("QueryPart traversal listening is currently only supported for RenderContext");
        }
    }
}

