/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.LinkedHashMap;
import java.util.Map;
import org.jooq.Converter;
import org.jooq.tools.Convert;

public class EnumConverter<T, U extends Enum<U>>
implements Converter<T, U> {
    private static final long serialVersionUID = -6094337837408829491L;
    private final Class<T> fromType;
    private final Class<U> toType;
    private final Map<T, U> lookup;
    private final EnumType enumType;

    public EnumConverter(Class<T> fromType, Class<U> toType) {
        this.fromType = fromType;
        this.toType = toType;
        this.enumType = Number.class.isAssignableFrom(fromType) ? EnumType.ORDINAL : EnumType.STRING;
        this.lookup = new LinkedHashMap<T, U>();
        for (Enum u : (Enum[])toType.getEnumConstants()) {
            this.lookup.put(this.to((U)u), u);
        }
    }

    @Override
    public final U from(T databaseObject) {
        return (U)((Enum)this.lookup.get(databaseObject));
    }

    @Override
    public T to(U userObject) {
        if (userObject == null) {
            return null;
        }
        if (this.enumType == EnumType.ORDINAL) {
            return Convert.convert((Object)((Enum)userObject).ordinal(), this.fromType);
        }
        return Convert.convert((Object)((Enum)userObject).name(), this.fromType);
    }

    @Override
    public final Class<T> fromType() {
        return this.fromType;
    }

    @Override
    public final Class<U> toType() {
        return this.toType;
    }

    static enum EnumType {
        ORDINAL,
        STRING;

    }
}

