/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import org.jooq.BindContext;
import org.jooq.Clause;
import org.jooq.Condition;
import org.jooq.Configuration;
import org.jooq.Context;
import org.jooq.Field;
import org.jooq.InsertQuery;
import org.jooq.Merge;
import org.jooq.MergeNotMatchedStep;
import org.jooq.MergeOnConditionStep;
import org.jooq.Record;
import org.jooq.RenderContext;
import org.jooq.SQLDialect;
import org.jooq.Table;
import org.jooq.exception.SQLDialectNotSupportedException;
import org.jooq.impl.AbstractStoreQuery;
import org.jooq.impl.FieldMapForInsert;
import org.jooq.impl.FieldMapForUpdate;
import org.jooq.impl.FieldMapsForInsert;
import org.jooq.impl.Utils;

class InsertQueryImpl<R extends Record>
extends AbstractStoreQuery<R>
implements InsertQuery<R> {
    private static final long serialVersionUID = 4466005417945353842L;
    private static final Clause[] CLAUSES = new Clause[]{Clause.INSERT};
    private final FieldMapForUpdate updateMap = new FieldMapForUpdate(Clause.INSERT_ON_DUPLICATE_KEY_UPDATE_ASSIGNMENT);
    private final FieldMapsForInsert insertMaps = new FieldMapsForInsert();
    private boolean onDuplicateKeyUpdate;
    private boolean onDuplicateKeyIgnore;

    InsertQueryImpl(Configuration configuration, Table<R> into) {
        super(configuration, into);
    }

    @Override
    public final void newRecord() {
        this.insertMaps.newRecord();
    }

    protected final FieldMapForInsert getValues() {
        return this.insertMaps.getMap();
    }

    @Override
    public final void addRecord(R record) {
        this.newRecord();
        this.setRecord(record);
    }

    @Override
    public final void onDuplicateKeyUpdate(boolean flag) {
        this.onDuplicateKeyIgnore = false;
        this.onDuplicateKeyUpdate = flag;
    }

    @Override
    public final void onDuplicateKeyIgnore(boolean flag) {
        this.onDuplicateKeyUpdate = false;
        this.onDuplicateKeyIgnore = flag;
    }

    @Override
    public final <T> void addValueForUpdate(Field<T> field, T value) {
        this.updateMap.put(field, Utils.field(value, field));
    }

    @Override
    public final <T> void addValueForUpdate(Field<T> field, Field<T> value) {
        this.updateMap.put(field, Utils.field(value, field));
    }

    @Override
    public final void addValuesForUpdate(Map<? extends Field<?>, ?> map) {
        this.updateMap.set(map);
    }

    @Override
    public final void addValues(Map<? extends Field<?>, ?> map) {
        this.insertMaps.getMap().set(map);
    }

    @Override
    public final void toSQL(RenderContext context) {
        block12: {
            block13: {
                block11: {
                    if (!this.onDuplicateKeyUpdate) break block11;
                    switch (context.configuration().dialect().family()) {
                        case CUBRID: 
                        case MARIADB: 
                        case MYSQL: {
                            this.toSQLInsert(context);
                            ((RenderContext)((RenderContext)context.formatSeparator().start(Clause.INSERT_ON_DUPLICATE_KEY_UPDATE)).keyword("on duplicate key update").sql(" ").visit(this.updateMap)).end(Clause.INSERT_ON_DUPLICATE_KEY_UPDATE);
                            break block12;
                        }
                        case H2: {
                            throw new SQLDialectNotSupportedException("The ON DUPLICATE KEY UPDATE clause cannot be simulated for " + (Object)((Object)context.configuration().dialect()));
                        }
                        case HSQLDB: {
                            context.visit(this.toMerge(context.configuration()));
                            break block12;
                        }
                        default: {
                            throw new SQLDialectNotSupportedException("The ON DUPLICATE KEY UPDATE clause cannot be simulated for " + (Object)((Object)context.configuration().dialect()));
                        }
                    }
                }
                if (!this.onDuplicateKeyIgnore) break block13;
                switch (context.configuration().dialect().family()) {
                    case MARIADB: 
                    case MYSQL: {
                        this.toSQLInsert(context);
                        ((RenderContext)context.start(Clause.INSERT_ON_DUPLICATE_KEY_UPDATE)).end(Clause.INSERT_ON_DUPLICATE_KEY_UPDATE);
                        break block12;
                    }
                    case CUBRID: {
                        FieldMapForUpdate update = new FieldMapForUpdate(Clause.INSERT_ON_DUPLICATE_KEY_UPDATE_ASSIGNMENT);
                        Field<?> field = this.getInto().field(0);
                        update.put(field, field);
                        this.toSQLInsert(context);
                        ((RenderContext)((RenderContext)context.formatSeparator().start(Clause.INSERT_ON_DUPLICATE_KEY_UPDATE)).keyword("on duplicate key update").sql(" ").visit(update)).end(Clause.INSERT_ON_DUPLICATE_KEY_UPDATE);
                        break block12;
                    }
                    case H2: {
                        throw new SQLDialectNotSupportedException("The ON DUPLICATE KEY IGNORE clause cannot be simulated for " + (Object)((Object)context.configuration().dialect()));
                    }
                    case HSQLDB: {
                        context.visit(this.toMerge(context.configuration()));
                        break block12;
                    }
                    default: {
                        throw new SQLDialectNotSupportedException("The ON DUPLICATE KEY IGNORE clause cannot be simulated for " + (Object)((Object)context.configuration().dialect()));
                    }
                }
            }
            this.toSQLInsert(context);
            ((RenderContext)context.start(Clause.INSERT_ON_DUPLICATE_KEY_UPDATE)).end(Clause.INSERT_ON_DUPLICATE_KEY_UPDATE);
        }
        context.start(Clause.INSERT_RETURNING);
        this.toSQLReturning(context);
        context.end(Clause.INSERT_RETURNING);
    }

    @Override
    public final void bind(BindContext context) {
        block12: {
            block13: {
                block11: {
                    if (!this.onDuplicateKeyUpdate) break block11;
                    switch (context.configuration().dialect().family()) {
                        case CUBRID: 
                        case MARIADB: 
                        case MYSQL: {
                            this.bindInsert(context);
                            break block12;
                        }
                        case H2: {
                            throw new SQLDialectNotSupportedException("The ON DUPLICATE KEY UPDATE clause cannot be simulated for " + (Object)((Object)context.configuration().dialect()));
                        }
                        case HSQLDB: {
                            context.visit(this.toMerge(context.configuration()));
                            break block12;
                        }
                        default: {
                            throw new SQLDialectNotSupportedException("The ON DUPLICATE KEY UPDATE clause cannot be simulated for " + (Object)((Object)context.configuration().dialect()));
                        }
                    }
                }
                if (!this.onDuplicateKeyIgnore) break block13;
                switch (context.configuration().dialect().family()) {
                    case MARIADB: 
                    case MYSQL: {
                        this.bindInsert(context);
                        break block12;
                    }
                    case CUBRID: {
                        this.bindInsert(context);
                        break block12;
                    }
                    case H2: {
                        throw new SQLDialectNotSupportedException("The ON DUPLICATE KEY IGNORE clause cannot be simulated for " + (Object)((Object)context.configuration().dialect()));
                    }
                    case HSQLDB: {
                        context.visit(this.toMerge(context.configuration()));
                        break block12;
                    }
                    default: {
                        throw new SQLDialectNotSupportedException("The ON DUPLICATE KEY IGNORE clause cannot be simulated for " + (Object)((Object)context.configuration().dialect()));
                    }
                }
            }
            this.bindInsert(context);
        }
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return CLAUSES;
    }

    private final void toSQLInsert(RenderContext context) {
        ((RenderContext)((RenderContext)context.start(Clause.INSERT_INSERT_INTO)).keyword("insert").sql(" ").keyword(this.onDuplicateKeyIgnore && Arrays.asList(SQLDialect.MARIADB, SQLDialect.MYSQL).contains((Object)context.configuration().dialect()) ? "ignore " : "").keyword("into").sql(" ").visit(this.getInto())).sql(" ");
        this.insertMaps.insertMaps.get(0).toSQLReferenceKeys(context);
        ((RenderContext)context.end(Clause.INSERT_INSERT_INTO)).visit(this.insertMaps);
    }

    private final void bindInsert(BindContext context) {
        ((BindContext)((BindContext)context.visit(this.getInto())).visit(this.insertMaps)).visit(this.updateMap);
        this.bindReturning(context);
    }

    private final Merge<R> toMerge(Configuration configuration) {
        Table into = this.getInto();
        if (into.getPrimaryKey() != null) {
            MergeOnConditionStep on;
            Condition condition = null;
            ArrayList<Field> key = new ArrayList<Field>();
            Iterator i$ = into.getPrimaryKey().getFields().iterator();
            while (i$.hasNext()) {
                Field f;
                Field field = f = (Field)i$.next();
                Field value = (Field)this.insertMaps.getMap().get(field);
                key.add(value);
                Condition other = field.equal(value);
                if (condition == null) {
                    condition = other;
                    continue;
                }
                condition = condition.and(other);
            }
            MergeNotMatchedStep notMatched = on = this.create(configuration).mergeInto(into).usingDual().on(condition);
            if (this.onDuplicateKeyUpdate) {
                notMatched = on.whenMatchedThenUpdate().set(this.updateMap);
            }
            return notMatched.whenNotMatchedThenInsert(this.insertMaps.getMap().keySet()).values(this.insertMaps.getMap().values());
        }
        throw new IllegalStateException("The ON DUPLICATE KEY IGNORE/UPDATE clause cannot be simulated when inserting into non-updatable tables : " + this.getInto());
    }

    @Override
    public final boolean isExecutable() {
        return this.insertMaps.isExecutable();
    }
}

