/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import org.jooq.BindContext;
import org.jooq.Clause;
import org.jooq.Context;
import org.jooq.Field;
import org.jooq.Param;
import org.jooq.RenderContext;
import org.jooq.conf.ParamType;
import org.jooq.impl.AbstractQueryPart;
import org.jooq.impl.DSL;

class Limit
extends AbstractQueryPart {
    private static final long serialVersionUID = 2053741242981425602L;
    private Field<Integer> numberOfRows;
    private Field<Integer> offset;
    private Field<Integer> offsetOrZero = DSL.val(0);
    private Field<Integer> offsetPlusOne = DSL.val(1);
    private boolean rendersParams;

    Limit() {
    }

    @Override
    public final void toSQL(RenderContext context) {
        ParamType paramType = context.paramType();
        RenderContext.CastMode castMode = context.castMode();
        switch (context.configuration().dialect()) {
            case MARIADB: 
            case MYSQL: 
            case H2: 
            case HSQLDB: 
            case POSTGRES: 
            case SQLITE: {
                ((RenderContext)((RenderContext)context.castMode(RenderContext.CastMode.NEVER).formatSeparator().keyword("limit").sql(" ").visit(this.numberOfRows)).sql(" ").keyword("offset").sql(" ").visit(this.offsetOrZero)).castMode(castMode);
                break;
            }
            case CUBRID: {
                ((RenderContext)((RenderContext)context.castMode(RenderContext.CastMode.NEVER).formatSeparator().keyword("limit").sql(" ").visit(this.offsetOrZero)).sql(", ").visit(this.numberOfRows)).castMode(castMode);
                break;
            }
            case FIREBIRD: {
                ((RenderContext)((RenderContext)context.castMode(RenderContext.CastMode.NEVER).formatSeparator().keyword("rows").sql(" ").visit(this.getLowerRownum().add(DSL.inline(1)))).sql(" ").keyword("to").sql(" ").visit(this.getUpperRownum())).castMode(castMode);
                break;
            }
            case DERBY: {
                ((RenderContext)((RenderContext)context.castMode(RenderContext.CastMode.NEVER).formatSeparator().keyword("offset").sql(" ").visit(this.offsetOrZero)).sql(" ").keyword("rows fetch next").sql(" ").visit(this.numberOfRows)).sql(" ").keyword("rows only").castMode(castMode);
                break;
            }
            default: {
                ((RenderContext)((RenderContext)context.castMode(RenderContext.CastMode.NEVER).formatSeparator().keyword("limit").sql(" ").visit(this.numberOfRows)).sql(" ").keyword("offset").sql(" ").visit(this.offsetOrZero)).castMode(castMode);
            }
        }
    }

    @Override
    public final void bind(BindContext context) {
        switch (context.configuration().dialect()) {
            case DERBY: {
                context.visit(this.offsetOrZero);
                context.visit(this.numberOfRows);
                break;
            }
            case MARIADB: 
            case MYSQL: 
            case H2: 
            case HSQLDB: 
            case POSTGRES: 
            case SQLITE: {
                context.visit(this.numberOfRows);
                context.visit(this.offsetOrZero);
                break;
            }
            case CUBRID: {
                context.visit(this.offsetOrZero);
                context.visit(this.numberOfRows);
                break;
            }
            case FIREBIRD: {
                context.visit(this.getLowerRownum());
                context.visit(this.getUpperRownum());
                break;
            }
            default: {
                context.visit(this.numberOfRows);
                context.visit(this.offsetOrZero);
            }
        }
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return null;
    }

    final boolean offsetZero() {
        return this.offset == null;
    }

    final Field<Integer> getLowerRownum() {
        return this.offsetOrZero;
    }

    final Field<Integer> getUpperRownum() {
        return this.offsetOrZero.add(this.numberOfRows);
    }

    final boolean isApplicable() {
        return this.offset != null || this.numberOfRows != null;
    }

    final boolean rendersParams() {
        return this.rendersParams;
    }

    final void setOffset(int offset) {
        if (offset != 0) {
            this.offset = DSL.val(offset);
            this.offsetOrZero = this.offset;
            this.offsetPlusOne = DSL.val(offset + 1);
        }
    }

    final void setOffset(Param<Integer> offset) {
        this.offset = offset;
        this.offsetOrZero = offset;
        this.rendersParams = true;
    }

    final void setNumberOfRows(int numberOfRows) {
        this.numberOfRows = DSL.val(numberOfRows);
    }

    final void setNumberOfRows(Param<Integer> numberOfRows) {
        this.numberOfRows = numberOfRows;
        this.rendersParams = true;
    }
}

