/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import org.jooq.BindContext;
import org.jooq.Clause;
import org.jooq.Context;
import org.jooq.Field;
import org.jooq.RenderContext;
import org.jooq.impl.AbstractCondition;
import org.jooq.impl.DSL;

class RegexpLike
extends AbstractCondition {
    private static final long serialVersionUID = 3162855665213654276L;
    private static final Clause[] CLAUSES = new Clause[]{Clause.CONDITION, Clause.CONDITION_COMPARISON};
    private final Field<?> search;
    private final Field<String> pattern;

    RegexpLike(Field<?> search, Field<String> pattern) {
        this.search = search;
        this.pattern = pattern;
    }

    @Override
    public final void toSQL(RenderContext context) {
        switch (context.configuration().dialect().family()) {
            case CUBRID: 
            case H2: 
            case MARIADB: 
            case MYSQL: 
            case SQLITE: {
                ((RenderContext)context.visit(this.search)).sql(" ").keyword("regexp").sql(" ").visit(this.pattern);
                break;
            }
            case HSQLDB: {
                context.visit(DSL.condition("{regexp_matches}({0}, {1})", this.search, this.pattern));
                break;
            }
            case POSTGRES: {
                context.visit(DSL.condition("{0} ~ {1}", this.search, this.pattern));
                break;
            }
            default: {
                ((RenderContext)context.visit(this.search)).sql(" ").keyword("like_regex").sql(" ").visit(this.pattern);
            }
        }
    }

    @Override
    public final void bind(BindContext context) {
        ((BindContext)context.visit(this.search)).visit(this.pattern);
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return CLAUSES;
    }
}

