/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.sql.ResultSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.jooq.Condition;
import org.jooq.Configuration;
import org.jooq.Converter;
import org.jooq.Cursor;
import org.jooq.Field;
import org.jooq.ForeignKey;
import org.jooq.FutureResult;
import org.jooq.GroupField;
import org.jooq.JoinType;
import org.jooq.Operator;
import org.jooq.Param;
import org.jooq.QueryPart;
import org.jooq.Record;
import org.jooq.RecordHandler;
import org.jooq.RecordMapper;
import org.jooq.Result;
import org.jooq.ResultQuery;
import org.jooq.Row;
import org.jooq.Select;
import org.jooq.SelectConditionStep;
import org.jooq.SelectConnectByConditionStep;
import org.jooq.SelectForUpdateOfStep;
import org.jooq.SelectHavingConditionStep;
import org.jooq.SelectJoinStep;
import org.jooq.SelectOffsetStep;
import org.jooq.SelectOnConditionStep;
import org.jooq.SelectOnStep;
import org.jooq.SelectOptionalOnStep;
import org.jooq.SelectQuery;
import org.jooq.SelectSelectStep;
import org.jooq.SortField;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.TableLike;
import org.jooq.exception.DataAccessException;
import org.jooq.impl.AbstractDelegatingQuery;
import org.jooq.impl.ConditionProviderImpl;
import org.jooq.impl.DSL;
import org.jooq.impl.SelectQueryImpl;

class SelectImpl<R extends Record>
extends AbstractDelegatingQuery<Select<R>>
implements SelectSelectStep<R>,
SelectOptionalOnStep<R>,
SelectOnConditionStep<R>,
SelectConditionStep<R>,
SelectConnectByConditionStep<R>,
SelectHavingConditionStep<R>,
SelectOffsetStep<R>,
SelectForUpdateOfStep<R> {
    private static final long serialVersionUID = -5425308887382166448L;
    private transient TableLike<?> joinTable;
    private transient Field<?>[] joinPartitionBy;
    private transient JoinType joinType;
    private transient ConditionProviderImpl joinConditions;
    private transient ConditionStep conditionStep;
    private transient Integer limit;
    private transient Param<Integer> limitParam;

    SelectImpl(Configuration configuration) {
        this(configuration, false);
    }

    SelectImpl(Configuration configuration, boolean distinct) {
        this(new SelectQueryImpl(configuration, distinct));
    }

    SelectImpl(Select<R> query) {
        super(query);
    }

    @Override
    public final SelectQuery<R> getQuery() {
        return (SelectQuery)this.getDelegate();
    }

    @Override
    public final int fetchCount() {
        return ((Select)this.getDelegate()).fetchCount();
    }

    public final SelectImpl select(Field<?> ... fields) {
        this.getQuery().addSelect(fields);
        return this;
    }

    public final SelectImpl select(Collection<? extends Field<?>> fields) {
        this.getQuery().addSelect(fields);
        return this;
    }

    @Override
    public final SelectImpl<R> hint(String hint) {
        this.getQuery().addHint(hint);
        return this;
    }

    @Override
    public final SelectImpl<R> option(String hint) {
        this.getQuery().addOption(hint);
        return this;
    }

    @Override
    public final SelectImpl<R> from(TableLike<?> ... tables) {
        this.getQuery().addFrom(tables);
        return this;
    }

    @Override
    public final SelectImpl<R> from(Collection<? extends TableLike<?>> tables) {
        this.getQuery().addFrom(tables);
        return this;
    }

    @Override
    public final SelectImpl<R> from(String sql) {
        return this.from(new TableLike[]{DSL.table(sql)});
    }

    @Override
    public final SelectImpl<R> from(String sql, Object ... bindings) {
        return this.from(new TableLike[]{DSL.table(sql, bindings)});
    }

    @Override
    public final SelectImpl<R> from(String sql, QueryPart ... parts) {
        return this.from(new TableLike[]{DSL.table(sql, parts)});
    }

    @Override
    public final SelectImpl<R> where(Condition ... conditions) {
        this.conditionStep = ConditionStep.WHERE;
        this.getQuery().addConditions(conditions);
        return this;
    }

    @Override
    public final SelectImpl<R> where(Collection<? extends Condition> conditions) {
        this.conditionStep = ConditionStep.WHERE;
        this.getQuery().addConditions(conditions);
        return this;
    }

    @Override
    public final SelectImpl<R> where(Field<Boolean> condition) {
        return this.where(new Condition[]{DSL.condition(condition)});
    }

    @Override
    public final SelectImpl<R> where(String sql) {
        return this.where(new Condition[]{DSL.condition(sql)});
    }

    @Override
    public final SelectImpl<R> where(String sql, Object ... bindings) {
        return this.where(new Condition[]{DSL.condition(sql, bindings)});
    }

    @Override
    public final SelectImpl<R> where(String sql, QueryPart ... parts) {
        return this.where(new Condition[]{DSL.condition(sql, parts)});
    }

    @Override
    public final SelectImpl<R> whereExists(Select<?> select) {
        this.conditionStep = ConditionStep.WHERE;
        return this.andExists((Select)select);
    }

    @Override
    public final SelectImpl<R> whereNotExists(Select<?> select) {
        this.conditionStep = ConditionStep.WHERE;
        return this.andNotExists((Select)select);
    }

    @Override
    public final SelectImpl<R> and(Condition condition) {
        switch (this.conditionStep) {
            case WHERE: {
                this.getQuery().addConditions(condition);
                break;
            }
            case CONNECT_BY: {
                this.getQuery().addConnectBy(condition);
                break;
            }
            case HAVING: {
                this.getQuery().addHaving(condition);
                break;
            }
            case ON: {
                this.joinConditions.addConditions(condition);
            }
        }
        return this;
    }

    @Override
    public final SelectImpl<R> and(Field<Boolean> condition) {
        return this.and(DSL.condition(condition));
    }

    @Override
    public final SelectImpl<R> and(String sql) {
        return this.and(DSL.condition(sql));
    }

    @Override
    public final SelectImpl<R> and(String sql, Object ... bindings) {
        return this.and(DSL.condition(sql, bindings));
    }

    @Override
    public final SelectImpl<R> and(String sql, QueryPart ... parts) {
        return this.and(DSL.condition(sql, parts));
    }

    @Override
    public final SelectImpl<R> andNot(Condition condition) {
        return this.and(condition.not());
    }

    @Override
    public final SelectImpl<R> andNot(Field<Boolean> condition) {
        return this.andNot(DSL.condition(condition));
    }

    @Override
    public final SelectImpl<R> andExists(Select<?> select) {
        return this.and(DSL.exists(select));
    }

    @Override
    public final SelectImpl<R> andNotExists(Select<?> select) {
        return this.and(DSL.notExists(select));
    }

    @Override
    public final SelectImpl<R> or(Condition condition) {
        switch (this.conditionStep) {
            case WHERE: {
                this.getQuery().addConditions(Operator.OR, condition);
                break;
            }
            case CONNECT_BY: {
                throw new IllegalStateException("Cannot connect conditions for the CONNECT BY clause using the OR operator");
            }
            case HAVING: {
                this.getQuery().addHaving(Operator.OR, condition);
                break;
            }
            case ON: {
                this.joinConditions.addConditions(Operator.OR, condition);
            }
        }
        return this;
    }

    @Override
    public final SelectImpl<R> or(Field<Boolean> condition) {
        return this.or(DSL.condition(condition));
    }

    @Override
    public final SelectImpl<R> or(String sql) {
        return this.or(DSL.condition(sql));
    }

    @Override
    public final SelectImpl<R> or(String sql, Object ... bindings) {
        return this.or(DSL.condition(sql, bindings));
    }

    @Override
    public final SelectImpl<R> or(String sql, QueryPart ... parts) {
        return this.or(DSL.condition(sql, parts));
    }

    @Override
    public final SelectImpl<R> orNot(Condition condition) {
        return this.or(condition.not());
    }

    @Override
    public final SelectImpl<R> orNot(Field<Boolean> condition) {
        return this.orNot(DSL.condition(condition));
    }

    @Override
    public final SelectImpl<R> orExists(Select<?> select) {
        return this.or(DSL.exists(select));
    }

    @Override
    public final SelectImpl<R> orNotExists(Select<?> select) {
        return this.or(DSL.notExists(select));
    }

    @Override
    public final SelectImpl<R> connectBy(Condition condition) {
        this.conditionStep = ConditionStep.CONNECT_BY;
        this.getQuery().addConnectBy(condition);
        return this;
    }

    @Override
    public final SelectImpl<R> connectBy(Field<Boolean> condition) {
        return this.connectBy(DSL.condition(condition));
    }

    @Override
    public final SelectImpl<R> connectBy(String sql) {
        return this.connectBy(DSL.condition(sql));
    }

    @Override
    public final SelectImpl<R> connectBy(String sql, Object ... bindings) {
        return this.connectBy(DSL.condition(sql, bindings));
    }

    @Override
    public final SelectImpl<R> connectBy(String sql, QueryPart ... parts) {
        return this.connectBy(DSL.condition(sql, parts));
    }

    @Override
    public final SelectImpl<R> connectByNoCycle(Condition condition) {
        this.conditionStep = ConditionStep.CONNECT_BY;
        this.getQuery().addConnectByNoCycle(condition);
        return this;
    }

    @Override
    public final SelectImpl<R> connectByNoCycle(Field<Boolean> condition) {
        return this.connectByNoCycle(DSL.condition(condition));
    }

    @Override
    public final SelectImpl<R> connectByNoCycle(String sql) {
        return this.connectByNoCycle(DSL.condition(sql));
    }

    @Override
    public final SelectImpl<R> connectByNoCycle(String sql, Object ... bindings) {
        return this.connectByNoCycle(DSL.condition(sql, bindings));
    }

    @Override
    public final SelectImpl<R> connectByNoCycle(String sql, QueryPart ... parts) {
        return this.connectByNoCycle(DSL.condition(sql, parts));
    }

    @Override
    public final SelectImpl<R> startWith(Condition condition) {
        this.getQuery().setConnectByStartWith(condition);
        return this;
    }

    @Override
    public final SelectImpl<R> startWith(Field<Boolean> condition) {
        return this.startWith(DSL.condition(condition));
    }

    @Override
    public final SelectImpl<R> startWith(String sql) {
        return this.startWith(DSL.condition(sql));
    }

    @Override
    public final SelectImpl<R> startWith(String sql, Object ... bindings) {
        return this.startWith(DSL.condition(sql, bindings));
    }

    @Override
    public final SelectImpl<R> startWith(String sql, QueryPart ... parts) {
        return this.startWith(DSL.condition(sql, parts));
    }

    @Override
    public final SelectImpl<R> groupBy(GroupField ... fields) {
        this.getQuery().addGroupBy(fields);
        return this;
    }

    @Override
    public final SelectImpl<R> groupBy(Collection<? extends GroupField> fields) {
        this.getQuery().addGroupBy(fields);
        return this;
    }

    @Override
    public final SelectImpl<R> orderBy(Field<?> ... fields) {
        this.getQuery().addOrderBy(fields);
        return this;
    }

    @Override
    public final SelectImpl<R> orderBy(SortField<?> ... fields) {
        this.getQuery().addOrderBy(fields);
        return this;
    }

    @Override
    public final SelectImpl<R> orderBy(Collection<? extends SortField<?>> fields) {
        this.getQuery().addOrderBy(fields);
        return this;
    }

    @Override
    public final SelectImpl<R> orderBy(int ... fieldIndexes) {
        this.getQuery().addOrderBy(fieldIndexes);
        return this;
    }

    @Override
    public final SelectImpl<R> orderSiblingsBy(Field<?> ... fields) {
        this.getQuery().addOrderBy(fields);
        this.getQuery().setOrderBySiblings(true);
        return this;
    }

    @Override
    public final SelectImpl<R> orderSiblingsBy(SortField<?> ... fields) {
        this.getQuery().addOrderBy(fields);
        this.getQuery().setOrderBySiblings(true);
        return this;
    }

    @Override
    public final SelectImpl<R> orderSiblingsBy(Collection<? extends SortField<?>> fields) {
        this.getQuery().addOrderBy(fields);
        this.getQuery().setOrderBySiblings(true);
        return this;
    }

    @Override
    public final SelectImpl<R> orderSiblingsBy(int ... fieldIndexes) {
        this.getQuery().addOrderBy(fieldIndexes);
        this.getQuery().setOrderBySiblings(true);
        return this;
    }

    @Override
    public final SelectImpl<R> limit(int numberOfRows) {
        this.limit = numberOfRows;
        this.limitParam = null;
        this.getQuery().addLimit(numberOfRows);
        return this;
    }

    @Override
    public final SelectImpl<R> limit(Param<Integer> numberOfRows) {
        this.limit = null;
        this.limitParam = numberOfRows;
        this.getQuery().addLimit(numberOfRows);
        return this;
    }

    @Override
    public final SelectImpl<R> limit(int offset, int numberOfRows) {
        this.getQuery().addLimit(offset, numberOfRows);
        return this;
    }

    @Override
    public final SelectImpl<R> limit(int offset, Param<Integer> numberOfRows) {
        this.getQuery().addLimit(offset, numberOfRows);
        return this;
    }

    @Override
    public final SelectImpl<R> limit(Param<Integer> offset, int numberOfRows) {
        this.getQuery().addLimit(offset, numberOfRows);
        return this;
    }

    @Override
    public final SelectImpl<R> limit(Param<Integer> offset, Param<Integer> numberOfRows) {
        this.getQuery().addLimit(offset, numberOfRows);
        return this;
    }

    @Override
    public final SelectImpl<R> offset(int offset) {
        if (this.limit != null) {
            this.getQuery().addLimit(offset, (int)this.limit);
        } else if (this.limitParam != null) {
            this.getQuery().addLimit(offset, this.limitParam);
        }
        return this;
    }

    @Override
    public final SelectImpl<R> offset(Param<Integer> offset) {
        if (this.limit != null) {
            this.getQuery().addLimit(offset, (int)this.limit);
        } else if (this.limitParam != null) {
            this.getQuery().addLimit(offset, this.limitParam);
        }
        return this;
    }

    @Override
    public final SelectImpl<R> forUpdate() {
        this.getQuery().setForUpdate(true);
        return this;
    }

    @Override
    public final SelectImpl<R> of(Field<?> ... fields) {
        this.getQuery().setForUpdateOf(fields);
        return this;
    }

    @Override
    public final SelectImpl<R> of(Collection<? extends Field<?>> fields) {
        this.getQuery().setForUpdateOf(fields);
        return this;
    }

    @Override
    public final SelectImpl<R> of(Table<?> ... tables) {
        this.getQuery().setForUpdateOf(tables);
        return this;
    }

    @Override
    public final SelectImpl<R> noWait() {
        this.getQuery().setForUpdateNoWait();
        return this;
    }

    @Override
    public final SelectImpl<R> forShare() {
        this.getQuery().setForShare(true);
        return this;
    }

    @Override
    public final SelectImpl<R> union(Select<? extends R> select) {
        return new SelectImpl<R>(((Select)this.getDelegate()).union(select));
    }

    @Override
    public final SelectImpl<R> unionAll(Select<? extends R> select) {
        return new SelectImpl<R>(((Select)this.getDelegate()).unionAll(select));
    }

    @Override
    public final SelectImpl<R> except(Select<? extends R> select) {
        return new SelectImpl<R>(((Select)this.getDelegate()).except(select));
    }

    @Override
    public final SelectImpl<R> intersect(Select<? extends R> select) {
        return new SelectImpl<R>(((Select)this.getDelegate()).intersect(select));
    }

    @Override
    public final SelectImpl<R> having(Condition ... conditions) {
        this.conditionStep = ConditionStep.HAVING;
        this.getQuery().addHaving(conditions);
        return this;
    }

    @Override
    public final SelectImpl<R> having(Collection<? extends Condition> conditions) {
        this.conditionStep = ConditionStep.HAVING;
        this.getQuery().addHaving(conditions);
        return this;
    }

    @Override
    public final SelectImpl<R> having(Field<Boolean> condition) {
        return this.having(new Condition[]{DSL.condition(condition)});
    }

    @Override
    public final SelectImpl<R> having(String sql) {
        return this.having(new Condition[]{DSL.condition(sql)});
    }

    @Override
    public final SelectImpl<R> having(String sql, Object ... bindings) {
        return this.having(new Condition[]{DSL.condition(sql, bindings)});
    }

    @Override
    public final SelectImpl<R> having(String sql, QueryPart ... parts) {
        return this.having(new Condition[]{DSL.condition(sql, parts)});
    }

    @Override
    public final SelectImpl<R> on(Condition ... conditions) {
        this.conditionStep = ConditionStep.ON;
        this.joinConditions = new ConditionProviderImpl();
        this.joinConditions.addConditions(conditions);
        this.getQuery().addJoin(this.joinTable, this.joinType, this.joinConditions);
        this.joinTable = null;
        this.joinPartitionBy = null;
        this.joinType = null;
        return this;
    }

    @Override
    public final SelectImpl<R> on(Field<Boolean> condition) {
        return this.on(new Condition[]{DSL.condition(condition)});
    }

    @Override
    public final SelectImpl<R> on(String sql) {
        return this.on(new Condition[]{DSL.condition(sql)});
    }

    @Override
    public final SelectImpl<R> on(String sql, Object ... bindings) {
        return this.on(new Condition[]{DSL.condition(sql, bindings)});
    }

    @Override
    public final SelectImpl<R> on(String sql, QueryPart ... parts) {
        return this.on(new Condition[]{DSL.condition(sql, parts)});
    }

    @Override
    public final SelectImpl<R> onKey() throws DataAccessException {
        this.conditionStep = ConditionStep.ON;
        this.getQuery().addJoinOnKey(this.joinTable, this.joinType);
        this.joinTable = null;
        this.joinPartitionBy = null;
        this.joinType = null;
        return this;
    }

    @Override
    public final SelectImpl<R> onKey(TableField<?, ?> ... keyFields) throws DataAccessException {
        this.conditionStep = ConditionStep.ON;
        this.getQuery().addJoinOnKey(this.joinTable, this.joinType, keyFields);
        this.joinTable = null;
        this.joinPartitionBy = null;
        this.joinType = null;
        return this;
    }

    @Override
    public final SelectImpl<R> onKey(ForeignKey<?, ?> key) {
        this.conditionStep = ConditionStep.ON;
        this.getQuery().addJoinOnKey(this.joinTable, this.joinType, key);
        this.joinTable = null;
        this.joinPartitionBy = null;
        this.joinType = null;
        return this;
    }

    @Override
    public final SelectImpl<R> using(Field<?> ... fields) {
        return this.using(Arrays.asList(fields));
    }

    @Override
    public final SelectImpl<R> using(Collection<? extends Field<?>> fields) {
        this.getQuery().addJoinUsing(this.joinTable, this.joinType, fields);
        this.joinTable = null;
        this.joinPartitionBy = null;
        this.joinType = null;
        return this;
    }

    @Override
    public final SelectImpl<R> join(TableLike<?> table) {
        return this.join((TableLike)table, JoinType.JOIN);
    }

    @Override
    public final SelectImpl<R> leftOuterJoin(TableLike<?> table) {
        return this.join((TableLike)table, JoinType.LEFT_OUTER_JOIN);
    }

    @Override
    public final SelectImpl<R> rightOuterJoin(TableLike<?> table) {
        return this.join((TableLike)table, JoinType.RIGHT_OUTER_JOIN);
    }

    @Override
    public final SelectOnStep<R> fullOuterJoin(TableLike<?> table) {
        return this.join((TableLike)table, JoinType.FULL_OUTER_JOIN);
    }

    @Override
    public final SelectImpl<R> join(TableLike<?> table, JoinType type) {
        switch (type) {
            case CROSS_JOIN: 
            case NATURAL_JOIN: 
            case NATURAL_LEFT_OUTER_JOIN: 
            case NATURAL_RIGHT_OUTER_JOIN: {
                this.getQuery().addJoin(table, type, new Condition[0]);
                this.joinTable = null;
                this.joinPartitionBy = null;
                this.joinType = null;
                return this;
            }
        }
        this.conditionStep = ConditionStep.ON;
        this.joinTable = table;
        this.joinType = type;
        this.joinPartitionBy = null;
        this.joinConditions = null;
        return this;
    }

    @Override
    public final SelectJoinStep<R> crossJoin(TableLike<?> table) {
        return this.join((TableLike)table, JoinType.CROSS_JOIN);
    }

    @Override
    public final SelectImpl<R> naturalJoin(TableLike<?> table) {
        return this.join((TableLike)table, JoinType.NATURAL_JOIN);
    }

    @Override
    public final SelectImpl<R> naturalLeftOuterJoin(TableLike<?> table) {
        return this.join((TableLike)table, JoinType.NATURAL_LEFT_OUTER_JOIN);
    }

    @Override
    public final SelectImpl<R> naturalRightOuterJoin(TableLike<?> table) {
        return this.join((TableLike)table, JoinType.NATURAL_RIGHT_OUTER_JOIN);
    }

    @Override
    public final SelectImpl<R> join(String sql) {
        return this.join(DSL.table(sql));
    }

    @Override
    public final SelectImpl<R> join(String sql, Object ... bindings) {
        return this.join(DSL.table(sql, bindings));
    }

    @Override
    public final SelectImpl<R> join(String sql, QueryPart ... parts) {
        return this.join(DSL.table(sql, parts));
    }

    @Override
    public final SelectImpl<R> leftOuterJoin(String sql) {
        return this.leftOuterJoin(DSL.table(sql));
    }

    @Override
    public final SelectImpl<R> leftOuterJoin(String sql, Object ... bindings) {
        return this.leftOuterJoin(DSL.table(sql, bindings));
    }

    @Override
    public final SelectImpl<R> leftOuterJoin(String sql, QueryPart ... parts) {
        return this.leftOuterJoin(DSL.table(sql, parts));
    }

    @Override
    public final SelectImpl<R> rightOuterJoin(String sql) {
        return this.rightOuterJoin(DSL.table(sql));
    }

    @Override
    public final SelectImpl<R> rightOuterJoin(String sql, Object ... bindings) {
        return this.rightOuterJoin(DSL.table(sql, bindings));
    }

    @Override
    public final SelectImpl<R> rightOuterJoin(String sql, QueryPart ... parts) {
        return this.rightOuterJoin(DSL.table(sql, parts));
    }

    @Override
    public final SelectOnStep<R> fullOuterJoin(String sql) {
        return this.fullOuterJoin(DSL.table(sql));
    }

    @Override
    public final SelectOnStep<R> fullOuterJoin(String sql, Object ... bindings) {
        return this.fullOuterJoin(DSL.table(sql, bindings));
    }

    @Override
    public final SelectOnStep<R> fullOuterJoin(String sql, QueryPart ... parts) {
        return this.fullOuterJoin(DSL.table(sql, parts));
    }

    @Override
    public final SelectJoinStep<R> crossJoin(String sql) {
        return this.crossJoin(DSL.table(sql));
    }

    @Override
    public final SelectJoinStep<R> crossJoin(String sql, Object ... bindings) {
        return this.crossJoin(DSL.table(sql, bindings));
    }

    @Override
    public final SelectJoinStep<R> crossJoin(String sql, QueryPart ... parts) {
        return this.crossJoin(DSL.table(sql, parts));
    }

    @Override
    public final SelectImpl<R> naturalJoin(String sql) {
        return this.naturalJoin(DSL.table(sql));
    }

    @Override
    public final SelectImpl<R> naturalJoin(String sql, Object ... bindings) {
        return this.naturalJoin(DSL.table(sql, bindings));
    }

    @Override
    public final SelectImpl<R> naturalJoin(String sql, QueryPart ... parts) {
        return this.naturalJoin(DSL.table(sql, parts));
    }

    @Override
    public final SelectImpl<R> naturalLeftOuterJoin(String sql) {
        return this.naturalLeftOuterJoin(DSL.table(sql));
    }

    @Override
    public final SelectImpl<R> naturalLeftOuterJoin(String sql, Object ... bindings) {
        return this.naturalLeftOuterJoin(DSL.table(sql, bindings));
    }

    @Override
    public final SelectImpl<R> naturalLeftOuterJoin(String sql, QueryPart ... parts) {
        return this.naturalLeftOuterJoin(DSL.table(sql, parts));
    }

    @Override
    public final SelectImpl<R> naturalRightOuterJoin(String sql) {
        return this.naturalRightOuterJoin(DSL.table(sql));
    }

    @Override
    public final SelectImpl<R> naturalRightOuterJoin(String sql, Object ... bindings) {
        return this.naturalRightOuterJoin(DSL.table(sql, bindings));
    }

    @Override
    public final SelectImpl<R> naturalRightOuterJoin(String sql, QueryPart ... parts) {
        return this.naturalRightOuterJoin(DSL.table(sql, parts));
    }

    @Override
    public final ResultQuery<R> maxRows(int rows) {
        return ((Select)this.getDelegate()).maxRows(rows);
    }

    @Override
    public final ResultQuery<R> resultSetConcurrency(int resultSetConcurrency) {
        return ((Select)this.getDelegate()).resultSetConcurrency(resultSetConcurrency);
    }

    @Override
    public final ResultQuery<R> resultSetType(int resultSetType) {
        return ((Select)this.getDelegate()).resultSetType(resultSetType);
    }

    @Override
    public final ResultQuery<R> resultSetHoldability(int resultSetHoldability) {
        return ((Select)this.getDelegate()).resultSetHoldability(resultSetHoldability);
    }

    @Override
    public final ResultQuery<R> intern(Field<?> ... fields) {
        return ((Select)this.getDelegate()).intern(fields);
    }

    @Override
    public final ResultQuery<R> intern(int ... fieldIndexes) {
        return ((Select)this.getDelegate()).intern(fieldIndexes);
    }

    @Override
    public final ResultQuery<R> intern(String ... fieldNames) {
        return ((Select)this.getDelegate()).intern(fieldNames);
    }

    @Override
    public final Class<? extends R> getRecordType() {
        return ((Select)this.getDelegate()).getRecordType();
    }

    @Override
    public final List<Field<?>> getSelect() {
        return ((Select)this.getDelegate()).getSelect();
    }

    @Override
    public final Result<R> getResult() {
        return ((Select)this.getDelegate()).getResult();
    }

    @Override
    public final Result<R> fetch() {
        return ((Select)this.getDelegate()).fetch();
    }

    @Override
    public final ResultSet fetchResultSet() {
        return ((Select)this.getDelegate()).fetchResultSet();
    }

    @Override
    public final Cursor<R> fetchLazy() {
        return ((Select)this.getDelegate()).fetchLazy();
    }

    @Override
    public final Cursor<R> fetchLazy(int fetchSize) {
        return ((Select)this.getDelegate()).fetchLazy(fetchSize);
    }

    @Override
    public final List<Result<Record>> fetchMany() {
        return ((Select)this.getDelegate()).fetchMany();
    }

    @Override
    public final <T> List<T> fetch(Field<T> field) {
        return ((Select)this.getDelegate()).fetch(field);
    }

    @Override
    public final <T> List<T> fetch(Field<?> field, Class<? extends T> type) {
        return ((Select)this.getDelegate()).fetch(field, type);
    }

    @Override
    public final <T, U> List<U> fetch(Field<T> field, Converter<? super T, U> converter) {
        return ((Select)this.getDelegate()).fetch(field, converter);
    }

    @Override
    public final List<?> fetch(int fieldIndex) {
        return ((Select)this.getDelegate()).fetch(fieldIndex);
    }

    @Override
    public final <T> List<T> fetch(int fieldIndex, Class<? extends T> type) {
        return ((Select)this.getDelegate()).fetch(fieldIndex, type);
    }

    @Override
    public final <U> List<U> fetch(int fieldIndex, Converter<?, U> converter) {
        return ((Select)this.getDelegate()).fetch(fieldIndex, converter);
    }

    @Override
    public final List<?> fetch(String fieldName) {
        return ((Select)this.getDelegate()).fetch(fieldName);
    }

    @Override
    public final <T> List<T> fetch(String fieldName, Class<? extends T> type) {
        return ((Select)this.getDelegate()).fetch(fieldName, type);
    }

    @Override
    public final <U> List<U> fetch(String fieldName, Converter<?, U> converter) {
        return ((Select)this.getDelegate()).fetch(fieldName, converter);
    }

    @Override
    public final <T> T fetchOne(Field<T> field) {
        return ((Select)this.getDelegate()).fetchOne(field);
    }

    @Override
    public final <T> T fetchOne(Field<?> field, Class<? extends T> type) {
        return ((Select)this.getDelegate()).fetchOne(field, type);
    }

    @Override
    public final <T, U> U fetchOne(Field<T> field, Converter<? super T, U> converter) {
        return ((Select)this.getDelegate()).fetchOne(field, converter);
    }

    @Override
    public final Object fetchOne(int fieldIndex) {
        return ((Select)this.getDelegate()).fetchOne(fieldIndex);
    }

    @Override
    public final <T> T fetchOne(int fieldIndex, Class<? extends T> type) {
        return ((Select)this.getDelegate()).fetchOne(fieldIndex, type);
    }

    @Override
    public final <U> U fetchOne(int fieldIndex, Converter<?, U> converter) {
        return ((Select)this.getDelegate()).fetchOne(fieldIndex, converter);
    }

    @Override
    public final Object fetchOne(String fieldName) {
        return ((Select)this.getDelegate()).fetchOne(fieldName);
    }

    @Override
    public final <T> T fetchOne(String fieldName, Class<? extends T> type) {
        return ((Select)this.getDelegate()).fetchOne(fieldName, type);
    }

    @Override
    public final <U> U fetchOne(String fieldName, Converter<?, U> converter) {
        return ((Select)this.getDelegate()).fetchOne(fieldName, converter);
    }

    @Override
    public final R fetchOne() {
        return ((Select)this.getDelegate()).fetchOne();
    }

    @Override
    public final R fetchAny() {
        return ((Select)this.getDelegate()).fetchAny();
    }

    @Override
    public final <K> Map<K, R> fetchMap(Field<K> key) {
        return ((Select)this.getDelegate()).fetchMap(key);
    }

    @Override
    public final <K, V> Map<K, V> fetchMap(Field<K> key, Field<V> value) {
        return ((Select)this.getDelegate()).fetchMap(key, value);
    }

    @Override
    public final Map<Record, R> fetchMap(Field<?>[] keys) {
        return ((Select)this.getDelegate()).fetchMap(keys);
    }

    @Override
    public final <E> Map<List<?>, E> fetchMap(Field<?>[] keys, Class<? extends E> type) {
        return ((Select)this.getDelegate()).fetchMap(keys, type);
    }

    @Override
    public final <K, E> Map<K, E> fetchMap(Field<K> key, Class<? extends E> type) {
        return ((Select)this.getDelegate()).fetchMap(key, type);
    }

    @Override
    public final List<Map<String, Object>> fetchMaps() {
        return ((Select)this.getDelegate()).fetchMaps();
    }

    @Override
    public final Map<String, Object> fetchOneMap() {
        return ((Select)this.getDelegate()).fetchOneMap();
    }

    @Override
    public final <K> Map<K, Result<R>> fetchGroups(Field<K> key) {
        return ((Select)this.getDelegate()).fetchGroups(key);
    }

    @Override
    public final <K, V> Map<K, List<V>> fetchGroups(Field<K> key, Field<V> value) {
        return ((Select)this.getDelegate()).fetchGroups(key, value);
    }

    @Override
    public final Map<Record, Result<R>> fetchGroups(Field<?>[] keys) {
        return ((Select)this.getDelegate()).fetchGroups(keys);
    }

    @Override
    public final <E> Map<Record, List<E>> fetchGroups(Field<?>[] keys, Class<? extends E> type) {
        return ((Select)this.getDelegate()).fetchGroups(keys, type);
    }

    @Override
    public final Object[][] fetchArrays() {
        return ((Select)this.getDelegate()).fetchArrays();
    }

    @Override
    public final Object[] fetchArray(int fieldIndex) {
        return ((Select)this.getDelegate()).fetchArray(fieldIndex);
    }

    @Override
    public final <T> T[] fetchArray(int fieldIndex, Class<? extends T> type) {
        return ((Select)this.getDelegate()).fetchArray(fieldIndex, type);
    }

    @Override
    public final <U> U[] fetchArray(int fieldIndex, Converter<?, U> converter) {
        return ((Select)this.getDelegate()).fetchArray(fieldIndex, converter);
    }

    @Override
    public final Object[] fetchArray(String fieldName) {
        return ((Select)this.getDelegate()).fetchArray(fieldName);
    }

    @Override
    public final <T> T[] fetchArray(String fieldName, Class<? extends T> type) {
        return ((Select)this.getDelegate()).fetchArray(fieldName, type);
    }

    @Override
    public final <U> U[] fetchArray(String fieldName, Converter<?, U> converter) {
        return ((Select)this.getDelegate()).fetchArray(fieldName, converter);
    }

    @Override
    public final <T> T[] fetchArray(Field<T> field) {
        return ((Select)this.getDelegate()).fetchArray(field);
    }

    @Override
    public final <T> T[] fetchArray(Field<?> field, Class<? extends T> type) {
        return ((Select)this.getDelegate()).fetchArray(field, type);
    }

    @Override
    public final <T, U> U[] fetchArray(Field<T> field, Converter<? super T, U> converter) {
        return ((Select)this.getDelegate()).fetchArray(field, converter);
    }

    @Override
    public final Object[] fetchOneArray() {
        return ((Select)this.getDelegate()).fetchOneArray();
    }

    @Override
    public final <T> List<T> fetchInto(Class<? extends T> type) {
        return ((Select)this.getDelegate()).fetchInto(type);
    }

    @Override
    public final <E> E fetchOneInto(Class<? extends E> type) {
        return ((Select)this.getDelegate()).fetchOneInto(type);
    }

    @Override
    public final <Z extends Record> Z fetchOneInto(Table<Z> table) {
        return ((Select)this.getDelegate()).fetchOneInto(table);
    }

    @Override
    public final <Z extends Record> Result<Z> fetchInto(Table<Z> table) {
        return ((Select)this.getDelegate()).fetchInto(table);
    }

    @Override
    public final <H extends RecordHandler<? super R>> H fetchInto(H handler) {
        return ((Select)this.getDelegate()).fetchInto(handler);
    }

    @Override
    public final <E> List<E> fetch(RecordMapper<? super R, E> mapper) {
        return ((Select)this.getDelegate()).fetch(mapper);
    }

    @Override
    public final <K, E> Map<K, List<E>> fetchGroups(Field<K> key, Class<? extends E> type) {
        return ((Select)this.getDelegate()).fetchGroups(key, type);
    }

    @Override
    @Deprecated
    public final FutureResult<R> fetchLater() {
        return ((Select)this.getDelegate()).fetchLater();
    }

    @Override
    @Deprecated
    public final FutureResult<R> fetchLater(ExecutorService executor) {
        return ((Select)this.getDelegate()).fetchLater(executor);
    }

    @Override
    public final Table<R> asTable() {
        return ((Select)this.getDelegate()).asTable();
    }

    @Override
    public final Table<R> asTable(String alias) {
        return ((Select)this.getDelegate()).asTable(alias);
    }

    @Override
    public final Table<R> asTable(String alias, String ... fieldAliases) {
        return ((Select)this.getDelegate()).asTable(alias, fieldAliases);
    }

    @Override
    public final <T> Field<T> asField() {
        return ((Select)this.getDelegate()).asField();
    }

    @Override
    public final <T> Field<T> asField(String alias) {
        return ((Select)this.getDelegate()).asField(alias);
    }

    @Override
    public final Row fieldsRow() {
        return ((Select)this.getDelegate()).fieldsRow();
    }

    @Override
    public final <T> Field<T> field(Field<T> field) {
        return ((Select)this.getDelegate()).field(field);
    }

    @Override
    public final Field<?> field(String string) {
        return ((Select)this.getDelegate()).field(string);
    }

    @Override
    public final Field<?> field(int index) {
        return ((Select)this.getDelegate()).field(index);
    }

    @Override
    public final Field<?>[] fields() {
        return ((Select)this.getDelegate()).fields();
    }

    private static enum ConditionStep {
        ON,
        WHERE,
        CONNECT_BY,
        HAVING;

    }
}

