/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import org.jooq.BindContext;
import org.jooq.Clause;
import org.jooq.Context;
import org.jooq.Field;
import org.jooq.RenderContext;
import org.jooq.SortField;
import org.jooq.SortOrder;
import org.jooq.impl.AbstractQueryPart;
import org.jooq.impl.DSL;

class SortFieldImpl<T>
extends AbstractQueryPart
implements SortField<T> {
    private static final long serialVersionUID = 1223739398544155873L;
    private final Field<T> field;
    private final SortOrder order;
    private boolean nullsFirst;
    private boolean nullsLast;

    SortFieldImpl(Field<T> field, SortOrder order) {
        this.field = field;
        this.order = order;
    }

    @Override
    public final String getName() {
        return this.field.getName();
    }

    @Override
    public final SortOrder getOrder() {
        return this.order;
    }

    @Override
    public final SortField<T> nullsFirst() {
        this.nullsFirst = true;
        this.nullsLast = false;
        return this;
    }

    @Override
    public final SortField<T> nullsLast() {
        this.nullsFirst = false;
        this.nullsLast = true;
        return this;
    }

    @Override
    public final void toSQL(RenderContext context) {
        if (this.nullsFirst || this.nullsLast) {
            switch (context.configuration().dialect().family()) {
                case CUBRID: 
                case MARIADB: 
                case MYSQL: 
                case SQLITE: {
                    Field<Integer> ifNull = this.nullsFirst ? DSL.zero() : DSL.one();
                    Field<Integer> ifNotNull = this.nullsFirst ? DSL.one() : DSL.zero();
                    ((RenderContext)((RenderContext)context.visit(DSL.nvl2(this.field, ifNotNull, ifNull))).sql(", ").visit(this.field)).sql(" ").keyword(this.order.toSQL());
                    break;
                }
                default: {
                    ((RenderContext)context.visit(this.field)).sql(" ").keyword(this.order.toSQL());
                    if (this.nullsFirst) {
                        context.sql(" ").keyword("nulls first");
                        break;
                    }
                    context.sql(" ").keyword("nulls last");
                    break;
                }
            }
        } else {
            ((RenderContext)context.visit(this.field)).sql(" ").keyword(this.order.toSQL());
        }
    }

    @Override
    public final void bind(BindContext context) {
        if (this.nullsFirst || this.nullsLast) {
            switch (context.configuration().dialect().family()) {
                case CUBRID: 
                case MARIADB: 
                case MYSQL: 
                case SQLITE: {
                    context.visit(this.field);
                }
            }
        }
        context.visit(this.field);
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return null;
    }
}

