/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import org.jooq.BindContext;
import org.jooq.Field;
import org.jooq.RenderContext;
import org.jooq.Schema;
import org.jooq.UDT;
import org.jooq.UDTRecord;
import org.jooq.exception.SQLDialectNotSupportedException;
import org.jooq.impl.AbstractParam;
import org.jooq.impl.DSL;
import org.jooq.impl.Utils;

class UDTConstant<R extends UDTRecord<R>>
extends AbstractParam<R> {
    private static final long serialVersionUID = 6807729087019209084L;

    UDTConstant(R value) {
        super(value, value.getUDT().getDataType());
    }

    @Override
    public final void toSQL(RenderContext context) {
        switch (context.configuration().dialect().family()) {
            case POSTGRES: {
                this.toSQLInline(context);
                return;
            }
        }
        this.toSQLInline(context);
    }

    private void toSQLInline(RenderContext context) {
        context.sql(this.getInlineConstructor(context));
        context.sql("(");
        String separator = "";
        for (Field<?> field : ((UDTRecord)this.value).fields()) {
            context.sql(separator);
            context.visit(DSL.val(((UDTRecord)this.value).getValue(field), field));
            separator = ", ";
        }
        context.sql(")");
    }

    private String getInlineConstructor(RenderContext context) {
        switch (context.configuration().dialect().family()) {
            case POSTGRES: {
                return "ROW";
            }
        }
        UDT udt = ((UDTRecord)this.value).getUDT();
        Schema mappedSchema = Utils.getMappedSchema(context.configuration(), udt.getSchema());
        if (mappedSchema != null) {
            return mappedSchema + "." + udt.getName();
        }
        return udt.getName();
    }

    @Override
    public final void bind(BindContext context) {
        switch (context.configuration().dialect().family()) {
            case POSTGRES: {
                for (Field<?> field : ((UDTRecord)this.value).fields()) {
                    context.visit(DSL.val(((UDTRecord)this.value).getValue(field)));
                }
                break;
            }
            default: {
                throw new SQLDialectNotSupportedException("UDTs not supported in dialect " + (Object)((Object)context.configuration().dialect()));
            }
        }
    }
}

