/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.io.Serializable;

class Value<T>
implements Serializable {
    private static final long serialVersionUID = -9065797545428164533L;
    private T original;
    private T value;
    private boolean isChanged;

    Value(T value) {
        this(value, value, false);
    }

    Value(T value, T original, boolean isChanged) {
        this.value = value;
        this.original = original;
        this.isChanged = isChanged;
    }

    final T getValue() {
        return this.value;
    }

    final T getValue(T defaultValue) {
        return this.value != null ? this.value : defaultValue;
    }

    final T getOriginal() {
        return this.original;
    }

    final void intern() {
        if (this.value instanceof String) {
            this.value = ((String)this.value).intern();
        }
    }

    final void setValue(T val) {
        this.setValue(val, false);
    }

    final void setValue(T val, boolean primaryKey) {
        this.isChanged = !primaryKey ? true : (this.value == null ? this.isChanged || val != null : this.isChanged || !this.value.equals(val));
        this.value = val;
    }

    final boolean isChanged() {
        return this.isChanged;
    }

    final void setChanged(boolean isChanged) {
        this.isChanged = isChanged;
        if (!isChanged) {
            this.original = this.value;
        }
    }

    final void reset() {
        this.isChanged = false;
        this.value = this.original;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Value) {
            Value other = (Value)obj;
            if (this.value == null) {
                return other.getValue() == null;
            }
            return this.value.equals(other.getValue());
        }
        return false;
    }

    public int hashCode() {
        if (this.value == null) {
            return 0;
        }
        return this.value.hashCode();
    }

    public String toString() {
        if (this.isChanged) {
            return "*" + this.value;
        }
        return "" + this.value;
    }
}

