/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import org.jooq.BindContext;
import org.jooq.Clause;
import org.jooq.Record;
import org.jooq.RenderContext;
import org.jooq.Row;
import org.jooq.Select;
import org.jooq.SelectSelectStep;
import org.jooq.Support;
import org.jooq.Table;
import org.jooq.impl.AbstractTable;
import org.jooq.impl.Fields;
import org.jooq.impl.RecordImpl;
import org.jooq.impl.TableAlias;
import org.jooq.impl.Utils;

class Values<R extends Record>
extends AbstractTable<R> {
    private static final long serialVersionUID = -637982217747670311L;
    private final Row[] rows;

    Values(Row[] rows) {
        super("values");
        this.rows = rows;
    }

    @Override
    public final Class<? extends R> getRecordType() {
        return RecordImpl.class;
    }

    @Override
    @Support
    public final Table<R> as(String alias) {
        return new TableAlias(this, alias, true);
    }

    @Override
    public final Table<R> as(String alias, String ... fieldAliases) {
        return new TableAlias(this, alias, fieldAliases, true);
    }

    @Override
    public final void toSQL(RenderContext context) {
        switch (context.configuration().dialect().family()) {
            case FIREBIRD: 
            case MARIADB: 
            case MYSQL: 
            case SQLITE: 
            case H2: {
                Select<Record> selects = null;
                boolean subquery = context.subquery();
                for (Row row : this.rows) {
                    SelectSelectStep<Record> select = this.create().select(row.fields());
                    selects = selects == null ? select : selects.unionAll(select);
                }
                ((RenderContext)((RenderContext)((RenderContext)context.formatIndentStart().formatNewLine().subquery(true)).visit(selects)).subquery(subquery)).formatIndentEnd().formatNewLine();
                break;
            }
            default: {
                ((RenderContext)context.start(Clause.TABLE_VALUES)).keyword("values").formatIndentLockStart();
                boolean firstRow = true;
                for (Row row : this.rows) {
                    if (!firstRow) {
                        context.sql(",").formatSeparator();
                    }
                    context.visit(row);
                    firstRow = false;
                }
                context.formatIndentLockEnd().end(Clause.TABLE_VALUES);
                break;
            }
        }
    }

    @Override
    public final void bind(BindContext context) {
        Utils.visitAll(context, this.rows);
    }

    @Override
    final Fields<R> fields0() {
        return new Fields(this.rows[0].fields());
    }
}

