/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.polynomials;

import JSci.maths.MathDouble;
import JSci.maths.fields.Field;
import JSci.maths.fields.Ring;
import JSci.maths.groups.AbelianGroup;
import JSci.maths.polynomials.RealPolynomial;

public class RealPolynomialRing
implements Ring {
    private static final RealPolynomial ZERO = new RealPolynomial(new double[]{0.0});
    private static final RealPolynomial ONE = new RealPolynomial(new double[]{1.0});
    private static final RealPolynomialRing _instance = new RealPolynomialRing();

    protected RealPolynomialRing() {
    }

    public static final RealPolynomialRing getInstance() {
        return _instance;
    }

    public boolean isNegative(AbelianGroup.Member member, AbelianGroup.Member member2) {
        if (member instanceof RealPolynomial && member2 instanceof RealPolynomial) {
            RealPolynomial realPolynomial = (RealPolynomial)member;
            RealPolynomial realPolynomial2 = (RealPolynomial)member2;
            return realPolynomial.add(realPolynomial2).equals(ZERO);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public boolean isOne(Ring.Member member) {
        if (member instanceof RealPolynomial) {
            return ((RealPolynomial)member).isOne();
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public boolean isZero(AbelianGroup.Member member) {
        if (member instanceof RealPolynomial) {
            return ((RealPolynomial)member).isZero();
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public Ring.Member one() {
        return ONE;
    }

    public AbelianGroup.Member zero() {
        return ZERO;
    }

    protected static double[] toDouble(Field.Member[] memberArray) {
        if (memberArray == null) {
            return null;
        }
        int n = memberArray.length;
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            if (!(memberArray[i] instanceof MathDouble)) {
                throw new IllegalArgumentException("Expected MathDouble. Got (" + i + ") " + memberArray[i]);
            }
            dArray[i] = ((MathDouble)memberArray[i]).value();
        }
        return dArray;
    }

    protected static MathDouble[] toMathDouble(double[] dArray) {
        if (dArray == null) {
            return null;
        }
        int n = dArray.length;
        MathDouble[] mathDoubleArray = new MathDouble[n];
        for (int i = 0; i < n; ++i) {
            mathDoubleArray[i] = new MathDouble(dArray[i]);
        }
        return mathDoubleArray;
    }
}

