/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.webservice;

import adams.core.Utils;
import adams.core.option.AbstractOptionHandler;
import adams.flow.core.AbstractActor;
import adams.flow.core.Actor;
import adams.flow.standalone.WSServer;
import adams.flow.webservice.WebServiceProvider;
import adams.flow.webservice.WebserviceUtils;
import adams.flow.webservice.interceptor.incoming.AbstractInInterceptorGenerator;
import adams.flow.webservice.interceptor.outgoing.AbstractOutInterceptorGenerator;
import adams.flow.webservice.interceptor.outgoing.NullGenerator;
import java.net.URL;
import java.util.logging.Level;
import org.apache.cxf.jaxws.EndpointImpl;

public abstract class AbstractWebServiceProvider
extends AbstractOptionHandler
implements WebServiceProvider {
    private static final long serialVersionUID = 5989094825183495544L;
    protected AbstractActor m_Owner;
    protected String m_URL;
    protected AbstractInInterceptorGenerator m_InInterceptor;
    protected AbstractOutInterceptorGenerator m_OutInterceptor;
    protected boolean m_Running;

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("url", "URL", (Object)this.getDefaultURL());
        this.m_OptionManager.add("in-interceptor", "inInterceptor", (Object)this.getDefaultInInterceptor());
        this.m_OptionManager.add("out-interceptor", "outInterceptor", (Object)this.getDefaultOutInterceptor());
    }

    @Override
    public void setOwner(AbstractActor value) {
        this.m_Owner = value;
    }

    @Override
    public AbstractActor getOwner() {
        return this.m_Owner;
    }

    public abstract String getDefaultURL();

    public void setURL(String value) {
        try {
            new URL(value);
            this.m_URL = value;
            this.reset();
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Invalid URL: " + value, e);
        }
    }

    @Override
    public String getURL() {
        return this.m_URL;
    }

    public String URLTipText() {
        return "The URL of the service.";
    }

    protected AbstractInInterceptorGenerator getDefaultInInterceptor() {
        return new adams.flow.webservice.interceptor.incoming.NullGenerator();
    }

    @Override
    public void setInInterceptor(AbstractInInterceptorGenerator value) {
        this.m_InInterceptor = value;
        this.reset();
    }

    @Override
    public AbstractInInterceptorGenerator getInInterceptor() {
        return this.m_InInterceptor;
    }

    public String inInterceptorTipText() {
        return "The interceptor to use for incoming messages.";
    }

    protected AbstractOutInterceptorGenerator getDefaultOutInterceptor() {
        return new NullGenerator();
    }

    @Override
    public void setOutInterceptor(AbstractOutInterceptorGenerator value) {
        this.m_OutInterceptor = value;
        this.reset();
    }

    @Override
    public AbstractOutInterceptorGenerator getOutInterceptor() {
        return this.m_OutInterceptor;
    }

    public String outInterceptorTipText() {
        return "The interceptor to use for outgoing messages.";
    }

    protected void check() {
    }

    public void log(String msg, String id) {
        if (this.m_Owner instanceof WSServer) {
            ((WSServer)this.m_Owner).log(msg, id);
        }
    }

    protected void configureInterceptors(EndpointImpl endpoint) {
        WebserviceUtils.configureServiceInterceptors((Actor)this.m_Owner, endpoint, this.m_InInterceptor, this.m_OutInterceptor);
    }

    protected abstract void doStart() throws Exception;

    @Override
    public String start() {
        String result;
        try {
            this.check();
            this.doStart();
            result = null;
            this.m_Running = true;
        }
        catch (Exception e) {
            String msg = "Failed to start service: ";
            this.getLogger().log(Level.SEVERE, msg, e);
            result = msg + Utils.throwableToString((Throwable)e);
        }
        return result;
    }

    @Override
    public boolean isRunning() {
        return this.m_Running;
    }

    protected abstract void doStop() throws Exception;

    @Override
    public String stop() {
        String result;
        try {
            this.doStop();
            result = null;
        }
        catch (Exception e) {
            String msg = "Failed to stop service: ";
            this.getLogger().log(Level.SEVERE, msg, e);
            result = msg + Utils.throwableToString((Throwable)e);
        }
        this.m_Running = false;
        return result;
    }

    @Override
    public void cleanUp() {
        this.m_InInterceptor.cleanUp();
        this.m_OutInterceptor.cleanUp();
    }
}

