/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.interpolate.impl;

import boofcv.alg.interpolate.BilinearPixel;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageType;

public class ImplBilinearPixel_F32
extends BilinearPixel<ImageFloat32> {
    public ImplBilinearPixel_F32() {
    }

    public ImplBilinearPixel_F32(ImageFloat32 orig) {
        this.setImage(orig);
    }

    @Override
    public float get_fast(float x, float y) {
        int xt = (int)x;
        int yt = (int)y;
        float ax = x - (float)xt;
        float ay = y - (float)yt;
        int index = ((ImageFloat32)this.orig).startIndex + yt * this.stride + xt;
        float[] data = ((ImageFloat32)this.orig).data;
        float val = (1.0f - ax) * (1.0f - ay) * data[index];
        val += ax * (1.0f - ay) * data[index + 1];
        val += ax * ay * data[index + 1 + this.stride];
        return val += (1.0f - ax) * ay * data[index + this.stride];
    }

    @Override
    public float get(float x, float y) {
        if (x < 0.0f || y < 0.0f || x > (float)(this.width - 1) || y > (float)(this.height - 1)) {
            throw new IllegalArgumentException("Point is outside of the image " + x + " " + y);
        }
        int xt = (int)x;
        int yt = (int)y;
        float ax = x - (float)xt;
        float ay = y - (float)yt;
        int index = ((ImageFloat32)this.orig).startIndex + yt * this.stride + xt;
        int dx = xt == this.width - 1 ? 0 : 1;
        int dy = yt == this.height - 1 ? 0 : this.stride;
        float[] data = ((ImageFloat32)this.orig).data;
        float val = (1.0f - ax) * (1.0f - ay) * data[index];
        val += ax * (1.0f - ay) * data[index + dx];
        val += ax * ay * data[index + dx + dy];
        return val += (1.0f - ax) * ay * data[index + dy];
    }

    @Override
    public ImageType<ImageFloat32> getImageType() {
        return ImageType.single(ImageFloat32.class);
    }
}

