/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.EventSetDescriptor;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.swing.JPanel;
import org.apache.commons.codec.binary.Base64;
import weka.classifiers.evaluation.NumericPrediction;
import weka.classifiers.timeseries.AbstractForecaster;
import weka.classifiers.timeseries.WekaForecaster;
import weka.classifiers.timeseries.core.TSLagMaker;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.Environment;
import weka.core.EnvironmentHandler;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Utils;
import weka.gui.Logger;
import weka.gui.beans.BeanCommon;
import weka.gui.beans.BeanVisual;
import weka.gui.beans.DataSetEvent;
import weka.gui.beans.DataSourceListener;
import weka.gui.beans.EventConstraints;
import weka.gui.beans.InstanceEvent;
import weka.gui.beans.InstanceListener;
import weka.gui.beans.KFStep;
import weka.gui.beans.Visible;

@KFStep(category="Time Series", toolTipText="Forecasting using a time series model")
public class TimeSeriesForecasting
extends JPanel
implements BeanCommon,
Visible,
EventConstraints,
EnvironmentHandler,
InstanceListener,
DataSourceListener {
    private static final long serialVersionUID = -7826178727365267059L;
    protected transient Instances m_header;
    protected transient WekaForecaster m_forecaster;
    protected transient Instances m_outgoingStructure;
    protected String m_fileName = "-NONE-";
    protected String m_saveFileName = "";
    protected String m_encodedForecaster = "-NONE-";
    protected String m_numberOfStepsToForecast = "1";
    protected boolean m_rebuildForecaster = false;
    protected String m_artificialTimeStartOffset = "0";
    protected transient Logger m_log;
    protected transient Environment m_env;
    protected Object m_listenee = null;
    protected String m_incomingConnection = "";
    protected ArrayList<InstanceListener> m_instanceListeners = new ArrayList();
    protected Status m_forecastingStatus = Status.IDLE;
    protected BeanVisual m_visual = new BeanVisual("TimeSeriesForecasting", "weka/gui/beans/icons/DefaultClassifier.gif", "weka/gui/beans/icons/DefaultClassifier_animated.gif");
    protected transient Instances m_overlayData;
    protected transient Instances m_bufferedPrimeData;
    protected transient boolean m_isUsingOverlayData;
    protected transient TSLagMaker m_modelLagMaker;
    protected transient String m_timeStampName = "";
    protected transient List<String> m_fieldsToForecast;

    public String globalInfo() {
        return "Encapsulates a time series forecasting model and uses it to produce forecasts given incoming historical data. Forecaster can optionally be rebuilt using the incoming data before a forecast is generated.";
    }

    public TimeSeriesForecasting() {
        this.setLayout(new BorderLayout());
        this.useDefaultVisual();
        this.add((Component)this.m_visual, "Center");
    }

    public void useDefaultVisual() {
        this.m_visual.loadIcons("weka/gui/beans/icons/DefaultClassifier.gif", "weka/gui/beans/icons/DefaultClassifier_animated.gif");
    }

    public void setLog(Logger logger) {
        this.m_log = logger;
    }

    public WekaForecaster getForecaster() throws Exception {
        if (this.m_forecaster != null) {
            return this.m_forecaster;
        }
        List<Object> model = TimeSeriesForecasting.getForecaster(this.m_encodedForecaster);
        if (model != null) {
            this.m_forecaster = (WekaForecaster)model.get(0);
            this.m_header = (Instances)model.get(1);
            return this.m_forecaster;
        }
        return null;
    }

    public static List<Object> getForecaster(String base64encoded) throws Exception {
        if (base64encoded != null && base64encoded.length() > 0 && !base64encoded.equals("-NONE-")) {
            byte[] decoded = TimeSeriesForecasting.decodeFromBase64(base64encoded);
            ByteArrayInputStream bis = new ByteArrayInputStream(decoded);
            ObjectInputStream ois = new ObjectInputStream(bis);
            List model = (List)ois.readObject();
            ois.close();
            return model;
        }
        return null;
    }

    public void setEncodedForecaster(String encodedForecaster) {
        this.m_encodedForecaster = encodedForecaster;
    }

    public String getEncodedForecaster() {
        return this.m_encodedForecaster;
    }

    public void setFilename(String filename) {
        this.m_fileName = filename;
    }

    public String getFilename() {
        return this.m_fileName;
    }

    public void setSaveFilename(String fileName) {
        this.m_saveFileName = fileName;
    }

    public String getSaveFilename() {
        return this.m_saveFileName;
    }

    public void setRebuildForecaster(boolean rebuild) {
        this.m_rebuildForecaster = rebuild;
    }

    public boolean getRebuildForecaster() {
        return this.m_rebuildForecaster;
    }

    public boolean connectionAllowed(EventSetDescriptor esd) {
        return this.connectionAllowed(esd.getName());
    }

    public boolean connectionAllowed(String arg0) {
        return this.m_listenee == null;
    }

    public void setNumStepsToForecast(String n) {
        this.m_numberOfStepsToForecast = n;
    }

    public String getNumStepsToForecast() {
        return this.m_numberOfStepsToForecast;
    }

    public void setArtificialTimeStartOffset(String art) {
        this.m_artificialTimeStartOffset = art;
    }

    public String getArtificialTimeStartOffset() {
        return this.m_artificialTimeStartOffset;
    }

    public void connectionNotification(String eventName, Object source) {
        if (this.connectionAllowed(eventName)) {
            this.m_listenee = source;
            this.m_incomingConnection = eventName;
        }
    }

    public void disconnectionNotification(String eventName, Object source) {
        if (this.m_listenee == source) {
            this.m_listenee = null;
            this.m_incomingConnection = "";
        }
    }

    public String getCustomName() {
        return this.m_visual.getText();
    }

    public boolean isBusy() {
        return this.m_forecastingStatus == Status.BUSY;
    }

    public void setCustomName(String name) {
        this.m_visual.setText(name);
    }

    public void stop() {
        this.m_forecastingStatus = Status.IDLE;
        if (this.m_listenee != null && this.m_listenee instanceof BeanCommon) {
            ((BeanCommon)this.m_listenee).stop();
        }
    }

    public void setEnvironment(Environment env) {
        this.m_env = env;
    }

    public BeanVisual getVisual() {
        return this.m_visual;
    }

    public void setVisual(BeanVisual newVisual) {
        this.m_visual = newVisual;
    }

    public static String encodeForecasterToBase64(WekaForecaster model, Instances header) throws Exception {
        if (model != null && header != null) {
            ArrayList<WekaForecaster> modelAndHeader = new ArrayList<WekaForecaster>();
            modelAndHeader.add(model);
            modelAndHeader.add((WekaForecaster)header);
            ByteArrayOutputStream bao = new ByteArrayOutputStream();
            BufferedOutputStream bos = new BufferedOutputStream(bao);
            ObjectOutputStream oo = new ObjectOutputStream(bos);
            oo.writeObject(modelAndHeader);
            oo.flush();
            byte[] modelBytes = bao.toByteArray();
            return TimeSeriesForecasting.encodeToBase64(modelBytes);
        }
        throw new Exception("[TimeSeriesForecasting] unable to encode model!");
    }

    protected List<Object> loadModel(String filename) {
        ArrayList<Object> loaded = new ArrayList<Object>();
        try {
            if (!TimeSeriesForecasting.isEmpty(filename) && !filename.equals("-NONE-")) {
                if (this.m_env == null) {
                    this.m_env = Environment.getSystemWide();
                }
                String filenameN = filename;
                try {
                    filenameN = this.m_env.substitute(filename);
                }
                catch (Exception e) {
                    // empty catch block
                }
                InputStream is = new FileInputStream(filenameN);
                if (filenameN.toLowerCase().endsWith(".gz")) {
                    is = new GZIPInputStream(is);
                }
                ObjectInputStream ois = new ObjectInputStream(new BufferedInputStream(is));
                WekaForecaster forecaster = (WekaForecaster)ois.readObject();
                Instances header = (Instances)ois.readObject();
                is.close();
                loaded.add(forecaster);
                loaded.add(header);
                return loaded;
            }
            this.logMessage("Model is null or no filename specified to load from!");
            return null;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.logMessage(ex.getMessage());
            return null;
        }
    }

    protected static boolean isEmpty(String aString) {
        return aString == null || aString.length() == 0;
    }

    protected void logMessage(String message) {
        message = "[TimeSeriesForecasting] " + this.statusMessagePrefix() + message;
        if (this.m_log != null) {
            this.m_log.logMessage(message);
        } else {
            System.out.println(message);
        }
    }

    protected void logError(String message, Exception ex) {
        String exceptionMessage = ex != null ? ex.getMessage() : "";
        message = "[TimeSeriesForecasting] " + this.statusMessagePrefix() + " " + message + exceptionMessage;
        if (this.m_log != null) {
            this.m_log.logMessage(message);
        } else {
            System.err.println(message);
        }
    }

    protected void statusMessage(String message) {
        message = this.statusMessagePrefix() + message;
        if (this.m_log != null) {
            this.m_log.statusMessage(message);
        } else {
            System.out.println(message);
        }
    }

    protected void statusError() {
        String message = this.statusMessagePrefix() + "ERROR: see log for details";
        if (this.m_log != null) {
            this.m_log.statusMessage(message);
        } else {
            System.err.println(message);
        }
    }

    protected void statusWarning(String message) {
        message = this.statusMessagePrefix() + "WARNING: " + message;
        if (this.m_log != null) {
            this.m_log.statusMessage(message);
        } else {
            System.out.println(message);
        }
    }

    protected static final String encodeToBase64(byte[] val) throws IOException {
        String string;
        if (val == null) {
            string = null;
        } else {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            GZIPOutputStream gzos = new GZIPOutputStream(baos);
            BufferedOutputStream bos = new BufferedOutputStream(gzos);
            bos.write(val);
            bos.flush();
            bos.close();
            string = new String(Base64.encodeBase64((byte[])baos.toByteArray()));
        }
        return string;
    }

    protected static final byte[] decodeFromBase64(String string) throws Exception {
        byte[] bytes = string == null ? new byte[]{} : Base64.decodeBase64((byte[])string.getBytes());
        if (bytes.length > 0) {
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            GZIPInputStream gzip = new GZIPInputStream(bais);
            BufferedInputStream bi = new BufferedInputStream(gzip);
            byte[] result = new byte[]{};
            byte[] extra = new byte[1000000];
            int nrExtra = bi.read(extra);
            while (nrExtra >= 0) {
                int i;
                int newSize = result.length + nrExtra;
                byte[] tmp = new byte[newSize];
                for (i = 0; i < result.length; ++i) {
                    tmp[i] = result[i];
                }
                for (i = 0; i < nrExtra; ++i) {
                    tmp[result.length + i] = extra[i];
                }
                result = tmp;
                nrExtra = bi.read(extra);
            }
            bytes = result;
            gzip.close();
        }
        return bytes;
    }

    public boolean eventGeneratable(String eventName) {
        return !eventName.equals("instance") && !eventName.equals("dataset") || this.m_listenee != null;
    }

    private void loadOrDecodeForecaster() {
        if (!TimeSeriesForecasting.isEmpty(this.m_fileName) && !this.m_fileName.equals("-NONE-")) {
            List<Object> loaded = this.loadModel(this.m_fileName);
            if (loaded == null) {
                this.statusError();
                this.logError("problem loading forecasting model.", null);
                this.stop();
                return;
            }
            this.m_forecaster = (WekaForecaster)loaded.get(0);
            this.m_header = (Instances)loaded.get(1);
        } else if (this.m_encodedForecaster != null && this.m_encodedForecaster.length() > 0 && !this.m_encodedForecaster.equals("-NONE-")) {
            try {
                this.getForecaster();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.statusError();
                this.logError("a problem occurred while decoding the model. See the log for details.", ex);
                this.stop();
                return;
            }
        } else {
            this.statusError();
            this.logError("unable to obtain a forecasting model to use.", null);
            this.stop();
            return;
        }
    }

    public void acceptInstance(InstanceEvent e) {
        int status = e.getStatus();
        if (status == 0) {
            Instances dataset = e.getStructure();
            this.loadOrDecodeForecaster();
            if (!this.m_header.equalHeaders(dataset)) {
                this.statusError();
                this.logError("incoming instances structure does not match the structure of the data used to train the forecaster.", null);
                this.stop();
                return;
            }
            this.m_forecastingStatus = Status.BUSY;
            this.processInstance(null, true);
            return;
        }
        this.processInstance(e.getInstance(), false);
        if (status == 2) {
            this.processInstance(null, false);
            this.generateForecast();
            this.m_forecastingStatus = Status.IDLE;
        }
    }

    protected void processInstance(Instance toProcess, boolean first) {
        if (first) {
            this.m_overlayData = null;
            this.m_bufferedPrimeData = null;
            this.statusMessage("configuring forecaster...");
            this.m_modelLagMaker = this.m_forecaster.getTSLagMaker();
            if (!this.m_modelLagMaker.isUsingAnArtificialTimeIndex() && this.m_modelLagMaker.getAdjustForTrends()) {
                this.m_timeStampName = this.m_modelLagMaker.getTimeStampField();
            }
            this.m_isUsingOverlayData = this.m_forecaster.isUsingOverlayData();
            if (!this.m_rebuildForecaster) {
                this.logMessage("forecaster will be primed incrementally.");
                try {
                    this.m_forecaster.primeForecaster(new Instances(this.m_header, 0));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    this.statusError();
                    this.logError("problem during initialization of the priming data.", ex);
                    this.stop();
                    return;
                }
            } else {
                this.logMessage("forecaster will be rebuilt/re-estimated on incoming data");
            }
            if (this.m_isUsingOverlayData) {
                this.logMessage("forecaster is using overlay data. We expect to see overlay attribute values for the forecasting period.");
                this.m_overlayData = new Instances(this.m_header, 0);
            }
            if (this.m_rebuildForecaster) {
                this.m_bufferedPrimeData = new Instances(this.m_header, 0);
            }
            this.m_fieldsToForecast = AbstractForecaster.stringToList(this.m_forecaster.getFieldsToForecast());
            this.m_outgoingStructure = new Instances(this.m_header);
            if (this.m_forecaster.isProducingConfidenceIntervals()) {
                ArrayList<Attribute> atts = new ArrayList<Attribute>();
                for (int i = 0; i < this.m_header.numAttributes(); ++i) {
                    atts.add((Attribute)this.m_header.attribute(i).copy());
                }
                for (String f : this.m_fieldsToForecast) {
                    Attribute lb = new Attribute(f + "_lowerBound");
                    Attribute ub = new Attribute(f + "_upperBound");
                    atts.add(lb);
                    atts.add(ub);
                }
                this.m_outgoingStructure = new Instances(this.m_header.relationName() + "_" + "plus_forecast", atts, 0);
            }
            InstanceEvent ie = new InstanceEvent((Object)this, this.m_outgoingStructure);
            this.notifyInstanceListeners(ie);
        } else if (toProcess == null) {
            if (this.m_rebuildForecaster && this.m_bufferedPrimeData.numInstances() > 0) {
                for (int i = 0; i < this.m_bufferedPrimeData.numInstances(); ++i) {
                    InstanceEvent ie = new InstanceEvent((Object)this, this.m_bufferedPrimeData.instance(i), 1);
                    this.notifyInstanceListeners(ie);
                }
                try {
                    this.statusMessage("rebuilding the forecasting model...");
                    this.logMessage("rebuilding the forecasting model.");
                    this.m_forecaster.buildForecaster(this.m_bufferedPrimeData, new PrintStream[0]);
                    this.statusMessage("priming the forecasting model...");
                    this.logMessage("priming the forecasting model.");
                    this.m_forecaster.primeForecaster(this.m_bufferedPrimeData);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.statusError();
                    this.logError("a problem occurred when rebuilding the forecaster", e);
                    this.stop();
                }
            }
            if (this.m_rebuildForecaster && !TimeSeriesForecasting.isEmpty(this.m_saveFileName)) {
                String saveName = this.m_saveFileName;
                if (this.m_env == null) {
                    this.m_env = Environment.getSystemWide();
                }
                try {
                    saveName = this.m_env.substitute(saveName);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                this.statusMessage("Saving rebuilt forecasting model...");
                this.logMessage("Saving rebuild forecasting model to \"" + saveName + "\"");
                try {
                    OutputStream os = new FileOutputStream(saveName);
                    if (saveName.toLowerCase().endsWith(".gz")) {
                        os = new GZIPOutputStream(os);
                    }
                    ObjectOutputStream oos = new ObjectOutputStream(new BufferedOutputStream(os));
                    oos.writeObject(this.m_forecaster);
                    oos.writeObject(this.m_header);
                    oos.close();
                }
                catch (IOException e) {
                    this.statusError();
                    this.logError("a problem occurred when trying to save rebuilt model.", e);
                    this.stop();
                }
            }
        } else if (this.m_isUsingOverlayData) {
            boolean allMissing = true;
            for (String field : this.m_fieldsToForecast) {
                if (toProcess.isMissing(this.m_header.attribute(field))) continue;
                allMissing = false;
                break;
            }
            if (allMissing) {
                this.m_overlayData.add(toProcess);
                this.statusMessage("buffering overlay instance");
            } else if (this.m_overlayData.numInstances() > 0) {
                this.m_overlayData.add(toProcess);
                this.logMessage("encountered a supposed overlay instance with non-missing target values - converting buffered overlay data into " + (this.m_rebuildForecaster ? "training" : "priming") + " data...");
                this.statusMessage("flushing overlay buffer.");
                for (int i = 0; i < this.m_overlayData.numInstances(); ++i) {
                    if (!this.m_rebuildForecaster) {
                        try {
                            this.m_forecaster.primeForecasterIncremental(this.m_overlayData.instance(i));
                            Instance outgoing = this.convertToOutputFormat(this.m_overlayData.instance(i));
                            InstanceEvent ie = new InstanceEvent((Object)this, outgoing, 1);
                            this.notifyInstanceListeners(ie);
                            continue;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            this.statusError();
                            this.logError("problem occurred during priming.", e);
                            this.stop();
                            return;
                        }
                    }
                    this.m_bufferedPrimeData.add(this.m_overlayData.instance(i));
                }
                this.m_overlayData = new Instances(this.m_header, 0);
            } else if (!this.m_rebuildForecaster) {
                try {
                    this.m_forecaster.primeForecasterIncremental(toProcess);
                    Instance outgoing = this.convertToOutputFormat(toProcess);
                    InstanceEvent ie = new InstanceEvent((Object)this, outgoing, 1);
                    this.notifyInstanceListeners(ie);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    this.statusError();
                    this.logError("problem occurred during priming.", ex);
                    this.stop();
                    return;
                }
            } else {
                this.m_bufferedPrimeData.add(toProcess);
            }
        } else if (!this.m_rebuildForecaster) {
            try {
                this.m_forecaster.primeForecasterIncremental(toProcess);
                Instance outgoing = this.convertToOutputFormat(toProcess);
                InstanceEvent ie = new InstanceEvent((Object)this, outgoing, 1);
                this.notifyInstanceListeners(ie);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.statusError();
                this.logError("problem occurred during priming.", ex);
                this.stop();
                return;
            }
        } else {
            this.m_bufferedPrimeData.add(toProcess);
        }
    }

    public void acceptDataSet(DataSetEvent dse) {
        this.loadOrDecodeForecaster();
        Instances data = dse.getDataSet();
        if (!this.m_header.equalHeaders(data)) {
            this.statusError();
            this.logError("Incoming instance structure does not match what the forecaster was trained with", null);
            return;
        }
        if (dse.isStructureOnly()) {
            return;
        }
        this.m_forecastingStatus = Status.BUSY;
        this.processInstance(null, true);
        for (int i = 0; i < data.numInstances(); ++i) {
            this.processInstance(data.instance(i), false);
        }
        this.processInstance(null, false);
        this.generateForecast();
        this.m_forecastingStatus = Status.IDLE;
    }

    private void generateForecast() {
        double lastTimeFromPrime = -1.0;
        if (this.m_modelLagMaker.getAdjustForTrends() && this.m_modelLagMaker.getTimeStampField() != null && this.m_modelLagMaker.getTimeStampField().length() > 0 && !this.m_modelLagMaker.isUsingAnArtificialTimeIndex()) {
            try {
                lastTimeFromPrime = this.m_modelLagMaker.getCurrentTimeStampValue();
            }
            catch (Exception ex) {
                this.statusError();
                this.logError("a problem occurred while establishing the current time stamp value", ex);
                this.stop();
                return;
            }
        }
        if (this.m_modelLagMaker.getAdjustForTrends() && this.m_modelLagMaker.isUsingAnArtificialTimeIndex()) {
            try {
                String artOff = this.m_artificialTimeStartOffset;
                if (this.m_env != null) {
                    artOff = this.m_env.substitute(artOff);
                }
                double artificialStartValue = this.m_modelLagMaker.getArtificialTimeStartValue();
                this.m_modelLagMaker.setArtificialTimeStartValue(artificialStartValue += (double)Integer.parseInt(artOff));
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.statusError();
                this.logError("unable to set the value of the artificial time stamp.", ex);
                this.stop();
                return;
            }
        }
        boolean overlay = this.m_overlayData != null && this.m_overlayData.numInstances() > 0 && this.m_isUsingOverlayData;
        String numS = this.m_numberOfStepsToForecast;
        if (this.m_env != null) {
            try {
                numS = this.m_env.substitute(numS);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        int numSteps = overlay ? this.m_overlayData.numInstances() : Integer.parseInt(numS);
        List<List<NumericPrediction>> forecast = null;
        try {
            forecast = overlay ? this.m_forecaster.forecast(numSteps, this.m_overlayData, new PrintStream[0]) : this.m_forecaster.forecast(numSteps, new PrintStream[0]);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.statusError();
            this.logError("unable to generate a forecast.", ex);
            this.stop();
            return;
        }
        double time = lastTimeFromPrime;
        int timeStampIndex = -1;
        if (this.m_timeStampName.length() > 0) {
            Attribute timeStampAtt = this.m_outgoingStructure.attribute(this.m_timeStampName);
            if (timeStampAtt == null) {
                this.statusError();
                this.logError("couldn't find time stamp: " + this.m_timeStampName + "in the input data", null);
                this.stop();
                return;
            }
            timeStampIndex = timeStampAtt.index();
        }
        this.statusMessage("Generating forecast...");
        this.logMessage("Generating forecast.");
        for (int i = 0; i < numSteps; ++i) {
            DenseInstance outputI = null;
            double[] outVals = new double[this.m_outgoingStructure.numAttributes()];
            for (int j = 0; j < outVals.length; ++j) {
                outVals[j] = overlay ? this.m_overlayData.instance(i).value(j) : Utils.missingValue();
            }
            List<NumericPrediction> predsForStep = forecast.get(i);
            if (timeStampIndex != -1) {
                outVals[timeStampIndex] = time = this.m_modelLagMaker.advanceSuppliedTimeValue(time);
            }
            for (int j = 0; j < this.m_fieldsToForecast.size(); ++j) {
                double y;
                String target = this.m_fieldsToForecast.get(j);
                int targetI = this.m_outgoingStructure.attribute(target).index();
                NumericPrediction predForTargetAtStep = predsForStep.get(j);
                double yHigh = y = predForTargetAtStep.predicted();
                double yLow = y;
                double[][] conf = predForTargetAtStep.predictionIntervals();
                if (!Utils.isMissingValue((double)y)) {
                    outVals[targetI] = y;
                }
                if (conf.length <= 0) continue;
                yLow = conf[0][0];
                yHigh = conf[0][1];
                int indexOfLow = this.m_outgoingStructure.attribute(target + "_lowerBound").index();
                int indexOfHigh = this.m_outgoingStructure.attribute(target + "_upperBound").index();
                outVals[indexOfLow] = yLow;
                outVals[indexOfHigh] = yHigh;
            }
            outputI = new DenseInstance(1.0, outVals);
            outputI.setDataset(this.m_outgoingStructure);
            InstanceEvent ie = new InstanceEvent((Object)this, (Instance)outputI, 1);
            if (i == numSteps - 1) {
                ie.setStatus(2);
            }
            this.notifyInstanceListeners(ie);
        }
        this.statusMessage("Finished.");
        this.logMessage("Finished. Generated " + numSteps + " forecasted values.");
    }

    private String statusMessagePrefix() {
        return this.getCustomName() + "$" + this.hashCode() + "|" + (Utils.joinOptions((String[])this.m_forecaster.getOptions()).length() > 0 ? Utils.joinOptions((String[])this.m_forecaster.getOptions()) + "|" : "");
    }

    private Instance convertToOutputFormat(Instance incoming) {
        Instance output = (Instance)incoming.copy();
        if (this.m_forecaster.isProducingConfidenceIntervals()) {
            int i;
            double[] values = new double[incoming.numAttributes() + this.m_fieldsToForecast.size() * 2];
            for (i = 0; i < incoming.numAttributes(); ++i) {
                values[i] = incoming.value(i);
            }
            for (i = incoming.numAttributes(); i < incoming.numAttributes() + this.m_fieldsToForecast.size() * 2; ++i) {
                values[i] = Utils.missingValue();
            }
            output = new DenseInstance(1.0, values);
        }
        output.setDataset(this.m_outgoingStructure);
        return output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyInstanceListeners(InstanceEvent e) {
        ArrayList l = null;
        TimeSeriesForecasting timeSeriesForecasting = this;
        synchronized (timeSeriesForecasting) {
            l = (ArrayList)this.m_instanceListeners.clone();
        }
        if (l.size() > 0) {
            for (int i = 0; i < l.size(); ++i) {
                ((InstanceListener)l.get(i)).acceptInstance(e);
            }
        }
    }

    public synchronized void addInstanceListener(InstanceListener l) {
        this.m_instanceListeners.add(l);
    }

    public synchronized void removeInstanceListener(InstanceListener l) {
        this.m_instanceListeners.remove(l);
    }

    private static enum Status {
        BUSY,
        IDLE;

    }
}

