/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.output;

import adams.data.heatmap.Heatmap;
import adams.data.io.input.FloatMatrixHeatmapReader;
import adams.data.io.output.AbstractHeatmapWriter;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.util.List;
import java.util.logging.Level;

public class FloatMatrixHeatmapWriter
extends AbstractHeatmapWriter {
    private static final long serialVersionUID = -7828811375813385465L;

    public String globalInfo() {
        return "Writes heat map files (2-D array of single precision floating point numbers).";
    }

    protected void initialize() {
        super.initialize();
        this.m_OutputIsFile = true;
    }

    public String getFormatDescription() {
        return new FloatMatrixHeatmapReader().getFormatDescription();
    }

    public String[] getFormatExtensions() {
        return new FloatMatrixHeatmapReader().getFormatExtensions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean writeData(List<Heatmap> data) {
        boolean result = false;
        DataOutputStream stream = null;
        try {
            stream = new DataOutputStream(new FileOutputStream(this.m_Output.getAbsoluteFile()));
            Heatmap map = data.get(0);
            byte[] bytes = new byte[4];
            for (int y = 0; y < map.getHeight(); ++y) {
                for (int x = 0; x < map.getWidth(); ++x) {
                    float fvalue = (float)map.get(y, x);
                    int ivalue = Float.floatToIntBits(fvalue);
                    bytes[3] = (byte)(ivalue >>> 24);
                    bytes[2] = (byte)(ivalue >>> 16);
                    bytes[1] = (byte)(ivalue >>> 8);
                    bytes[0] = (byte)ivalue;
                    stream.write(bytes);
                }
            }
            result = true;
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Failed to write heatmap to '" + this.m_Output + "':", e);
        }
        finally {
            if (stream != null) {
                try {
                    stream.flush();
                    stream.close();
                }
                catch (Exception e) {}
            }
        }
        return result;
    }
}

