/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.geo;

import boofcv.abst.geo.BundleAdjustmentCalibrated;
import boofcv.abst.geo.Estimate1ofEpipolar;
import boofcv.abst.geo.Estimate1ofPnP;
import boofcv.abst.geo.Estimate1ofTrifocalTensor;
import boofcv.abst.geo.EstimateNofEpipolar;
import boofcv.abst.geo.EstimateNofPnP;
import boofcv.abst.geo.RefineEpipolar;
import boofcv.abst.geo.RefinePnP;
import boofcv.abst.geo.bundle.BundleAdjustmentCalibratedDense;
import boofcv.abst.geo.f.Estimate1toNofEpipolar;
import boofcv.abst.geo.f.EstimateNto1ofEpipolar;
import boofcv.abst.geo.f.LeastSquaresFundamental;
import boofcv.abst.geo.f.WrapEssentialNister5;
import boofcv.abst.geo.f.WrapFundamentalLinear7;
import boofcv.abst.geo.f.WrapFundamentalLinear8;
import boofcv.abst.geo.h.LeastSquaresHomography;
import boofcv.abst.geo.h.WrapHomographyLinear;
import boofcv.abst.geo.pose.Estimate1toNofPnP;
import boofcv.abst.geo.pose.EstimateNto1ofPnP;
import boofcv.abst.geo.pose.PnPRefineRodrigues;
import boofcv.abst.geo.pose.WrapP3PLineDistance;
import boofcv.abst.geo.pose.WrapPnPLepetitEPnP;
import boofcv.abst.geo.trifocal.WrapTrifocalAlgebraicPoint7;
import boofcv.abst.geo.trifocal.WrapTrifocalLinearPoint7;
import boofcv.alg.geo.ModelObservationResidualN;
import boofcv.alg.geo.f.DistanceEpipolarConstraint;
import boofcv.alg.geo.h.HomographyLinear4;
import boofcv.alg.geo.h.HomographyResidualSampson;
import boofcv.alg.geo.h.HomographyResidualTransfer;
import boofcv.alg.geo.pose.P3PFinsterwalder;
import boofcv.alg.geo.pose.P3PGrunert;
import boofcv.alg.geo.pose.PnPLepetitEPnP;
import boofcv.alg.geo.pose.PoseFromPairLinear6;
import boofcv.alg.geo.trifocal.TrifocalAlgebraicPoint7;
import boofcv.factory.geo.EnumEpipolar;
import boofcv.factory.geo.EnumPNP;
import boofcv.factory.geo.EnumTrifocal;
import boofcv.factory.geo.EpipolarError;
import boofcv.struct.geo.AssociatedPair;
import georegression.fitting.MotionTransformPoint;
import georegression.fitting.se.FitSpecialEuclideanOps_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.se.Se3_F64;
import org.ddogleg.optimization.FactoryOptimization;
import org.ddogleg.optimization.UnconstrainedLeastSquares;
import org.ddogleg.solver.PolynomialOps;
import org.ddogleg.solver.RootFinderType;
import org.ddogleg.struct.FastQueue;
import org.ejml.data.DenseMatrix64F;

public class FactoryMultiView {
    public static BundleAdjustmentCalibrated bundleCalibrated(double tol, int maxIterations) {
        return new BundleAdjustmentCalibratedDense(tol, maxIterations);
    }

    public static Estimate1ofEpipolar computeHomography(boolean normalize) {
        HomographyLinear4 alg = new HomographyLinear4(normalize);
        return new WrapHomographyLinear(alg);
    }

    public static RefineEpipolar refineHomography(double tol, int maxIterations, EpipolarError type) {
        ModelObservationResidualN<DenseMatrix64F, AssociatedPair> residuals;
        switch (type) {
            case SIMPLE: {
                residuals = new HomographyResidualSampson();
                break;
            }
            case SAMPSON: {
                residuals = new HomographyResidualTransfer();
                break;
            }
            default: {
                throw new IllegalArgumentException("Type not supported: " + (Object)((Object)type));
            }
        }
        return new LeastSquaresHomography(tol, maxIterations, residuals);
    }

    public static EstimateNofEpipolar computeFundamental_N(EnumEpipolar which) {
        switch (which) {
            case FUNDAMENTAL_8_LINEAR: {
                return new Estimate1toNofEpipolar(new WrapFundamentalLinear8(true));
            }
            case ESSENTIAL_8_LINEAR: {
                return new Estimate1toNofEpipolar(new WrapFundamentalLinear8(false));
            }
            case FUNDAMENTAL_7_LINEAR: {
                return new WrapFundamentalLinear7(true);
            }
            case ESSENTIAL_7_LINEAR: {
                return new WrapFundamentalLinear7(false);
            }
            case ESSENTIAL_5_NISTER: {
                return new WrapEssentialNister5();
            }
        }
        throw new IllegalArgumentException("Unknown algorithm " + (Object)((Object)which));
    }

    public static Estimate1ofEpipolar computeFundamental_1(EnumEpipolar which, int numRemoveAmbiguity) {
        switch (which) {
            case FUNDAMENTAL_8_LINEAR: {
                return new WrapFundamentalLinear8(true);
            }
            case ESSENTIAL_8_LINEAR: {
                return new WrapFundamentalLinear8(false);
            }
        }
        if (numRemoveAmbiguity <= 0) {
            throw new IllegalArgumentException("numRemoveAmbiguity must be greater than zero");
        }
        EstimateNofEpipolar alg = FactoryMultiView.computeFundamental_N(which);
        DistanceEpipolarConstraint distance = new DistanceEpipolarConstraint();
        return new EstimateNto1ofEpipolar(alg, distance, numRemoveAmbiguity);
    }

    public static RefineEpipolar refineFundamental(double tol, int maxIterations, EpipolarError type) {
        switch (type) {
            case SAMPSON: {
                return new LeastSquaresFundamental(tol, maxIterations, true);
            }
            case SIMPLE: {
                return new LeastSquaresFundamental(tol, maxIterations, false);
            }
        }
        throw new IllegalArgumentException("Type not supported: " + (Object)((Object)type));
    }

    public static Estimate1ofTrifocalTensor estimateTrifocal_1(EnumTrifocal type, int iterations) {
        switch (type) {
            case LINEAR_7: {
                return new WrapTrifocalLinearPoint7();
            }
            case ALGEBRAIC_7: {
                UnconstrainedLeastSquares optimizer = FactoryOptimization.leastSquaresLM((double)0.001, (boolean)false);
                TrifocalAlgebraicPoint7 alg = new TrifocalAlgebraicPoint7(optimizer, iterations, 1.0E-12, 1.0E-12);
                return new WrapTrifocalAlgebraicPoint7(alg);
            }
        }
        throw new IllegalArgumentException("Unknown type " + (Object)((Object)type));
    }

    public static EstimateNofPnP computePnP_N(EnumPNP which, int numIterations) {
        MotionTransformPoint motionFit = FitSpecialEuclideanOps_F64.fitPoints3D();
        switch (which) {
            case P3P_GRUNERT: {
                P3PGrunert grunert = new P3PGrunert(PolynomialOps.createRootFinder((int)5, (RootFinderType)RootFinderType.STURM));
                return new WrapP3PLineDistance(grunert, (MotionTransformPoint<Se3_F64, Point3D_F64>)motionFit);
            }
            case P3P_FINSTERWALDER: {
                P3PFinsterwalder finster = new P3PFinsterwalder(PolynomialOps.createRootFinder((int)4, (RootFinderType)RootFinderType.STURM));
                return new WrapP3PLineDistance(finster, (MotionTransformPoint<Se3_F64, Point3D_F64>)motionFit);
            }
            case EPNP: {
                Estimate1ofPnP epnp = FactoryMultiView.computePnP_1(which, numIterations, 0);
                return new Estimate1toNofPnP(epnp);
            }
        }
        throw new IllegalArgumentException("Type " + (Object)((Object)which) + " not known");
    }

    public static Estimate1ofPnP computePnP_1(EnumPNP which, int numIterations, int numTest) {
        if (which == EnumPNP.EPNP) {
            PnPLepetitEPnP alg = new PnPLepetitEPnP(0.1);
            alg.setNumIterations(numIterations);
            return new WrapPnPLepetitEPnP(alg);
        }
        FastQueue solutions = new FastQueue(4, Se3_F64.class, true);
        return new EstimateNto1ofPnP(FactoryMultiView.computePnP_N(which, -1), (FastQueue<Se3_F64>)solutions, numTest);
    }

    public static Estimate1ofPnP computePnPwithEPnP(int numIterations, double magicNumber) {
        PnPLepetitEPnP alg = new PnPLepetitEPnP(magicNumber);
        alg.setNumIterations(numIterations);
        return new WrapPnPLepetitEPnP(alg);
    }

    public static RefinePnP refinePnP(double tol, int maxIterations) {
        return new PnPRefineRodrigues(tol, maxIterations);
    }

    public static PoseFromPairLinear6 computePoseFromPair() {
        return new PoseFromPairLinear6();
    }
}

