/*
 * Decompiled with CFR 0.152.
 */
package mst;

import mst.Bag;
import mst.Edge;
import mst.In;
import mst.Stack;
import mst.StdOut;

public class EdgeWeightedGraph {
    private final int V;
    private int E;
    private Bag<Edge>[] adj;

    public EdgeWeightedGraph(int V) {
        if (V < 0) {
            throw new IllegalArgumentException("Number of vertices in a Graph must be nonnegative");
        }
        this.V = V;
        this.E = 0;
        this.adj = new Bag[V];
        for (int v = 0; v < V; ++v) {
            this.adj[v] = new Bag();
        }
    }

    public EdgeWeightedGraph(int V, int E) {
        this(V);
        if (E < 0) {
            throw new IllegalArgumentException("Number of edges in a Graph must be nonnegative");
        }
        for (int i = 0; i < E; ++i) {
            int v = (int)(Math.random() * (double)V);
            int w = (int)(Math.random() * (double)V);
            double weight = (double)Math.round(100.0 * Math.random()) / 100.0;
            Edge e = new Edge(v, w, weight);
            this.addEdge(e);
        }
    }

    public EdgeWeightedGraph(In in) {
        this(in.readInt());
        int E = in.readInt();
        for (int i = 0; i < E; ++i) {
            int v = in.readInt();
            int w = in.readInt();
            double weight = in.readDouble();
            Edge e = new Edge(v, w, weight);
            this.addEdge(e);
        }
    }

    public EdgeWeightedGraph(EdgeWeightedGraph G) {
        this(G.V());
        this.E = G.E();
        for (int v = 0; v < G.V(); ++v) {
            Stack<Edge> reverse = new Stack<Edge>();
            for (Edge e : G.adj[v]) {
                reverse.push(e);
            }
            for (Edge e : reverse) {
                this.adj[v].add(e);
            }
        }
    }

    public int V() {
        return this.V;
    }

    public int E() {
        return this.E;
    }

    public void addEdge(Edge e) {
        int v = e.either();
        int w = e.other(v);
        this.adj[v].add(e);
        this.adj[w].add(e);
        ++this.E;
    }

    public int test() {
        return -1;
    }

    public Iterable<Edge> adj(int v) {
        return this.adj[v];
    }

    public Iterable<Edge> edges() {
        Bag<Edge> list = new Bag<Edge>();
        for (int v = 0; v < this.V; ++v) {
            int selfLoops = 0;
            for (Edge e : this.adj(v)) {
                if (e.other(v) > v) {
                    list.add(e);
                    continue;
                }
                if (e.other(v) != v) continue;
                if (selfLoops % 2 == 0) {
                    list.add(e);
                }
                ++selfLoops;
            }
        }
        return list;
    }

    public String toString() {
        String NEWLINE = System.getProperty("line.separator");
        StringBuilder s = new StringBuilder();
        s.append(this.V + " " + this.E + NEWLINE);
        for (int v = 0; v < this.V; ++v) {
            s.append(v + ": ");
            for (Edge e : this.adj[v]) {
                s.append(e + "  ");
            }
            s.append(NEWLINE);
        }
        return s.toString();
    }

    public static void main(String[] args) {
        In in = new In(args[0]);
        EdgeWeightedGraph G = new EdgeWeightedGraph(in);
        StdOut.println(G);
    }
}

