/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.clustering;

import java.util.HashMap;
import java.util.LinkedList;
import net.semanticmetadata.lire.clustering.Cluster;
import net.semanticmetadata.lire.clustering.KMeans;

public class ParallelKMeans
extends KMeans {
    public ParallelKMeans(int numClusters) {
        super(numClusters);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void reOrganizeFeatures() {
        int numThreads = 8;
        int step = this.features.size() / numThreads;
        LinkedList<void> tasks = new LinkedList<void>();
        LinkedList<Thread> threads = new LinkedList<Thread>();
        for (int i = 0; i < numThreads; ++i) {
            void var6_7;
            if (i + 1 < numThreads) {
                FeatureToClass featureToClass = new FeatureToClass(i * step, (i + 1) * step);
            } else {
                FeatureToClass featureToClass = new FeatureToClass(i * step, this.features.size());
            }
            Thread thread = new Thread((Runnable)var6_7);
            thread.start();
            tasks.add(var6_7);
            threads.add(thread);
        }
        for (Thread thread : threads) {
            try {
                thread.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        for (FeatureToClass featureToClass : tasks) {
            HashMap<Integer, Integer> results = featureToClass.getResults();
            for (int key : results.keySet()) {
                this.clusters[results.get((Object)Integer.valueOf((int)key)).intValue()].members.add(key);
            }
        }
    }

    private synchronized Cluster getCluster(int index) {
        return this.clusters[index];
    }

    private void recomputeMeanOfCluster(int clusterIndex) {
        int length = ((double[])this.features.get(0)).length;
        Cluster cluster = this.getCluster(clusterIndex);
        double[] mean = cluster.mean;
        for (int j = 0; j < length; ++j) {
            mean[j] = 0.0;
            for (Integer member : cluster.members) {
                double v = ((double[])this.features.get(member))[j];
                int n = j;
                mean[n] = mean[n] + v;
            }
            if (cluster.members.size() <= 1) continue;
            mean[j] = mean[j] / (double)cluster.members.size();
        }
        double v = 0.0;
        for (Integer member : cluster.members) {
            double tmpStress = 0.0;
            for (int k = 0; k < length; ++k) {
                double f = Math.abs(mean[k] - ((double[])this.features.get(member))[k]);
                tmpStress += f;
            }
            v += tmpStress;
        }
        cluster.setStress(v);
    }

    private class FeatureToClass
    implements Runnable {
        HashMap<Integer, Integer> results;
        int start;
        int end;

        private FeatureToClass(int start, int end) {
            this.start = start;
            this.end = end;
            this.results = new HashMap(end - start);
        }

        @Override
        public void run() {
            for (int k = this.start; k < this.end; ++k) {
                double[] f = (double[])ParallelKMeans.this.features.get(k);
                int best = 0;
                double minDistance = ParallelKMeans.this.clusters[0].getDistance(f);
                for (int i = 1; i < ParallelKMeans.this.clusters.length; ++i) {
                    double v = ParallelKMeans.this.clusters[i].getDistance(f);
                    if (!(minDistance > v)) continue;
                    best = i;
                    minDistance = v;
                }
                this.results.put(k, best);
            }
        }

        public HashMap<Integer, Integer> getResults() {
            return this.results;
        }
    }
}

