/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.imageanalysis;

import java.awt.image.BufferedImage;
import net.semanticmetadata.lire.imageanalysis.LireFeature;
import net.semanticmetadata.lire.utils.MetricsUtils;
import net.semanticmetadata.lire.utils.SerializationUtils;

public class GenericByteLireFeature
implements LireFeature {
    protected byte[] data = null;

    @Override
    public String getFeatureName() {
        return "GenericByteFeature";
    }

    @Override
    public String getFieldName() {
        return "featGenericByte";
    }

    @Override
    public void extract(BufferedImage image) {
        throw new UnsupportedOperationException("Extraction not supported.");
    }

    @Override
    public byte[] getByteArrayRepresentation() {
        if (this.data == null) {
            throw new UnsupportedOperationException("You need to set the histogram first.");
        }
        return this.data;
    }

    @Override
    public void setByteArrayRepresentation(byte[] featureData) {
        this.setByteArrayRepresentation(featureData, 0, featureData.length);
    }

    @Override
    public void setByteArrayRepresentation(byte[] featureData, int offset, int length) {
        this.data = new byte[length];
        System.arraycopy(featureData, offset, this.data, 0, length);
    }

    @Override
    public double[] getDoubleHistogram() {
        return SerializationUtils.castToDoubleArray(this.data);
    }

    @Override
    public float getDistance(LireFeature feature) {
        if (!(feature instanceof GenericByteLireFeature)) {
            throw new UnsupportedOperationException("This is not a GenericByteLireFeature object.");
        }
        assert (((GenericByteLireFeature)feature).data.length == this.data.length);
        return (float)MetricsUtils.distL1(((GenericByteLireFeature)feature).data, this.data);
    }

    @Override
    public String getStringRepresentation() {
        if (this.data == null) {
            throw new UnsupportedOperationException("You need to set the histogram first.");
        }
        return SerializationUtils.toString(this.data);
    }

    @Override
    public void setStringRepresentation(String featureVector) {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public void setData(double[] doubleData) {
        this.data = new byte[doubleData.length];
        for (int i = 0; i < doubleData.length; ++i) {
            this.data[i] = (byte)doubleData[i];
        }
    }
}

