/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.imageanalysis;

import java.awt.image.BufferedImage;
import java.util.Arrays;
import net.semanticmetadata.lire.imageanalysis.CEDD;
import net.semanticmetadata.lire.imageanalysis.FCTH;
import net.semanticmetadata.lire.imageanalysis.LireFeature;

public class JCD
implements LireFeature {
    protected double[] data = new double[168];
    int tmp;
    double result = 0.0;
    double temp1 = 0.0;
    double temp2 = 0.0;
    double TempCount1 = 0.0;
    double TempCount2 = 0.0;
    double TempCount3 = 0.0;

    public JCD(CEDD cedd, FCTH fcth) {
        this.init(cedd, fcth);
    }

    public JCD() {
    }

    public static double getDistance(double[] histogram1, double[] histogram2) {
        int i;
        double temp1 = 0.0;
        double temp2 = 0.0;
        double TempCount1 = 0.0;
        double TempCount2 = 0.0;
        double TempCount3 = 0.0;
        for (i = 0; i < histogram1.length; ++i) {
            temp1 += histogram1[i];
            temp2 += histogram2[i];
        }
        if (temp1 == 0.0 && temp2 == 0.0) {
            return 0.0;
        }
        if (temp1 == 0.0 || temp2 == 0.0) {
            return 100.0;
        }
        for (i = 0; i < histogram1.length; ++i) {
            TempCount1 += histogram2[i] / temp2 * (histogram1[i] / temp1);
            TempCount2 += histogram1[i] / temp1 * (histogram1[i] / temp1);
            TempCount3 += histogram2[i] / temp2 * (histogram2[i] / temp2);
        }
        return 100.0 - 100.0 * (TempCount1 / (TempCount2 + TempCount3 - TempCount1));
    }

    @Override
    public void extract(BufferedImage bimg) {
        CEDD c = new CEDD();
        c.extract(bimg);
        FCTH f = new FCTH();
        f.extract(bimg);
        this.init(c, f);
    }

    @Override
    public byte[] getByteArrayRepresentation() {
        int len = 0;
        int tmpVal = 0;
        byte[] result = new byte[this.data.length];
        for (int i = 0; i < this.data.length; ++i) {
            if (this.data[i] > 0.0) {
                if (tmpVal < 0) {
                    result[len] = tmpVal;
                    tmpVal = 0;
                    ++len;
                }
                result[len] = (byte)(2.0 * this.data[i]);
                ++len;
                continue;
            }
            tmpVal = (byte)(tmpVal - 1);
        }
        if (tmpVal < 0) {
            result[len] = tmpVal;
            ++len;
        }
        return Arrays.copyOf(result, len);
    }

    @Override
    public void setByteArrayRepresentation(byte[] in) {
        this.setByteArrayRepresentation(in, 0, in.length);
    }

    @Override
    public void setByteArrayRepresentation(byte[] in, int offset, int length) {
        this.tmp = 0;
        Arrays.fill(this.data, 0.0);
        for (int i = 0; i < length; ++i) {
            if (in[offset + i] > 0) {
                this.data[this.tmp] = (double)in[offset + i] / 2.0;
                ++this.tmp;
                continue;
            }
            for (int j = 0; j < Math.abs(in[offset + i]); ++j) {
                this.data[this.tmp] = 0.0;
                ++this.tmp;
            }
        }
    }

    @Override
    public double[] getDoubleHistogram() {
        return this.data;
    }

    public void init(CEDD c, FCTH f) {
        this.data = this.joinHistograms(c.getDoubleHistogram(), f.histogram);
    }

    @Override
    public float getDistance(LireFeature vd) {
        if (!(vd instanceof JCD)) {
            throw new UnsupportedOperationException("Wrong descriptor.");
        }
        if (((JCD)vd).data.length != this.data.length) {
            throw new UnsupportedOperationException("Histogram lengths or color spaces do not match");
        }
        return (float)JCD.getDistance(this.data, ((JCD)vd).data);
    }

    @Override
    public String getStringRepresentation() {
        throw new UnsupportedOperationException("This is not meant to be used!");
    }

    @Override
    public void setStringRepresentation(String s) {
        throw new UnsupportedOperationException("This is not meant to be used!");
    }

    private double[] joinHistograms(double[] CEDD2, double[] FCTH2) {
        int i;
        double[] JointDescriptor = new double[168];
        double[] TempTable1 = new double[24];
        double[] TempTable2 = new double[24];
        double[] TempTable3 = new double[24];
        double[] TempTable4 = new double[24];
        for (i = 0; i < 24; ++i) {
            TempTable1[i] = FCTH2[0 + i] + FCTH2[96 + i];
            TempTable2[i] = FCTH2[24 + i] + FCTH2[120 + i];
            TempTable3[i] = FCTH2[48 + i] + FCTH2[144 + i];
            TempTable4[i] = FCTH2[72 + i] + FCTH2[168 + i];
        }
        for (i = 0; i < 24; ++i) {
            JointDescriptor[i] = (TempTable1[i] + CEDD2[i]) / 2.0;
            JointDescriptor[24 + i] = (TempTable2[i] + CEDD2[48 + i]) / 2.0;
            JointDescriptor[48 + i] = CEDD2[96 + i];
            JointDescriptor[72 + i] = (TempTable3[i] + CEDD2[72 + i]) / 2.0;
            JointDescriptor[96 + i] = CEDD2[120 + i];
            JointDescriptor[120 + i] = TempTable4[i];
            JointDescriptor[144 + i] = CEDD2[24 + i];
        }
        return JointDescriptor;
    }

    @Override
    public String getFeatureName() {
        return "JCD";
    }

    @Override
    public String getFieldName() {
        return "featureJCD";
    }
}

