/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.imageanalysis;

import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.util.StringTokenizer;
import net.semanticmetadata.lire.imageanalysis.Histogram;
import net.semanticmetadata.lire.imageanalysis.LireFeature;
import net.semanticmetadata.lire.utils.ImageUtils;
import net.semanticmetadata.lire.utils.MetricsUtils;
import net.semanticmetadata.lire.utils.SerializationUtils;

public class OpponentHistogram
extends Histogram
implements LireFeature {
    final double sq2 = Math.sqrt(2.0);
    final double sq6 = Math.sqrt(3.0);
    final double sq3 = Math.sqrt(6.0);
    double o1;
    double o2;
    double o3;
    double tmpVal;
    double tmpSum;
    byte[] histogram = new byte[64];

    @Override
    public void extract(BufferedImage bimg) {
        int i;
        bimg = ImageUtils.get8BitRGBImage(bimg);
        double[] histogram = new double[64];
        for (int i2 = 0; i2 < histogram.length; ++i2) {
            histogram[i2] = 0.0;
        }
        WritableRaster raster = bimg.getRaster();
        int[] px = new int[3 * (raster.getHeight() - 2)];
        for (int x = 1; x < raster.getWidth() - 1; ++x) {
            raster.getPixels(x, 1, 1, raster.getHeight() - 2, px);
            for (int y = 0; y < raster.getHeight() - 2; ++y) {
                int colorPos;
                this.o1 = (double)(px[y * 3] - px[y * 3 + 1]) / this.sq2;
                this.o2 = (double)(px[y * 3] + px[y * 3 + 1] - 2 * px[y * 3 + 2]) / this.sq6;
                this.o3 = (double)(px[y * 3] + px[y * 3 + 1] + px[y * 3 + 2]) / this.sq3;
                this.o1 = (this.o1 + 255.0 / this.sq2) / (510.0 / this.sq2);
                this.o2 = (this.o2 + 510.0 / this.sq6) / (1020.0 / this.sq6);
                this.o3 /= 765.0 / this.sq3;
                int n = colorPos = (int)Math.min(Math.floor(this.o1 * 4.0), 3.0) + (int)Math.min(Math.floor(this.o2 * 4.0), 3.0) * 4 + (int)Math.min(3.0, Math.floor(this.o3 * 4.0)) * 4 * 4;
                histogram[n] = histogram[n] + 1.0;
            }
        }
        double max = 0.0;
        for (i = 0; i < histogram.length; ++i) {
            max = Math.max(histogram[i], max);
        }
        for (i = 0; i < histogram.length; ++i) {
            this.histogram[i] = (byte)Math.floor(127.0 * (histogram[i] / max));
        }
    }

    @Override
    public byte[] getByteArrayRepresentation() {
        byte[] result = new byte[this.histogram.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.histogram[i];
        }
        return result;
    }

    @Override
    public void setByteArrayRepresentation(byte[] in) {
        for (int i = 0; i < this.histogram.length; ++i) {
            this.histogram[i] = in[i];
        }
    }

    @Override
    public void setByteArrayRepresentation(byte[] in, int offset, int length) {
        for (int i = 0; i < length; ++i) {
            this.histogram[i] = in[i + offset];
        }
    }

    @Override
    public double[] getDoubleHistogram() {
        return SerializationUtils.castToDoubleArray(this.histogram);
    }

    @Override
    public float getDistance(LireFeature feature) {
        if (!(feature instanceof OpponentHistogram)) {
            throw new UnsupportedOperationException("Wrong descriptor.");
        }
        return (float)MetricsUtils.jsd(((OpponentHistogram)feature).histogram, this.histogram);
    }

    public double getDistance(byte[] h1, byte[] h2) {
        return this.getDistance(h1, 0, h1.length, h2, 0, h2.length);
    }

    public double getDistance(byte[] h1, int offset1, int length1, byte[] h2, int offset2, int length2) {
        this.tmpSum = 0.0;
        for (int i = 0; i < length1; ++i) {
            this.tmpVal = h1[i + offset1] + h2[i + offset2];
            this.tmpSum += (h1[i + offset1] > 0 ? (double)h1[i + offset1] / 2.0 * Math.log(2.0 * (double)h1[i + offset1] / this.tmpVal) : 0.0) + (h2[i + offset2] > 0 ? (double)h2[i + offset2] / 2.0 * Math.log(2.0 * (double)h2[i + offset2] / this.tmpVal) : 0.0);
        }
        return this.tmpSum;
    }

    @Override
    public String getStringRepresentation() {
        StringBuilder sb = new StringBuilder(this.histogram.length * 2 + 25);
        sb.append("ophist");
        sb.append(' ');
        sb.append(this.histogram.length);
        sb.append(' ');
        byte[] arr$ = this.histogram;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            double aData = arr$[i$];
            sb.append((int)aData);
            sb.append(' ');
        }
        return sb.toString().trim();
    }

    @Override
    public void setStringRepresentation(String s) {
        StringTokenizer st = new StringTokenizer(s);
        if (!st.nextToken().equals("ophist")) {
            throw new UnsupportedOperationException("This is not a OpponentHistogram descriptor.");
        }
        for (int i = 0; i < this.histogram.length; ++i) {
            if (!st.hasMoreTokens()) {
                throw new IndexOutOfBoundsException("Too few numbers in string representation.");
            }
            this.histogram[i] = (byte)Integer.parseInt(st.nextToken());
        }
    }

    @Override
    public String getFeatureName() {
        return "OpponentHistogram";
    }

    @Override
    public String getFieldName() {
        return "featOpHist";
    }
}

