/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.imageanalysis;

import com.stromberglabs.jopensurf.SURFInterestPoint;
import java.awt.image.BufferedImage;
import java.util.LinkedList;
import java.util.StringTokenizer;
import net.semanticmetadata.lire.imageanalysis.Histogram;
import net.semanticmetadata.lire.imageanalysis.LireFeature;
import net.semanticmetadata.lire.utils.MetricsUtils;
import net.semanticmetadata.lire.utils.SerializationUtils;

public class SurfFeature
extends Histogram
implements LireFeature {
    SURFInterestPoint sip;

    public SurfFeature(SURFInterestPoint surfInterestPoint) {
        this.sip = surfInterestPoint;
        this.descriptor = SerializationUtils.toDoubleArray(this.sip.getDescriptor());
    }

    public SurfFeature() {
        this.sip = null;
    }

    @Override
    public void extract(BufferedImage bimg) {
    }

    @Override
    public float getDistance(LireFeature feature) {
        if (!(feature instanceof SurfFeature)) {
            return -1.0f;
        }
        return (float)MetricsUtils.distL2(this.descriptor, ((SurfFeature)feature).descriptor);
    }

    @Override
    public String getStringRepresentation() {
        throw new UnsupportedOperationException("No implemented!");
    }

    @Override
    public void setStringRepresentation(String s) {
        double[] result = null;
        LinkedList<Float> tmp = new LinkedList<Float>();
        StringTokenizer st = new StringTokenizer(s);
        st.nextToken();
        st.nextToken();
        st.nextToken();
        while (st.hasMoreTokens()) {
            tmp.add(Float.valueOf(Float.parseFloat(st.nextToken())));
        }
        result = new double[tmp.size()];
        int i = 0;
        for (Float next : tmp) {
            result[i] = next.floatValue();
            ++i;
        }
        this.descriptor = result;
    }

    @Override
    public byte[] getByteArrayRepresentation() {
        return SerializationUtils.toByteArray(this.descriptor);
    }

    @Override
    public void setByteArrayRepresentation(byte[] in) {
        this.descriptor = SerializationUtils.toDoubleArray(in);
    }

    @Override
    public void setByteArrayRepresentation(byte[] in, int offset, int length) {
        this.descriptor = SerializationUtils.toDoubleArray(in, offset, length);
    }

    @Override
    public double[] getDoubleHistogram() {
        return this.descriptor;
    }

    @Override
    public String getFeatureName() {
        return "SURF";
    }

    @Override
    public String getFieldName() {
        return "featureSurf";
    }
}

