/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.imageanalysis.correlogram;

import net.semanticmetadata.lire.imageanalysis.correlogram.IAutoCorrelogramFeatureExtractor;

public class NaiveAutoCorrelogramExtraction
implements IAutoCorrelogramFeatureExtractor {
    @Override
    public float[][] extract(int maxFeatureValue, int[] distanceSet, int[][] img) {
        long totalComplexity = 0L;
        int[] histogram = new int[maxFeatureValue];
        float[][] correlogram = new float[maxFeatureValue][distanceSet.length];
        int W = img.length;
        int H = img[0].length;
        for (int x = 0; x < W; ++x) {
            for (int y = 0; y < H; ++y) {
                int n = img[x][y];
                histogram[n] = histogram[n] + 1;
                ++totalComplexity;
            }
        }
        int N_DIST = distanceSet.length;
        for (int di = 0; di < N_DIST; ++di) {
            int d = distanceSet[di];
            for (int x = 0; x < W; ++x) {
                for (int y = 0; y < H; ++y) {
                    int Y;
                    int X;
                    int c = img[x][y];
                    for (int dx = -d; dx <= d; ++dx) {
                        X = x + dx;
                        Y = y - d;
                        if (0 <= X && X < W && 0 <= Y && Y < H && img[X][Y] == c) {
                            float[] fArray = correlogram[c];
                            int n = di;
                            fArray[n] = fArray[n] + 1.0f;
                            ++totalComplexity;
                        }
                        Y = y + d;
                        if (0 > X || X >= W || 0 > Y || Y >= H || img[X][Y] != c) continue;
                        float[] fArray = correlogram[c];
                        int n = di;
                        fArray[n] = fArray[n] + 1.0f;
                        ++totalComplexity;
                    }
                    for (int dy = -d + 1; dy <= d - 1; ++dy) {
                        X = x - d;
                        Y = y + dy;
                        if (0 <= X && X < W && 0 <= Y && Y < H && img[X][Y] == c) {
                            float[] fArray = correlogram[c];
                            int n = di;
                            fArray[n] = fArray[n] + 1.0f;
                            ++totalComplexity;
                        }
                        if (0 > (X = x + d) || X >= W || 0 > Y || Y >= H || img[X][Y] != c) continue;
                        float[] fArray = correlogram[c];
                        int n = di;
                        fArray[n] = fArray[n] + 1.0f;
                        ++totalComplexity;
                    }
                }
            }
            for (int c = 0; c < maxFeatureValue; ++c) {
                if (histogram[c] <= 0) continue;
                correlogram[c][di] = (float)Math.floor(16.0 * (double)(correlogram[c][di] / ((float)histogram[c] * 8.0f * (float)d)));
            }
        }
        return correlogram;
    }
}

