/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.imageanalysis.fcth;

import net.semanticmetadata.lire.imageanalysis.fcth.FuzzyRules;

public class Fuzzy24Bin {
    public double[] ResultsTable = new double[3];
    public double[] Fuzzy24BinHisto = new double[24];
    public boolean KeepPreviusValues = false;
    protected double[] SaturationMembershipValues = new double[]{0.0, 0.0, 68.0, 188.0, 68.0, 188.0, 255.0, 255.0};
    protected double[] ValueMembershipValues = new double[]{0.0, 0.0, 68.0, 188.0, 68.0, 188.0, 255.0, 255.0};
    public FuzzyRules[] Fuzzy24BinRules = new FuzzyRules[4];
    public double[] SaturationActivation = new double[2];
    public double[] ValueActivation = new double[2];
    public int[][] Fuzzy24BinRulesDefinition = new int[][]{{1, 1, 1}, {0, 0, 2}, {0, 1, 0}, {1, 0, 2}};

    public Fuzzy24Bin(boolean KeepPreviuesValues) {
        for (int R = 0; R < 4; ++R) {
            this.Fuzzy24BinRules[R] = new FuzzyRules();
            this.Fuzzy24BinRules[R].Input1 = this.Fuzzy24BinRulesDefinition[R][0];
            this.Fuzzy24BinRules[R].Input2 = this.Fuzzy24BinRulesDefinition[R][1];
            this.Fuzzy24BinRules[R].Output = this.Fuzzy24BinRulesDefinition[R][2];
        }
        this.KeepPreviusValues = KeepPreviuesValues;
    }

    private void FindMembershipValueForTriangles(double Input, double[] Triangles, double[] MembershipFunctionToSave) {
        int Temp = 0;
        for (int i = 0; i <= Triangles.length - 1; i += 4) {
            MembershipFunctionToSave[Temp] = 0.0;
            if (Input >= Triangles[i + 1] && Input <= Triangles[i + 2]) {
                MembershipFunctionToSave[Temp] = 1.0;
            }
            if (Input >= Triangles[i] && Input < Triangles[i + 1]) {
                MembershipFunctionToSave[Temp] = (Input - Triangles[i]) / (Triangles[i + 1] - Triangles[i]);
            }
            if (Input > Triangles[i + 2] && Input <= Triangles[i + 3]) {
                MembershipFunctionToSave[Temp] = (Input - Triangles[i + 2]) / (Triangles[i + 2] - Triangles[i + 3]) + 1.0;
            }
            ++Temp;
        }
    }

    private void LOM_Defazzificator(FuzzyRules[] Rules, double[] Input1, double[] Input2, double[] ResultTable) {
        int RuleActivation = -1;
        double LOM_MAXofMIN = 0.0;
        for (int i = 0; i < Rules.length; ++i) {
            if (!(Input1[Rules[i].Input1] > 0.0) || !(Input2[Rules[i].Input2] > 0.0)) continue;
            double Min = 0.0;
            Min = Math.min(Input1[Rules[i].Input1], Input2[Rules[i].Input2]);
            if (!(Min > LOM_MAXofMIN)) continue;
            LOM_MAXofMIN = Min;
            RuleActivation = Rules[i].Output;
        }
        int n = RuleActivation;
        ResultTable[n] = ResultTable[n] + 1.0;
    }

    private void MultiParticipate_Equal_Defazzificator(FuzzyRules[] Rules, double[] Input1, double[] Input2, double[] ResultTable) {
        int RuleActivation = -1;
        for (int i = 0; i < Rules.length; ++i) {
            if (!(Input1[Rules[i].Input1] > 0.0) || !(Input2[Rules[i].Input2] > 0.0)) continue;
            int n = RuleActivation = Rules[i].Output;
            ResultTable[n] = ResultTable[n] + 1.0;
        }
    }

    private void MultiParticipate_Defazzificator(FuzzyRules[] Rules, double[] Input1, double[] Input2, double[] ResultTable) {
        int RuleActivation = -1;
        double Min = 0.0;
        for (int i = 0; i < Rules.length; ++i) {
            if (!(Input1[Rules[i].Input1] > 0.0) || !(Input2[Rules[i].Input2] > 0.0)) continue;
            Min = Math.min(Input1[Rules[i].Input1], Input2[Rules[i].Input2]);
            int n = RuleActivation = Rules[i].Output;
            ResultTable[n] = ResultTable[n] + Min;
        }
    }

    public double[] ApplyFilter(double Hue, double Saturation, double Value, double[] ColorValues, int Method2) {
        int i;
        this.ResultsTable[0] = 0.0;
        this.ResultsTable[1] = 0.0;
        this.ResultsTable[2] = 0.0;
        double Temp = 0.0;
        this.FindMembershipValueForTriangles(Saturation, this.SaturationMembershipValues, this.SaturationActivation);
        this.FindMembershipValueForTriangles(Value, this.ValueMembershipValues, this.ValueActivation);
        if (!this.KeepPreviusValues) {
            for (i = 0; i < 24; ++i) {
                this.Fuzzy24BinHisto[i] = 0.0;
            }
        }
        for (i = 3; i < 10; ++i) {
            Temp += ColorValues[i];
        }
        if (Temp > 0.0) {
            if (Method2 == 0) {
                this.LOM_Defazzificator(this.Fuzzy24BinRules, this.SaturationActivation, this.ValueActivation, this.ResultsTable);
            }
            if (Method2 == 1) {
                this.MultiParticipate_Equal_Defazzificator(this.Fuzzy24BinRules, this.SaturationActivation, this.ValueActivation, this.ResultsTable);
            }
            if (Method2 == 2) {
                this.MultiParticipate_Defazzificator(this.Fuzzy24BinRules, this.SaturationActivation, this.ValueActivation, this.ResultsTable);
            }
        }
        for (i = 0; i < 3; ++i) {
            int n = i;
            this.Fuzzy24BinHisto[n] = this.Fuzzy24BinHisto[n] + ColorValues[i];
        }
        for (i = 3; i < 10; ++i) {
            int n = (i - 2) * 3;
            this.Fuzzy24BinHisto[n] = this.Fuzzy24BinHisto[n] + ColorValues[i] * this.ResultsTable[0];
            int n2 = (i - 2) * 3 + 1;
            this.Fuzzy24BinHisto[n2] = this.Fuzzy24BinHisto[n2] + ColorValues[i] * this.ResultsTable[1];
            int n3 = (i - 2) * 3 + 2;
            this.Fuzzy24BinHisto[n3] = this.Fuzzy24BinHisto[n3] + ColorValues[i] * this.ResultsTable[2];
        }
        return this.Fuzzy24BinHisto;
    }
}

