/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cwt.font.afm;

import de.intarsys.cwt.font.afm.AFM;
import de.intarsys.cwt.font.afm.AFMChar;
import de.intarsys.tools.collection.ByteArrayTools;
import de.intarsys.tools.randomaccess.IRandomAccess;
import de.intarsys.tools.stream.FastByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;

public class AFMParser {
    protected static final byte[] characterClass = new byte[256];
    protected static final byte CHARCLASS_ANY = 0;
    protected static final byte CHARCLASS_DELIMITER = 1;
    protected static final byte CHARCLASS_DIGIT = 4;
    protected static final byte CHARCLASS_NUMBERSPECIAL = 5;
    protected static final byte CHARCLASS_TOKEN = 3;
    protected static final byte CHARCLASS_WHITESPACE = 2;
    private static final byte[] TOKEN_Comment = "Comment".getBytes();
    private static final byte[] TOKEN_EndCharMetrics = "EndCharMetrics".getBytes();
    private static final byte[] TOKEN_EndFlag = "End".getBytes();
    private static final byte[] TOKEN_EndFontMetrics = "EndFontMetrics".getBytes();
    private static final byte[] TOKEN_StartCharMetrics = "StartCharMetrics".getBytes();
    private static final byte[] TOKEN_StartFlag = "Start".getBytes();
    private static final byte[] TOKEN_StartFontMetrics = "StartFontMetrics".getBytes();
    public static char CHAR_BS = (char)8;
    public static char CHAR_CR = (char)13;
    public static char CHAR_FF = (char)12;
    public static char CHAR_HT = (char)9;
    public static char CHAR_LF = (char)10;
    private AFM afm;
    private FastByteArrayOutputStream localStream = new FastByteArrayOutputStream();

    static {
        int n = 0;
        while (n < 256) {
            AFMParser.characterClass[n] = 0;
            ++n;
        }
        AFMParser.characterClass[40] = 1;
        AFMParser.characterClass[41] = 1;
        AFMParser.characterClass[60] = 1;
        AFMParser.characterClass[62] = 1;
        AFMParser.characterClass[91] = 1;
        AFMParser.characterClass[93] = 1;
        AFMParser.characterClass[123] = 1;
        AFMParser.characterClass[125] = 1;
        AFMParser.characterClass[47] = 1;
        AFMParser.characterClass[37] = 1;
        AFMParser.characterClass[32] = 2;
        AFMParser.characterClass[9] = 2;
        AFMParser.characterClass[13] = 2;
        AFMParser.characterClass[10] = 2;
        AFMParser.characterClass[12] = 2;
        AFMParser.characterClass[0] = 2;
        AFMParser.characterClass[48] = 4;
        AFMParser.characterClass[49] = 4;
        AFMParser.characterClass[50] = 4;
        AFMParser.characterClass[51] = 4;
        AFMParser.characterClass[52] = 4;
        AFMParser.characterClass[53] = 4;
        AFMParser.characterClass[54] = 4;
        AFMParser.characterClass[55] = 4;
        AFMParser.characterClass[56] = 4;
        AFMParser.characterClass[57] = 4;
        AFMParser.characterClass[46] = 5;
        AFMParser.characterClass[45] = 5;
        AFMParser.characterClass[43] = 5;
        n = 97;
        while (n <= 122) {
            AFMParser.characterClass[n] = 3;
            ++n;
        }
        n = 65;
        while (n <= 90) {
            AFMParser.characterClass[n] = 3;
            ++n;
        }
    }

    public static final boolean isEOL(int n) {
        return n == CHAR_CR || n == CHAR_LF || n == 12;
    }

    public static final boolean isWhitespace(int n) {
        return characterClass[n] == 2;
    }

    public AFMParser(AFM aFM) {
        this.afm = aFM;
    }

    public AFM parse(IRandomAccess iRandomAccess) throws IOException {
        this.read(iRandomAccess);
        return this.afm;
    }

    protected void read(IRandomAccess iRandomAccess) throws IOException {
        byte[] byArray = this.readToken(iRandomAccess);
        if (!Arrays.equals(byArray, TOKEN_StartFontMetrics)) {
            throw new IOException("afm stream does not start with " + new String(TOKEN_StartFontMetrics));
        }
        this.readToken(iRandomAccess);
        byArray = this.readFontMetrics(iRandomAccess);
        if (byArray == null || !Arrays.equals(byArray, TOKEN_EndFontMetrics)) {
            throw new IOException("afm stream does not end with " + new String(TOKEN_EndFontMetrics));
        }
    }

    protected byte[] readBlock(IRandomAccess iRandomAccess) throws IOException {
        byte[] byArray = this.readLine(iRandomAccess);
        while (!ByteArrayTools.startsWith((byte[])byArray, (byte[])TOKEN_EndFlag)) {
            if (!ByteArrayTools.startsWith((byte[])byArray, (byte[])TOKEN_Comment) && ByteArrayTools.startsWith((byte[])byArray, (byte[])TOKEN_StartFlag)) {
                byArray = this.readBlock(iRandomAccess);
            }
            byArray = this.readLine(iRandomAccess);
        }
        return byArray;
    }

    protected byte[] readCharMetrics(IRandomAccess iRandomAccess) throws IOException {
        this.readToken(iRandomAccess);
        byte[] byArray = this.readLine(iRandomAccess);
        while (!ByteArrayTools.startsWith((byte[])byArray, (byte[])TOKEN_EndCharMetrics)) {
            this.afm.addChar(AFMChar.create(new String(byArray)));
            byArray = this.readLine(iRandomAccess);
        }
        return byArray;
    }

    protected byte[] readFontMetrics(IRandomAccess iRandomAccess) throws IOException {
        byte[] byArray = this.readToken(iRandomAccess);
        while (byArray != null && !Arrays.equals(byArray, TOKEN_EndFontMetrics)) {
            if (!Arrays.equals(byArray, TOKEN_Comment)) {
                if (Arrays.equals(byArray, TOKEN_StartCharMetrics)) {
                    byArray = this.readCharMetrics(iRandomAccess);
                } else if (ByteArrayTools.startsWith((byte[])byArray, (byte[])TOKEN_StartFlag)) {
                    byArray = this.readBlock(iRandomAccess);
                } else {
                    String string = new String(this.readLine(iRandomAccess));
                    this.afm.setAttribute(new String(byArray), string);
                }
            }
            byArray = this.readToken(iRandomAccess);
        }
        return byArray;
    }

    public byte[] readLine(IRandomAccess iRandomAccess) throws IOException {
        int n;
        do {
            if ((n = iRandomAccess.read()) != -1) continue;
            return null;
        } while (n == 32 || AFMParser.isWhitespace(n));
        return this.readLineElement(iRandomAccess, n);
    }

    protected byte[] readLineElement(IRandomAccess iRandomAccess, int n) throws IOException {
        this.localStream.reset();
        this.localStream.write(n);
        while ((n = iRandomAccess.read()) != -1 && !AFMParser.isEOL(n)) {
            this.localStream.write(n);
        }
        return this.localStream.toByteArray();
    }

    public void readSpaces(IRandomAccess iRandomAccess) throws IOException {
        int n = 0;
        while ((n = iRandomAccess.read()) != -1) {
            if (n == 32 || AFMParser.isWhitespace(n)) continue;
            iRandomAccess.seekBy(-1L);
            break;
        }
    }

    public byte[] readToken(IRandomAccess iRandomAccess) throws IOException {
        int n;
        do {
            if ((n = iRandomAccess.read()) != -1) continue;
            return null;
        } while (n == 32 || AFMParser.isWhitespace(n));
        return this.readTokenElement(iRandomAccess, n);
    }

    protected byte[] readTokenElement(IRandomAccess iRandomAccess, int n) throws IOException {
        this.localStream.reset();
        this.localStream.write(n);
        while ((n = iRandomAccess.read()) != -1 && n != 32 && !AFMParser.isWhitespace(n)) {
            this.localStream.write(n);
        }
        return this.localStream.toByteArray();
    }
}

