/*
 * Decompiled with CFR 0.152.
 */
package georegression.fitting.plane;

import georegression.struct.point.Point3D_F32;
import georegression.struct.point.Vector3D_F32;
import java.util.List;
import org.ejml.data.DenseMatrix64F;
import org.ejml.data.Matrix64F;
import org.ejml.factory.DecompositionFactory;
import org.ejml.interfaces.decomposition.SingularValueDecomposition;

public class FitPlane3D_F32 {
    SingularValueDecomposition<DenseMatrix64F> svd = DecompositionFactory.svd((int)3, (int)10, (boolean)false, (boolean)true, (boolean)false);
    DenseMatrix64F A = new DenseMatrix64F(3, 3);
    DenseMatrix64F V = new DenseMatrix64F(3, 3);

    public boolean svd(List<Point3D_F32> points, Point3D_F32 outputCenter, Vector3D_F32 outputNormal) {
        int N = points.size();
        outputCenter.set(0.0f, 0.0f, 0.0f);
        for (int i = 0; i < N; ++i) {
            Point3D_F32 p = points.get(i);
            outputCenter.x += p.x;
            outputCenter.y += p.y;
            outputCenter.z += p.z;
        }
        outputCenter.x /= (float)N;
        outputCenter.y /= (float)N;
        outputCenter.z /= (float)N;
        return this.svdPoint(points, outputCenter, outputNormal);
    }

    public boolean svdPoint(List<Point3D_F32> points, Point3D_F32 pointOnPlane, Vector3D_F32 outputNormal) {
        int N = points.size();
        this.A.reshape(N, 3);
        int index = 0;
        for (int i = 0; i < N; ++i) {
            Point3D_F32 p = points.get(i);
            this.A.data[index++] = p.x - pointOnPlane.x;
            this.A.data[index++] = p.y - pointOnPlane.y;
            this.A.data[index++] = p.z - pointOnPlane.z;
        }
        if (!this.svd.decompose((Matrix64F)this.A)) {
            return false;
        }
        double[] sv = this.svd.getSingularValues();
        int smallestIndex = -1;
        double smallestValue = 3.4028234663852886E38;
        for (int i = 0; i < 3; ++i) {
            double v = sv[i];
            if (!(v < smallestValue)) continue;
            smallestValue = v;
            smallestIndex = i;
        }
        this.svd.getV((Matrix64F)this.V, true);
        outputNormal.x = (float)this.V.unsafe_get(smallestIndex, 0);
        outputNormal.y = (float)this.V.unsafe_get(smallestIndex, 1);
        outputNormal.z = (float)this.V.unsafe_get(smallestIndex, 2);
        return true;
    }
}

