/*
 * Decompiled with CFR 0.152.
 */
package georegression.geometry;

import georegression.metric.ClosestPoint2D_F64;
import georegression.struct.line.LineGeneral2D_F64;
import georegression.struct.line.LineParametric2D_F64;
import georegression.struct.line.LinePolar2D_F64;
import georegression.struct.line.LineSegment2D_F64;
import georegression.struct.point.Point2D_F64;

public class UtilLine2D_F64 {
    public static double acuteAngle(LineGeneral2D_F64 a, LineGeneral2D_F64 b) {
        double lb;
        double la = Math.sqrt(a.A * a.A + a.B * a.B);
        double value = (a.A * b.A + a.B * b.B) / (la * (lb = Math.sqrt(b.A * b.A + b.B * b.B)));
        if (value < -1.0) {
            value = -1.0;
        } else if (value > 1.0) {
            value = 1.0;
        }
        return Math.acos(value);
    }

    public static double acuteAngleN(LineGeneral2D_F64 a, LineGeneral2D_F64 b) {
        double value = a.A * b.A + a.B * b.B;
        if (value < -1.0) {
            value = -1.0;
        } else if (value > 1.0) {
            value = 1.0;
        }
        return Math.acos(value);
    }

    public static LineParametric2D_F64 convert(LinePolar2D_F64 src, LineParametric2D_F64 ret) {
        if (ret == null) {
            ret = new LineParametric2D_F64();
        }
        double c = Math.cos(src.angle);
        double s = Math.sin(src.angle);
        ret.p.set(c * src.distance, s * src.distance);
        ret.slope.set(-s, c);
        return ret;
    }

    public static LineGeneral2D_F64 convert(LinePolar2D_F64 src, LineGeneral2D_F64 ret) {
        if (ret == null) {
            ret = new LineGeneral2D_F64();
        }
        double c = Math.cos(src.angle);
        double s = Math.sin(src.angle);
        ret.A = c;
        ret.B = s;
        ret.C = -src.distance;
        return ret;
    }

    public static LinePolar2D_F64 convert(LineGeneral2D_F64 src, LinePolar2D_F64 ret) {
        if (ret == null) {
            ret = new LinePolar2D_F64();
        }
        double r = Math.sqrt(src.A * src.A + src.B * src.B);
        double sign = src.C < 0.0 ? -1.0 : 1.0;
        ret.angle = Math.atan2(-sign * src.B / r, -sign * src.A / r);
        ret.distance = sign * src.C / r;
        return ret;
    }

    public static LineParametric2D_F64 convert(LineSegment2D_F64 src, LineParametric2D_F64 ret) {
        if (ret == null) {
            ret = new LineParametric2D_F64();
        }
        ret.p.set(src.a);
        ret.slope.set(src.slopeX(), src.slopeY());
        return ret;
    }

    public static LineGeneral2D_F64 convert(LineSegment2D_F64 src, LineGeneral2D_F64 ret) {
        if (ret == null) {
            ret = new LineGeneral2D_F64();
        }
        ret.A = src.a.y - src.b.y;
        ret.B = src.b.x - src.a.x;
        ret.C = -(ret.A * src.a.x + ret.B * src.a.y);
        return ret;
    }

    public static LinePolar2D_F64 convert(LineParametric2D_F64 src, LinePolar2D_F64 ret) {
        if (ret == null) {
            ret = new LinePolar2D_F64();
        }
        double t = ClosestPoint2D_F64.closestPointT(src, new Point2D_F64());
        double cpX = src.slope.x * t + src.p.x;
        double cpY = src.slope.y * t + src.p.y;
        ret.angle = Math.atan2(cpY, cpX);
        ret.distance = Math.sqrt(cpX * cpX + cpY * cpY);
        return ret;
    }

    public static LineGeneral2D_F64 convert(LineParametric2D_F64 src, LineGeneral2D_F64 ret) {
        if (ret == null) {
            ret = new LineGeneral2D_F64();
        }
        double x1 = src.p.x + src.slope.x;
        double y1 = src.p.y + src.slope.y;
        ret.A = src.p.y - y1;
        ret.B = x1 - src.p.x;
        ret.C = src.p.x * y1 - x1 * src.p.y;
        return ret;
    }

    public static LineParametric2D_F64 convert(LineGeneral2D_F64 src, LineParametric2D_F64 ret) {
        if (ret == null) {
            ret = new LineParametric2D_F64();
        }
        ret.slope.x = src.B;
        ret.slope.y = -src.A;
        if (Math.abs(src.B) > Math.abs(src.A)) {
            ret.p.y = -src.C / src.B;
            ret.p.x = 0.0;
        } else {
            ret.p.x = -src.C / src.A;
            ret.p.y = 0.0;
        }
        return ret;
    }
}

