/*
 * Decompiled with CFR 0.152.
 */
package georegression.struct;

import georegression.struct.GeoTuple_F64;

public abstract class GeoTuple4D_F64<T extends GeoTuple4D_F64>
extends GeoTuple_F64<T> {
    public double x;
    public double y;
    public double z;
    public double w;

    public GeoTuple4D_F64(double x, double y, double z, double w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
    }

    public GeoTuple4D_F64() {
    }

    @Override
    public int getDimension() {
        return 4;
    }

    protected void _set(GeoTuple4D_F64 a) {
        this.x = a.x;
        this.y = a.y;
        this.z = a.z;
        this.w = a.w;
    }

    public void set(double x, double y, double z, double w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
    }

    public boolean isIdentical(double x, double y, double z, double w) {
        return this.x == x && this.y == y && this.z == z && this.w == w;
    }

    public boolean isIdentical(double x, double y, double z, double w, double tol) {
        return Math.abs(this.x - x) <= tol && Math.abs(this.y - y) <= tol && Math.abs(this.z - z) <= tol && Math.abs(this.w - w) <= tol;
    }

    @Override
    public boolean isIdentical(GeoTuple4D_F64 t, double tol) {
        return Math.abs(this.x - t.x) <= tol && Math.abs(this.y - t.y) <= tol && Math.abs(this.z - t.z) <= tol && Math.abs(this.w - t.w) <= tol;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public double getW() {
        return this.w;
    }

    @Override
    public double getIndex(int index) {
        switch (index) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
            case 2: {
                return this.z;
            }
            case 3: {
                return this.w;
            }
        }
        throw new IllegalArgumentException("Invalid index");
    }

    @Override
    public void setIndex(int index, double value) {
        switch (index) {
            case 0: {
                this.x = value;
                break;
            }
            case 1: {
                this.y = value;
                break;
            }
            case 2: {
                this.z = value;
                break;
            }
            case 3: {
                this.w = value;
            }
            default: {
                throw new IllegalArgumentException("Invalid index");
            }
        }
    }

    @Override
    public double norm() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w);
    }

    @Override
    public double normSq() {
        return this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w;
    }

    @Override
    public double distance(GeoTuple4D_F64 t) {
        double dx = t.x - this.x;
        double dy = t.y - this.y;
        double dz = t.z - this.z;
        double dw = t.w - this.w;
        return Math.sqrt(dx * dx + dy * dy + dz * dz + dw * dw);
    }

    @Override
    public double distance2(GeoTuple4D_F64 t) {
        double dx = t.x - this.x;
        double dy = t.y - this.y;
        double dz = t.z - this.z;
        double dw = t.w - this.w;
        return dx * dx + dy * dy + dz * dz + dw * dw;
    }

    public void print() {
        System.out.println(this);
    }

    public boolean isNaN() {
        return Double.isNaN(this.x) || Double.isNaN(this.y) || Double.isNaN(this.z) || Double.isNaN(this.w);
    }

    public void setX(double x) {
        this.x = x;
    }

    public void setY(double y) {
        this.y = y;
    }

    public void setZ(double z) {
        this.z = z;
    }

    public void setW(double w) {
        this.w = w;
    }
}

