/*
 * Decompiled with CFR 0.152.
 */
package adams.data.random;

import adams.core.License;
import adams.core.annotation.MixedCopyright;
import edu.cornell.lassp.houle.RngPack.RandomSeedable;
import edu.cornell.lassp.houle.RngPack.Ranmar;
import java.io.Serializable;

@MixedCopyright(copyright="Yann RICHET (JMathArray)", author="Yann RICHET", license=License.BSD3, url="http://jmathtools.berlios.de/doc/jmatharray/html/Random_8java-source.html")
public class Random
implements Serializable {
    private static final long serialVersionUID = 7044792418488212665L;
    protected RandomSeedable m_RandEngine;

    public Random() {
        this.m_RandEngine = new Ranmar();
    }

    public Random(long seed) {
        this.m_RandEngine = new Ranmar(seed);
    }

    public double raw() {
        return this.m_RandEngine.raw();
    }

    public int randInt(int i0, int i1) {
        double x = this.raw();
        int i = i0 + new Double(Math.floor((double)(i1 - i0 + 1) * x)).intValue();
        return i;
    }

    public double uniform(double min, double max) {
        double x = min + (max - min) * this.raw();
        return x;
    }

    public double dirac(double[] values, double[] prob) {
        double[] prob_cumul = new double[values.length];
        prob_cumul[0] = prob[0];
        for (int i = 1; i < values.length; ++i) {
            prob_cumul[i] = prob_cumul[i - 1] + prob[i];
        }
        double y = this.raw();
        double x = 0.0;
        for (int i = 0; i < values.length - 1; ++i) {
            if (!(y > prob_cumul[i]) || !(y < prob_cumul[i + 1])) continue;
            x = values[i];
        }
        return x;
    }

    public double normal(double mu, double sigma) {
        double x = mu + sigma * Math.cos(Math.PI * 2 * this.raw()) * Math.sqrt(-2.0 * Math.log(this.raw()));
        return x;
    }

    public double chi2(int n) {
        double x = 0.0;
        for (int i = 0; i < n; ++i) {
            double norm = this.normal(0.0, 1.0);
            x += norm * norm;
        }
        return x;
    }

    public double logNormal(double mu, double sigma) {
        double x = mu + sigma * Math.cos(Math.PI * 2 * this.raw()) * Math.sqrt(-2.0 * Math.log(this.raw()));
        return Math.exp(x);
    }

    public double exponential(double lambda) {
        double x = -1.0 / lambda * Math.log(this.raw());
        return x;
    }

    public double triangular(double min, double max) {
        double x = min / 2.0 + (max - min) * this.raw() / 2.0 + min / 2.0 + (max - min) * this.raw() / 2.0;
        return x;
    }

    public double triangular(double min, double med, double max) {
        double y = this.raw();
        double x = y < (med - min) / (max - min) ? min + Math.sqrt(y * (max - min) * (med - min)) : max - Math.sqrt((1.0 - y) * (max - min) * (max - med));
        return x;
    }

    public double beta(double a, double b) {
        double try_y;
        double try_x;
        while ((try_x = Math.pow(this.raw(), 1.0 / a)) + (try_y = Math.pow(this.raw(), 1.0 / b)) > 1.0) {
        }
        return try_x / (try_x + try_y);
    }

    public double cauchy(double mu, double sigma) {
        double x = sigma * Math.tan(Math.PI * (this.raw() - 0.5)) + mu;
        return x;
    }

    public double weibull(double lambda, double c) {
        double x = Math.pow(-Math.log(1.0 - this.raw()), 1.0 / c) / lambda;
        return x;
    }

    public double rejection(Function fun, double maxFun, double min, double max) {
        double try_y;
        double try_x;
        do {
            try_x = min + this.raw() * (max - min);
            try_y = this.raw() * maxFun;
        } while (fun.f(try_x) < try_y);
        return try_x;
    }

    public static interface Function {
        public double f(double var1);
    }
}

