/*
 * Decompiled with CFR 0.152.
 */
package com.ning.compress.gzip;

import com.ning.compress.BufferRecycler;
import com.ning.compress.DataHandler;
import com.ning.compress.Uncompressor;
import com.ning.compress.gzip.GZIPRecycler;
import java.io.IOException;
import java.util.zip.CRC32;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import java.util.zip.ZipException;

public class GZIPUncompressor
extends Uncompressor {
    protected static final int GZIP_MAGIC = 35615;
    protected static final byte GZIP_MAGIC_0 = 31;
    protected static final byte GZIP_MAGIC_1 = -117;
    protected static final int FHCRC = 2;
    protected static final int FEXTRA = 4;
    protected static final int FNAME = 8;
    protected static final int FCOMMENT = 16;
    protected static final int DEFAULT_CHUNK_SIZE = 4096;
    protected static final int DECODE_BUFFER_SIZE = 65535;
    protected static final int STATE_INITIAL = 0;
    protected static final int STATE_HEADER_SIG1 = 1;
    protected static final int STATE_HEADER_COMP_TYPE = 2;
    protected static final int STATE_HEADER_FLAGS = 3;
    protected static final int STATE_HEADER_SKIP = 4;
    protected static final int STATE_HEADER_EXTRA0 = 5;
    protected static final int STATE_HEADER_EXTRA1 = 6;
    protected static final int STATE_HEADER_FNAME = 7;
    protected static final int STATE_HEADER_COMMENT = 8;
    protected static final int STATE_HEADER_CRC0 = 9;
    protected static final int STATE_HEADER_CRC1 = 10;
    protected static final int STATE_TRAILER_INITIAL = 11;
    protected static final int STATE_TRAILER_CRC1 = 12;
    protected static final int STATE_TRAILER_CRC2 = 13;
    protected static final int STATE_TRAILER_CRC3 = 14;
    protected static final int STATE_TRAILER_LEN0 = 15;
    protected static final int STATE_TRAILER_LEN1 = 16;
    protected static final int STATE_TRAILER_LEN2 = 17;
    protected static final int STATE_TRAILER_LEN3 = 18;
    protected static final int STATE_BODY = 20;
    protected final DataHandler _handler;
    protected final BufferRecycler _recycler;
    protected final GZIPRecycler _gzipRecycler;
    protected Inflater _inflater;
    protected final CRC32 _crc;
    protected final int _inputChunkLength;
    protected byte[] _decodeBuffer;
    protected int _state = 0;
    protected int _flags;
    protected int _headerCRC;
    protected int _skippedBytes;
    protected int _trailerCRC;
    protected int _trailerCount;

    public GZIPUncompressor(DataHandler h) {
        this(h, 4096);
    }

    public GZIPUncompressor(DataHandler h, int inputChunkLength) {
        this._inputChunkLength = inputChunkLength;
        this._handler = h;
        this._recycler = BufferRecycler.instance();
        this._decodeBuffer = this._recycler.allocDecodeBuffer(65535);
        this._gzipRecycler = GZIPRecycler.instance();
        this._inflater = this._gzipRecycler.allocInflater();
        this._crc = new CRC32();
    }

    public void feedCompressedData(byte[] comp, int offset, int len) throws IOException {
        int end = offset + len;
        if (this._state != 20) {
            if (this._state < 11) {
                if ((offset = this._handleHeader(comp, offset, end)) >= end) {
                    return;
                }
            } else {
                if ((offset = this._handleTrailer(comp, offset, end)) < end) {
                    throw new IllegalStateException();
                }
                return;
            }
        }
        block2: do {
            if (this._inflater.needsInput()) {
                int left = end - offset;
                if (left < 1) {
                    return;
                }
                int amount = Math.min(left, this._inputChunkLength);
                this._inflater.setInput(comp, offset, amount);
                offset += amount;
            }
            while (true) {
                int decoded;
                try {
                    decoded = this._inflater.inflate(this._decodeBuffer);
                }
                catch (DataFormatException e) {
                    ZipException z = new ZipException("Problems inflating gzip data: " + e.getMessage());
                    z.initCause(e);
                    throw z;
                }
                if (decoded == 0) continue block2;
                this._crc.update(this._decodeBuffer, 0, decoded);
                this._handler.handleData(this._decodeBuffer, 0, decoded);
            }
        } while (!this._inflater.finished() && !this._inflater.needsDictionary());
        this._state = 11;
        int remains = this._inflater.getRemaining();
        if (remains > 0) {
            offset -= remains;
        }
        if ((offset = this._handleTrailer(comp, offset, end)) < end) {
            throw new IllegalStateException();
        }
    }

    public void complete() throws IOException {
        Inflater i;
        byte[] b = this._decodeBuffer;
        if (b != null) {
            this._decodeBuffer = null;
            this._recycler.releaseDecodeBuffer(b);
        }
        if ((i = this._inflater) != null) {
            this._inflater = null;
            this._gzipRecycler.releaseInflater(i);
        }
        this._handler.allDataHandled();
        if (this._state != 0) {
            if (this._state >= 11) {
                if (this._state == 20) {
                    throw new ZipException("Invalid GZIP stream: end-of-input in the middle of compressed data");
                }
                throw new ZipException("Invalid GZIP stream: end-of-input in the trailer (state: " + this._state + ")");
            }
            throw new ZipException("Invalid GZIP stream: end-of-input in header (state: " + this._state + ")");
        }
    }

    protected final boolean _hasFlag(int flag) {
        return (this._flags & flag) == flag;
    }

    private final int _handleHeader(byte[] comp, int offset, int end) throws IOException {
        block13: while (offset < end) {
            int b = comp[offset++];
            this._crc.update(b);
            switch (this._state) {
                case 0: {
                    if (b != 31) {
                        this._reportBadHeader(comp, offset, end, 0);
                    }
                    if (offset >= end) {
                        this._state = 1;
                        break;
                    }
                    b = comp[offset++];
                    this._crc.update(b);
                }
                case 1: {
                    if (b != -117) {
                        this._reportBadHeader(comp, offset, end, 1);
                    }
                    if (offset >= end) {
                        this._state = 2;
                        break;
                    }
                    b = comp[offset++];
                    this._crc.update(b);
                }
                case 2: {
                    if (b != 8) {
                        this._reportBadHeader(comp, offset, end, 1);
                    }
                    if (offset >= end) {
                        this._state = 3;
                        break;
                    }
                    b = comp[offset++];
                    this._crc.update(b);
                }
                case 3: {
                    this._flags = b;
                    this._skippedBytes = 0;
                    this._state = 4;
                    if (offset >= end) break;
                    b = comp[offset++];
                    this._crc.update(b);
                }
                case 4: {
                    while (++this._skippedBytes < 6) {
                        if (offset >= end) break block13;
                        b = comp[offset++];
                        this._crc.update(b);
                    }
                    if (this._hasFlag(4)) {
                        this._state = 5;
                        continue block13;
                    }
                    if (this._hasFlag(8)) {
                        this._state = 7;
                        continue block13;
                    }
                    if (this._hasFlag(16)) {
                        this._state = 8;
                        continue block13;
                    }
                    if (this._hasFlag(2)) {
                        this._state = 9;
                        continue block13;
                    }
                    this._state = 20;
                    break block13;
                }
                case 5: {
                    this._state = 6;
                    break;
                }
                case 6: {
                    if (this._hasFlag(8)) {
                        this._state = 7;
                        break;
                    }
                    if (this._hasFlag(16)) {
                        this._state = 8;
                        break;
                    }
                    if (this._hasFlag(2)) {
                        this._state = 9;
                        break;
                    }
                    this._state = 20;
                    break block13;
                }
                case 7: {
                    while (b != 0) {
                        if (offset >= end) break block13;
                        b = comp[offset++];
                        this._crc.update(b);
                    }
                    if (this._hasFlag(16)) {
                        this._state = 8;
                        break;
                    }
                    if (this._hasFlag(2)) {
                        this._state = 9;
                        break;
                    }
                    this._state = 20;
                    break block13;
                }
                case 8: {
                    while (b != 0) {
                        if (offset >= end) break block13;
                        b = comp[offset++];
                    }
                    if (this._hasFlag(2)) {
                        this._state = 9;
                        break;
                    }
                    this._state = 20;
                    break block13;
                }
                case 9: {
                    this._headerCRC = b & 0xFF;
                    if (offset >= end) {
                        this._state = 10;
                        break;
                    }
                    b = comp[offset++];
                    this._crc.update(b);
                }
                case 10: {
                    this._headerCRC += (b & 0xFF) << 8;
                    int act = (int)this._crc.getValue() & 0xFFFF;
                    if (act != this._headerCRC) {
                        throw new ZipException("Corrupt GZIP header: header CRC 0x" + Integer.toHexString(act) + ", expected 0x " + Integer.toHexString(this._headerCRC));
                    }
                    this._state = 20;
                    break block13;
                }
                default: {
                    throw new IllegalStateException("Unknown header state: " + this._state);
                }
            }
        }
        if (this._state == 20) {
            this._crc.reset();
        }
        return offset;
    }

    private final int _handleTrailer(byte[] comp, int offset, int end) throws IOException {
        block10: while (offset < end) {
            byte b = comp[offset++];
            switch (this._state) {
                case 11: {
                    this._trailerCRC = b & 0xFF;
                    this._state = 12;
                    continue block10;
                }
                case 12: {
                    this._trailerCRC += (b & 0xFF) << 8;
                    this._state = 13;
                    continue block10;
                }
                case 13: {
                    this._trailerCRC += (b & 0xFF) << 16;
                    this._state = 14;
                    continue block10;
                }
                case 14: {
                    this._trailerCRC += (b & 0xFF) << 24;
                    int actCRC = (int)this._crc.getValue();
                    if (this._trailerCRC != actCRC) {
                        throw new ZipException("Corrupt block or trailer: expected CRC " + Integer.toHexString(this._trailerCRC) + ", computed " + Integer.toHexString(actCRC));
                    }
                    this._state = 15;
                    continue block10;
                }
                case 15: {
                    this._trailerCount = b & 0xFF;
                    this._state = 16;
                    continue block10;
                }
                case 16: {
                    this._trailerCount += (b & 0xFF) << 8;
                    this._state = 17;
                    continue block10;
                }
                case 17: {
                    this._trailerCount += (b & 0xFF) << 16;
                    this._state = 18;
                    continue block10;
                }
                case 18: {
                    this._trailerCount += (b & 0xFF) << 24;
                    this._state = 0;
                    int actCount32 = (int)this._inflater.getBytesWritten();
                    if (actCount32 == this._trailerCount) continue block10;
                    throw new ZipException("Corrupt block or trailed: expected byte count " + this._trailerCount + ", read " + actCount32);
                }
            }
            throw new IllegalStateException("Unknown trailer state: " + this._state);
        }
        return offset;
    }

    protected void _reportBadHeader(byte[] comp, int nextOffset, int end, int relative) throws IOException {
        String byteStr = "0x" + Integer.toHexString(comp[nextOffset] & 0xFF);
        if (relative <= 1) {
            int exp = relative == 0 ? 31 : 139;
            --nextOffset;
            throw new ZipException("Bad GZIP stream: byte #" + relative + " of header not '" + exp + "' (0x" + Integer.toHexString(exp) + ") but " + byteStr);
        }
        if (relative == 2) {
            throw new ZipException("Bad GZIP stream: byte #2 of header invalid: type " + byteStr + " not supported, 0x" + Integer.toHexString(8) + " expected");
        }
        throw new IOException("Bad GZIP stream: byte #" + relative + " of header invalid: " + byteStr);
    }
}

