/*
 * Decompiled with CFR 0.152.
 */
package examples;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.postgis.java2d.Java2DWrapper;

public class TestJava2d {
    private static final boolean DEBUG = true;
    public static final Shape[] SHAPEARRAY = new Shape[0];

    public static void main(String[] stringArray) throws ClassNotFoundException, SQLException {
        Shape[] shapeArray;
        if (stringArray.length != 5) {
            System.err.println("Usage: java examples/TestJava2D dburl user pass tablename column");
            System.err.println();
            System.err.println("dburl has the following format:");
            System.err.println("jdbc:postgis_j2d://HOST:PORT/DATABASENAME");
            System.err.println("tablename is 'jdbc_test' by default.");
            System.exit(1);
        }
        if ((shapeArray = TestJava2d.read(stringArray[0], stringArray[1], stringArray[2], "SELECT " + stringArray[4] + " FROM " + stringArray[3])).length == 0) {
            System.err.println("No geometries were found.");
            return;
        }
        System.err.println("Painting...");
        Frame frame = new Frame("PostGIS java2D demo");
        GisCanvas gisCanvas = new GisCanvas(shapeArray);
        frame.add(gisCanvas);
        frame.setSize(500, 500);
        frame.addWindowListener(new EventHandler());
        frame.setVisible(true);
    }

    static Rectangle2D calcbbox(Shape[] shapeArray) {
        Rectangle2D rectangle2D = shapeArray[0].getBounds2D();
        for (int i = 1; i < shapeArray.length; ++i) {
            rectangle2D = rectangle2D.createUnion(shapeArray[i].getBounds2D());
        }
        return rectangle2D;
    }

    private static Shape[] read(String string, String string2, String string3, String string4) throws ClassNotFoundException, SQLException {
        ArrayList<Shape> arrayList = new ArrayList<Shape>();
        System.out.println("Creating JDBC connection...");
        Class.forName("org.postgresql.Driver");
        Connection connection = DriverManager.getConnection(string, string2, string3);
        System.out.println("fetching geometries");
        ResultSet resultSet = connection.createStatement().executeQuery(string4);
        while (resultSet.next()) {
            Shape shape = (Shape)resultSet.getObject(1);
            if (shape == null) continue;
            arrayList.add(shape);
        }
        connection.close();
        return arrayList.toArray(SHAPEARRAY);
    }

    static {
        new Java2DWrapper();
    }

    public static class EventHandler
    implements WindowListener {
        @Override
        public void windowActivated(WindowEvent windowEvent) {
        }

        @Override
        public void windowClosed(WindowEvent windowEvent) {
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            windowEvent.getWindow().setVisible(false);
            System.exit(0);
        }

        @Override
        public void windowDeactivated(WindowEvent windowEvent) {
        }

        @Override
        public void windowDeiconified(WindowEvent windowEvent) {
        }

        @Override
        public void windowIconified(WindowEvent windowEvent) {
        }

        @Override
        public void windowOpened(WindowEvent windowEvent) {
        }
    }

    public static class GisCanvas
    extends Canvas {
        private static final long serialVersionUID = 1L;
        final Rectangle2D bbox;
        final Shape[] geometries;

        public GisCanvas(Shape[] shapeArray) {
            this.geometries = shapeArray;
            this.bbox = TestJava2d.calcbbox(shapeArray);
            this.setBackground(Color.GREEN);
        }

        @Override
        public void paint(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            double d = (double)(super.getWidth() - 10) / this.bbox.getWidth();
            double d2 = (double)(super.getHeight() - 10) / this.bbox.getHeight();
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.translate(super.getX() + 5, super.getY() + 5);
            affineTransform.scale(d, d2);
            affineTransform.translate(-this.bbox.getX(), -this.bbox.getY());
            System.err.println();
            System.err.println("bbox:  " + this.bbox);
            System.err.println("trans: " + affineTransform);
            System.err.println("new:   " + affineTransform.createTransformedShape(this.bbox).getBounds2D());
            System.err.println("visual:" + super.getBounds());
            for (int i = 0; i < this.geometries.length; ++i) {
                graphics2D.setPaint(Color.BLUE);
                Shape shape = affineTransform.createTransformedShape(this.geometries[i]);
                graphics2D.fill(shape);
                graphics2D.setPaint(Color.ORANGE);
                graphics2D.draw(shape);
            }
        }
    }
}

