/*
 * Decompiled with CFR 0.152.
 */
package org.postgis.java2d;

import java.awt.geom.GeneralPath;
import org.postgis.binary.ByteGetter;
import org.postgis.binary.ValueGetter;

public class ShapeBinaryParser {
    public static ValueGetter valueGetterForEndian(ByteGetter byteGetter) {
        if (byteGetter.get(0) == 0) {
            return new ValueGetter.XDR(byteGetter);
        }
        if (byteGetter.get(0) == 1) {
            return new ValueGetter.NDR(byteGetter);
        }
        throw new IllegalArgumentException("Unknown Endian type:" + byteGetter.get(0));
    }

    public synchronized int parse(String string, GeneralPath generalPath) {
        ByteGetter.StringByteGetter stringByteGetter = new ByteGetter.StringByteGetter(string);
        return this.parseGeometry(ShapeBinaryParser.valueGetterForEndian(stringByteGetter), generalPath);
    }

    public synchronized int parse(byte[] byArray, GeneralPath generalPath) {
        ByteGetter.BinaryByteGetter binaryByteGetter = new ByteGetter.BinaryByteGetter(byArray);
        return this.parseGeometry(ShapeBinaryParser.valueGetterForEndian(binaryByteGetter), generalPath);
    }

    protected int parseGeometry(ValueGetter valueGetter, GeneralPath generalPath) {
        byte by = valueGetter.getByte();
        if (by != valueGetter.endian) {
            throw new IllegalArgumentException("Endian inconsistency!");
        }
        int n = valueGetter.getInt();
        int n2 = n & 0x1FFFFFFF;
        boolean bl = (n & Integer.MIN_VALUE) != 0;
        boolean bl2 = (n & 0x40000000) != 0;
        boolean bl3 = (n & 0x20000000) != 0;
        int n3 = -1;
        if (bl3) {
            n3 = valueGetter.getInt();
        }
        switch (n2) {
            case 1: {
                this.parsePoint(valueGetter, bl, bl2, generalPath);
                break;
            }
            case 2: {
                this.parseLineString(valueGetter, bl, bl2, generalPath);
                break;
            }
            case 3: {
                this.parsePolygon(valueGetter, bl, bl2, generalPath);
                break;
            }
            case 4: {
                this.parseMultiPoint(valueGetter, generalPath);
                break;
            }
            case 5: {
                this.parseMultiLineString(valueGetter, generalPath);
                break;
            }
            case 6: {
                this.parseMultiPolygon(valueGetter, generalPath);
                break;
            }
            case 7: {
                this.parseCollection(valueGetter, generalPath);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown Geometry Type!");
            }
        }
        return n3;
    }

    private void parsePoint(ValueGetter valueGetter, boolean bl, boolean bl2, GeneralPath generalPath) {
        generalPath.moveTo((float)valueGetter.getDouble(), (float)valueGetter.getDouble());
        generalPath.closePath();
        this.skipZM(valueGetter, bl, bl2);
    }

    private void skipZM(ValueGetter valueGetter, boolean bl, boolean bl2) {
        if (bl) {
            valueGetter.getDouble();
        }
        if (bl2) {
            valueGetter.getDouble();
        }
    }

    private void parseGeometryArray(ValueGetter valueGetter, int n, GeneralPath generalPath) {
        for (int i = 0; i < n; ++i) {
            this.parseGeometry(valueGetter, generalPath);
        }
    }

    private void parseCS(ValueGetter valueGetter, boolean bl, boolean bl2, GeneralPath generalPath) {
        int n = valueGetter.getInt();
        if (n > 0) {
            generalPath.moveTo((float)valueGetter.getDouble(), (float)valueGetter.getDouble());
            this.skipZM(valueGetter, bl, bl2);
            for (int i = 1; i < n; ++i) {
                generalPath.lineTo((float)valueGetter.getDouble(), (float)valueGetter.getDouble());
                this.skipZM(valueGetter, bl, bl2);
            }
        }
    }

    private void parseMultiPoint(ValueGetter valueGetter, GeneralPath generalPath) {
        this.parseGeometryArray(valueGetter, valueGetter.getInt(), generalPath);
    }

    private void parseLineString(ValueGetter valueGetter, boolean bl, boolean bl2, GeneralPath generalPath) {
        this.parseCS(valueGetter, bl, bl2, generalPath);
    }

    private void parseLinearRing(ValueGetter valueGetter, boolean bl, boolean bl2, GeneralPath generalPath) {
        this.parseCS(valueGetter, bl, bl2, generalPath);
        generalPath.closePath();
    }

    private void parsePolygon(ValueGetter valueGetter, boolean bl, boolean bl2, GeneralPath generalPath) {
        int n = valueGetter.getInt() - 1;
        this.parseLinearRing(valueGetter, bl, bl2, generalPath);
        for (int i = 0; i < n; ++i) {
            this.parseLinearRing(valueGetter, bl, bl2, generalPath);
        }
    }

    private void parseMultiLineString(ValueGetter valueGetter, GeneralPath generalPath) {
        int n = valueGetter.getInt();
        this.parseGeometryArray(valueGetter, n, generalPath);
    }

    private void parseMultiPolygon(ValueGetter valueGetter, GeneralPath generalPath) {
        int n = valueGetter.getInt();
        this.parseGeometryArray(valueGetter, n, generalPath);
    }

    private void parseCollection(ValueGetter valueGetter, GeneralPath generalPath) {
        int n = valueGetter.getInt();
        this.parseGeometryArray(valueGetter, n, generalPath);
    }
}

