/*
 * Decompiled with CFR 0.152.
 */
package adams.ml;

import java.util.Calendar;

@Deprecated
public class BaseData {
    protected Object m_data;

    public static boolean isNumeric(Object o) {
        return o instanceof Number;
    }

    public static boolean isDate(Object o) {
        return o != null && o instanceof Date;
    }

    public static boolean isGPS(Object o) {
        return o != null && o instanceof GPS;
    }

    public static boolean isTime(Object o) {
        return o != null && o instanceof Time;
    }

    public static boolean isString(Object o) {
        return o != null && o instanceof String;
    }

    public static boolean isArray(Object o) {
        return o != null && o.getClass().isArray();
    }

    public static boolean isBoolean(Object o) {
        return o instanceof Boolean;
    }

    public BaseData(Object o) {
        this.m_data = o;
    }

    public Object getData() {
        return this.m_data;
    }

    public void setData(Object data) {
        this.m_data = data;
    }

    public Object getData(Type type) {
        return this.m_data;
    }

    public void setData(Object data, Type type) {
        this.m_data = data;
    }

    public static Type getType(Object data) {
        if (BaseData.isNumeric(data)) {
            return Type.NUMERIC;
        }
        if (BaseData.isArray(data)) {
            return Type.ARRAY;
        }
        if (BaseData.isBoolean(data)) {
            return Type.BOOLEAN;
        }
        if (BaseData.isString(data)) {
            return Type.STRING;
        }
        if (BaseData.isDate(data)) {
            return Type.DATE;
        }
        if (BaseData.isTime(data)) {
            return Type.TIME;
        }
        if (BaseData.isGPS(data)) {
            return Type.GPS;
        }
        return null;
    }

    public static boolean typeEquals(Object data, Type typ) {
        int o2;
        Type nt = BaseData.getType(data);
        int o1 = nt.ordinal();
        return o1 == (o2 = typ.ordinal());
    }

    public boolean isNumeric() {
        return BaseData.isNumeric(this.m_data);
    }

    public boolean isArray() {
        return BaseData.isArray(this.m_data);
    }

    public boolean isString() {
        return BaseData.isString(this.m_data);
    }

    public boolean isDate() {
        return BaseData.isDate(this.m_data);
    }

    public boolean isTime() {
        return BaseData.isTime(this.m_data);
    }

    public boolean isGPS() {
        return BaseData.isGPS(this.m_data);
    }

    public String toString() {
        return this.m_data.toString();
    }

    public static enum Type {
        NUMERIC,
        STRING,
        BOOLEAN,
        DATE,
        TIME,
        GPS,
        ARRAY;

    }

    public static class Time {
        protected int hour;
        protected int minute;
        protected int second;
        protected int millisecond;

        public Time(int h, int m, int s, int ms) {
            this.hour = h;
            this.minute = m;
            this.second = s;
            this.millisecond = ms;
        }
    }

    public static class GPS {
        protected Coordinate longitude;
        protected Coordinate latitude;

        public GPS(Coordinate lat, Coordinate lon) {
            this.longitude = lon;
            this.latitude = lat;
        }

        public double longitudeToDecimalDegree() {
            return this.longitude.toDecimalDegree();
        }

        public double latitudeToDecimalDegree() {
            return this.latitude.toDecimalDegree();
        }

        public static GPS toGPS(double latitude, double longitude) {
            return new GPS(Coordinate.decimalToDMS(latitude), Coordinate.decimalToDMS(longitude));
        }
    }

    public static class Point {
        protected double xpos;
        protected double ypos;

        public Point(double x, double y) {
            this.xpos = x;
            this.ypos = y;
        }

        public double getX() {
            return this.xpos;
        }

        public double getY() {
            return this.ypos;
        }
    }

    public static class Coordinate {
        protected int degree;
        protected int minute;
        protected int second;

        public Coordinate(int d, int m, int s) {
            this.degree = d;
            this.minute = m;
            this.second = s;
        }

        protected double toDecimalDegree() {
            long seconds = this.minute * 60 + this.second;
            double frac = (double)seconds / 3600.0;
            if (this.degree < 0) {
                return -((double)(-this.degree) + frac);
            }
            return (double)this.degree + frac;
        }

        public String toString() {
            return this.degree + ":" + this.minute + ":" + this.second;
        }

        public static Coordinate decimalToDMS(double coord) {
            int intPart;
            double mod = coord % 1.0;
            int degree = intPart = (int)coord;
            coord = Math.abs(mod * 60.0);
            mod = coord % 1.0;
            int minute = intPart = (int)coord;
            coord = mod * 60.0;
            int second = intPart = (int)coord;
            return new Coordinate(degree, minute, second);
        }
    }

    public static class Date {
        protected int day;
        protected int month;
        protected int year;

        public Date(int d, int m, int y) {
            this.day = d;
            this.month = m;
            this.year = y;
        }

        public long toTimestamp() {
            Calendar thisd = Calendar.getInstance();
            thisd.set(this.year, this.month - 1, this.day);
            return thisd.getTimeInMillis();
        }

        public Calendar toCalendar() {
            Calendar thisd = Calendar.getInstance();
            thisd.set(this.year, this.month - 1, this.day);
            return thisd;
        }

        public static Date toDate(Calendar thisd) {
            return new Date(thisd.get(5), thisd.get(2) + 1, thisd.get(1));
        }

        public static void printCalendar(Calendar thisd) {
            System.err.println(thisd.get(5) + "/" + (thisd.get(2) + 1) + "/" + thisd.get(1));
        }

        public boolean between(Date min, Date max) {
            Calendar start = Calendar.getInstance();
            Calendar end = Calendar.getInstance();
            Calendar thisd = Calendar.getInstance();
            start.set(min.year, min.month - 1, min.day);
            end.set(max.year, max.month - 1, max.day);
            thisd.set(this.year, this.month - 1, this.day);
            return thisd.compareTo(start) >= 0 && thisd.compareTo(end) < 0;
        }

        public boolean before(Date dt) {
            Calendar cdt = Calendar.getInstance();
            Calendar thisd = Calendar.getInstance();
            cdt.set(dt.year, dt.month - 1, dt.day);
            thisd.set(this.year, this.month - 1, this.day);
            return thisd.compareTo(cdt) < 0;
        }

        public boolean beforeOrEqual(Date dt) {
            return this.before(dt) || this.equal(dt);
        }

        public boolean afterOrEqual(Date dt) {
            return this.after(dt) || this.equal(dt);
        }

        public boolean after(Date dt) {
            Calendar cdt = Calendar.getInstance();
            Calendar thisd = Calendar.getInstance();
            cdt.set(dt.year, dt.month - 1, dt.day);
            thisd.set(this.year, this.month - 1, this.day);
            return thisd.compareTo(cdt) > 0;
        }

        public boolean equal(Date dt) {
            Calendar cdt = Calendar.getInstance();
            Calendar thisd = Calendar.getInstance();
            cdt.set(dt.year, dt.month - 1, dt.day);
            thisd.set(this.year, this.month - 1, this.day);
            return thisd.compareTo(cdt) == 0;
        }

        public int minusInDays(Date dt) {
            Calendar cdt = Calendar.getInstance();
            Calendar thisd = Calendar.getInstance();
            cdt.set(dt.year, dt.month - 1, dt.day);
            thisd.set(this.year, this.month - 1, this.day);
            Calendar date = (Calendar)thisd.clone();
            int daysBetween = 0;
            while (date.after(cdt)) {
                date.add(5, -1);
                ++daysBetween;
            }
            return daysBetween;
        }

        public Date addDays(int days) {
            Calendar thisd = Calendar.getInstance();
            thisd.set(this.year, this.month - 1, this.day);
            thisd.add(5, days);
            return new Date(thisd.get(5), thisd.get(2) + 1, thisd.get(1));
        }

        public String toString() {
            return "" + this.day + "/" + this.month + "/" + this.year;
        }
    }
}

