/*
 * Decompiled with CFR 0.152.
 */
package adams.data.filter;

import adams.data.container.DataPoint;
import adams.data.filter.AbstractFilter;
import adams.data.statistics.StatUtils;
import adams.data.timeseries.Timeseries;
import adams.data.timeseries.TimeseriesPoint;
import java.util.List;

public class RowNorm
extends AbstractFilter<Timeseries> {
    private static final long serialVersionUID = 1836858988505886282L;

    public String globalInfo() {
        return "Row wise normalization.";
    }

    protected Timeseries processData(Timeseries data) {
        int i;
        Timeseries result = data.getHeader();
        List points = data.toList();
        double[] x = new double[points.size()];
        for (i = 0; i < points.size(); ++i) {
            x[i] = ((TimeseriesPoint)((Object)points.get(i))).getValue();
        }
        double[] norm = StatUtils.rowNorm((double[])x);
        for (i = 0; i < points.size(); ++i) {
            result.add((DataPoint)new TimeseriesPoint(((TimeseriesPoint)((Object)points.get(i))).getTimestamp(), norm[i]));
        }
        return result;
    }
}

