/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.timeseriessplit;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.container.DataPoint;
import adams.data.timeseries.Timeseries;
import adams.data.timeseries.TimeseriesPoint;
import adams.flow.transformer.timeseriessplit.AbstractTimeseriesSplitter;
import java.util.ArrayList;
import java.util.Date;

public abstract class AbstractSplitOnDate
extends AbstractTimeseriesSplitter {
    private static final long serialVersionUID = 259240444289354690L;
    protected Segments m_Segments;
    protected boolean m_IncludeSplitDate;

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("segments", "segments", (Object)Segments.BOTH);
        this.m_OptionManager.add("include-split-date", "includeSplitDate", (Object)false);
    }

    public void setSegments(Segments value) {
        this.m_Segments = value;
        this.reset();
    }

    public Segments getSegments() {
        return this.m_Segments;
    }

    public String segmentsTipText() {
        return "The segments to return.";
    }

    public void setIncludeSplitDate(boolean value) {
        this.m_IncludeSplitDate = value;
        this.reset();
    }

    public boolean getIncludeSplitDate() {
        return this.m_IncludeSplitDate;
    }

    public String includeSplitDateTipText() {
        return "If enabled, the split date is included in the segments.";
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"segments", (Object)((Object)this.m_Segments), (String)"segments: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"includeSplitDate", (boolean)this.m_IncludeSplitDate, (String)"incl split date", (String)", ");
        return result;
    }

    protected Timeseries[] doSplit(Timeseries series, Date date) {
        ArrayList<Timeseries> result = new ArrayList<Timeseries>();
        Timeseries before = series.getHeader();
        Timeseries after = series.getHeader();
        for (Object obj : series.toList()) {
            TimeseriesPoint point = (TimeseriesPoint)((Object)obj);
            int comp = point.getTimestamp().compareTo(date);
            if (comp == 0) {
                if (!this.m_IncludeSplitDate) continue;
                before.add((DataPoint)point);
                after.add((DataPoint)point);
                continue;
            }
            if (comp < 0) {
                before.add((DataPoint)point);
                continue;
            }
            after.add((DataPoint)point);
        }
        switch (this.m_Segments) {
            case BOTH: {
                result.add(before);
                result.add(after);
                break;
            }
            case BEFORE: {
                result.add(before);
                break;
            }
            case AFTER: {
                result.add(after);
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled segments: " + (Object)((Object)this.m_Segments));
            }
        }
        return result.toArray(new Timeseries[result.size()]);
    }

    public static enum Segments {
        BOTH,
        BEFORE,
        AFTER;

    }
}

