/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.timeseries;

import adams.core.option.OptionHandler;
import adams.data.timeseries.PeriodicityHelper;
import adams.data.timeseries.PeriodicityType;
import adams.gui.core.GUIHelper;
import adams.gui.event.PaintEvent;
import adams.gui.visualization.core.AbstractColorProvider;
import adams.gui.visualization.core.AxisPanel;
import adams.gui.visualization.core.plot.Axis;
import adams.gui.visualization.timeseries.AbstractTimeseriesPaintlet;
import adams.gui.visualization.timeseries.PeriodicityColorProvider;
import gnu.trove.list.array.TDoubleArrayList;
import gnu.trove.list.array.TIntArrayList;
import java.awt.Graphics;
import java.util.Date;
import java.util.GregorianCalendar;

public class PeriodicityPaintlet
extends AbstractTimeseriesPaintlet {
    private static final long serialVersionUID = -6475036298238205843L;
    protected PeriodicityType m_Periodicity;
    protected AbstractColorProvider m_ColorProvider;

    public String globalInfo() {
        return "Paintlet for painting the periodicity background.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("periodicity", "periodicity", (Object)PeriodicityType.valueOf(GUIHelper.getString(((Object)((Object)this)).getClass(), (String)"periodicity", (String)PeriodicityType.NONE.toString())));
        this.m_OptionManager.add("color-provider", "colorProvider", (Object)((AbstractColorProvider)GUIHelper.getOptionHandler(((Object)((Object)this)).getClass(), (String)"colorProvider", (OptionHandler)new PeriodicityColorProvider())));
    }

    public boolean canPaint(PaintEvent.PaintMoment moment) {
        if (this.m_Periodicity == PeriodicityType.NONE) {
            return false;
        }
        return super.canPaint(moment);
    }

    public PaintEvent.PaintMoment getPaintMoment() {
        return PaintEvent.PaintMoment.BACKGROUND;
    }

    public void setPeriodicity(PeriodicityType value) {
        this.m_Periodicity = value;
        this.memberChanged();
    }

    public PeriodicityType getPeriodicity() {
        return this.m_Periodicity;
    }

    public String periodicityTipText() {
        return "The type of periodicity to use.";
    }

    public void setColorProvider(AbstractColorProvider value) {
        this.m_ColorProvider = value;
        this.memberChanged();
    }

    public AbstractColorProvider getColorProvider() {
        return this.m_ColorProvider;
    }

    public String colorProviderTipText() {
        return "The color provider to use.";
    }

    protected TIntArrayList calculatePositions(AxisPanel axisX) {
        double left = axisX.getActualMinimum();
        Date leftDate = new Date((long)left);
        GregorianCalendar leftCal = new GregorianCalendar();
        leftCal.setTime(leftDate);
        double right = axisX.getActualMaximum();
        Date rightDate = new Date((long)right);
        GregorianCalendar rightCal = new GregorianCalendar();
        rightCal.setTime(rightDate);
        TDoubleArrayList val = PeriodicityHelper.calculate(this.m_Periodicity, left, leftDate, leftCal, right, rightDate, rightCal);
        TIntArrayList result = new TIntArrayList();
        int current = -1;
        for (int i = 0; i < val.size(); ++i) {
            int last = current;
            current = axisX.valueToPos(val.get(i));
            if (current == last) continue;
            result.add(current);
        }
        return result;
    }

    public void performPaint(Graphics g, PaintEvent.PaintMoment moment) {
        AxisPanel axisX = this.getPanel().getPlot().getAxis(Axis.BOTTOM);
        TIntArrayList pos = this.calculatePositions(axisX);
        int pHeight = this.getPanel().getHeight();
        this.m_ColorProvider.resetColors();
        for (int i = 0; i < pos.size() - 1; ++i) {
            g.setColor(this.m_ColorProvider.next());
            int x = pos.get(i);
            int width = pos.get(i + 1) - pos.get(i);
            g.fillRect(x, 0, width, pHeight);
        }
    }
}

