/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink.openstreetmapviewer;

import adams.core.option.OptionUtils;
import adams.flow.sink.OpenStreetMapViewer;
import adams.flow.sink.openstreetmapviewer.AbstractMapOverlay;
import java.awt.Graphics;

public class MultiMapOverlay
extends AbstractMapOverlay {
    private static final long serialVersionUID = 805661569976845842L;
    protected AbstractMapOverlay[] m_Overlays;

    public String globalInfo() {
        return "A meta-overlay that paints multiple overlays.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("overlay", "overlays", (Object)new AbstractMapOverlay[0]);
    }

    public void setOverlays(AbstractMapOverlay[] value) {
        if (value != null) {
            this.m_Overlays = value;
            this.reset();
        } else {
            this.getLogger().severe(((Object)((Object)this)).getClass().getName() + ": overlays cannot be null!");
        }
    }

    public AbstractMapOverlay[] getOverlays() {
        return this.m_Overlays;
    }

    public String overlaysTipText() {
        return "The array of overlays to use.";
    }

    @Override
    protected void doPaintOverlay(OpenStreetMapViewer viewer, Graphics g) {
        for (int i = 0; i < this.m_Overlays.length; ++i) {
            this.getLogger().info("Overlay " + (i + 1) + "/" + this.m_Overlays.length + ": " + OptionUtils.getCommandLine((Object)((Object)this.m_Overlays[i])));
            this.m_Overlays[i].paintOverlay(viewer, g);
        }
        this.getLogger().info("Finished!");
    }
}

