/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.fitting.modelset.distance;

import java.util.Iterator;
import java.util.LinkedList;
import org.ddogleg.fitting.modelset.DistanceFromModel;
import org.ddogleg.fitting.modelset.distance.PointIndex;
import org.ddogleg.fitting.modelset.distance.StatisticalFit;

public class FitByMeanStatistics<Model, Point>
implements StatisticalFit<Model, Point> {
    protected DistanceFromModel<Model, Point> modelError;
    protected LinkedList<PointIndex<Point>> allPoints = new LinkedList();
    private double pruneThreshold;
    private double meanError;
    private double stdError;

    public FitByMeanStatistics(double pruneThreshold) {
        this.pruneThreshold = pruneThreshold;
    }

    @Override
    public void init(DistanceFromModel<Model, Point> modelError, LinkedList<PointIndex<Point>> allPoints) {
        this.modelError = modelError;
        this.allPoints = allPoints;
    }

    @Override
    public void computeStatistics() {
        this.computeMean();
        this.computeStandardDeviation();
    }

    @Override
    public void prune() {
        double thresh = this.stdError * this.pruneThreshold;
        Iterator iter = this.allPoints.iterator();
        while (iter.hasNext()) {
            Object pt = ((PointIndex)iter.next()).data;
            if (!(this.modelError.computeDistance(pt) - this.meanError > thresh)) continue;
            iter.remove();
        }
    }

    @Override
    public double getErrorMetric() {
        return this.meanError;
    }

    private void computeMean() {
        this.meanError = 0.0;
        int size = this.allPoints.size();
        for (PointIndex pointIndex : this.allPoints) {
            Object pt = pointIndex.data;
            this.meanError += this.modelError.computeDistance(pt);
        }
        this.meanError /= (double)size;
    }

    private void computeStandardDeviation() {
        this.stdError = 0.0;
        int size = this.allPoints.size();
        for (PointIndex pointIndex : this.allPoints) {
            Object pt = pointIndex.data;
            double e = this.modelError.computeDistance(pt) - this.meanError;
            this.stdError += e * e;
        }
        this.stdError = Math.sqrt(this.stdError / (double)size);
    }
}

