/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.optimization;

import org.ddogleg.optimization.functions.FunctionNtoM;
import org.ddogleg.optimization.functions.FunctionNtoMxN;
import org.ddogleg.optimization.impl.NumericalJacobianForward;
import org.ejml.UtilEjml;
import org.ejml.data.D1Matrix64F;
import org.ejml.data.DenseMatrix64F;
import org.ejml.ops.MatrixFeatures;

public class JacobianChecker {
    public static void jacobianPrint(FunctionNtoM func, FunctionNtoMxN jacobian, double[] param, double tol) {
        JacobianChecker.jacobianPrint(func, jacobian, param, tol, Math.sqrt(UtilEjml.EPS));
    }

    public static void jacobianPrint(FunctionNtoM func, FunctionNtoMxN jacobian, double[] param, double tol, double differenceScale) {
        NumericalJacobianForward numerical = new NumericalJacobianForward(func, differenceScale);
        DenseMatrix64F found = new DenseMatrix64F(func.getNumOfOutputsM(), func.getNumOfInputsN());
        DenseMatrix64F expected = new DenseMatrix64F(func.getNumOfOutputsM(), func.getNumOfInputsN());
        jacobian.process(param, found.data);
        numerical.process(param, expected.data);
        System.out.println("FOUND:");
        found.print();
        System.out.println("-----------------------------");
        System.out.println("Numerical");
        expected.print();
        System.out.println("-----------------------------");
        System.out.println("Large Differences");
        for (int y = 0; y < found.numRows; ++y) {
            for (int x = 0; x < found.numCols; ++x) {
                double diff = Math.abs(found.get(y, x) - expected.get(y, x));
                if (diff > tol) {
                    System.out.print("1");
                    continue;
                }
                System.out.print("0");
            }
            System.out.println();
        }
    }

    public static boolean jacobian(FunctionNtoM func, FunctionNtoMxN jacobian, double[] param, double tol) {
        return JacobianChecker.jacobian(func, jacobian, param, tol, Math.sqrt(UtilEjml.EPS));
    }

    public static boolean jacobian(FunctionNtoM func, FunctionNtoMxN jacobian, double[] param, double tol, double differenceScale) {
        NumericalJacobianForward numerical = new NumericalJacobianForward(func, differenceScale);
        if (numerical.getNumOfOutputsM() != jacobian.getNumOfOutputsM()) {
            throw new RuntimeException("M is not equal " + numerical.getNumOfOutputsM() + "  " + jacobian.getNumOfOutputsM());
        }
        if (numerical.getNumOfInputsN() != jacobian.getNumOfInputsN()) {
            throw new RuntimeException("N is not equal: " + numerical.getNumOfInputsN() + "  " + jacobian.getNumOfInputsN());
        }
        DenseMatrix64F found = new DenseMatrix64F(func.getNumOfOutputsM(), func.getNumOfInputsN());
        DenseMatrix64F expected = new DenseMatrix64F(func.getNumOfOutputsM(), func.getNumOfInputsN());
        jacobian.process(param, found.data);
        numerical.process(param, expected.data);
        return MatrixFeatures.isIdentical((D1Matrix64F)expected, (D1Matrix64F)found, (double)tol);
    }
}

