/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.trees;

import moa.classifiers.bayes.NaiveBayes;
import moa.classifiers.core.attributeclassobservers.AttributeClassObserver;
import moa.classifiers.trees.HoeffdingTree;
import weka.core.Instance;
import weka.core.Utils;

public class LimAttHoeffdingTree
extends HoeffdingTree {
    private static final long serialVersionUID = 1L;
    protected int[] listAttributes;

    @Override
    public String getPurposeString() {
        return "Hoeffding decision trees with a restricted number of attributes for data streams.";
    }

    public void setlistAttributes(int[] list) {
        this.listAttributes = list;
    }

    public LimAttHoeffdingTree() {
        this.removePoorAttsOption = null;
    }

    @Override
    protected HoeffdingTree.LearningNode newLearningNode(double[] initialClassObservations) {
        int predictionOption = this.leafpredictionOption.getChosenIndex();
        LimAttLearningNode ret = predictionOption == 0 ? new LimAttLearningNode(initialClassObservations) : (predictionOption == 1 ? new LearningNodeNB(initialClassObservations) : new LearningNodeNBAdaptive(initialClassObservations));
        return ret;
    }

    @Override
    public boolean isRandomizable() {
        return true;
    }

    public static class LearningNodeNBAdaptive
    extends LearningNodeNB {
        private static final long serialVersionUID = 1L;
        protected double mcCorrectWeight = 0.0;
        protected double nbCorrectWeight = 0.0;

        public LearningNodeNBAdaptive(double[] initialClassObservations) {
            super(initialClassObservations);
        }

        @Override
        public void learnFromInstance(Instance inst, HoeffdingTree ht) {
            int trueClass = (int)inst.classValue();
            if (this.observedClassDistribution.maxIndex() == trueClass) {
                this.mcCorrectWeight += inst.weight();
            }
            if (Utils.maxIndex((double[])NaiveBayes.doNaiveBayesPrediction(inst, this.observedClassDistribution, this.attributeObservers)) == trueClass) {
                this.nbCorrectWeight += inst.weight();
            }
            super.learnFromInstance(inst, ht);
        }

        @Override
        public double[] getClassVotes(Instance inst, HoeffdingTree ht) {
            if (this.mcCorrectWeight > this.nbCorrectWeight) {
                return this.observedClassDistribution.getArrayCopy();
            }
            double[] ret = NaiveBayes.doNaiveBayesPrediction(inst, this.observedClassDistribution, this.attributeObservers);
            int i = 0;
            while (i < ret.length) {
                int n = i++;
                ret[n] = ret[n] * this.observedClassDistribution.sumOfValues();
            }
            return ret;
        }
    }

    public static class LearningNodeNB
    extends LimAttLearningNode {
        private static final long serialVersionUID = 1L;

        public LearningNodeNB(double[] initialClassObservations) {
            super(initialClassObservations);
        }

        @Override
        public double[] getClassVotes(Instance inst, HoeffdingTree ht) {
            if (this.getWeightSeen() >= (double)ht.nbThresholdOption.getValue()) {
                return NaiveBayes.doNaiveBayesPrediction(inst, this.observedClassDistribution, this.attributeObservers);
            }
            return super.getClassVotes(inst, ht);
        }

        @Override
        public void disableAttribute(int attIndex) {
        }
    }

    public static class LimAttLearningNode
    extends HoeffdingTree.ActiveLearningNode {
        private static final long serialVersionUID = 1L;
        protected double weightSeenAtLastSplitEvaluation;
        protected int[] listAttributes;
        protected int numAttributes;

        public LimAttLearningNode(double[] initialClassObservations) {
            super(initialClassObservations);
        }

        public void setlistAttributes(int[] list) {
            this.listAttributes = list;
            this.numAttributes = list.length;
        }

        @Override
        public void learnFromInstance(Instance inst, HoeffdingTree ht) {
            this.observedClassDistribution.addToValue((int)inst.classValue(), inst.weight());
            if (this.listAttributes == null) {
                this.setlistAttributes(((LimAttHoeffdingTree)ht).listAttributes);
            }
            for (int j = 0; j < this.numAttributes; ++j) {
                int i = this.listAttributes[j];
                int instAttIndex = LimAttHoeffdingTree.modelAttIndexToInstanceAttIndex(i, inst);
                AttributeClassObserver obs = (AttributeClassObserver)this.attributeObservers.get(i);
                if (obs == null) {
                    obs = inst.attribute(instAttIndex).isNominal() ? ht.newNominalClassObserver() : ht.newNumericClassObserver();
                    this.attributeObservers.set(i, obs);
                }
                obs.observeAttributeClass(inst.value(instAttIndex), (int)inst.classValue(), inst.weight());
            }
        }
    }
}

