/*
 * Decompiled with CFR 0.152.
 */
package moa.clusterers.clustream;

import java.util.ArrayList;
import moa.cluster.CFCluster;
import weka.core.Instance;

public class ClustreamKernel
extends CFCluster {
    private static final long serialVersionUID = 1L;
    private static final double EPSILON = 5.0E-5;
    public static final double MIN_VARIANCE = 1.0E-50;
    protected double LST;
    protected double SST;
    int m;
    double t;

    public ClustreamKernel(Instance instance, int dimensions, long timestamp, double t, int m) {
        super(instance, dimensions);
        this.t = t;
        this.m = m;
        this.LST = timestamp;
        this.SST = timestamp * timestamp;
    }

    public ClustreamKernel(ClustreamKernel cluster, double t, int m) {
        super(cluster);
        this.t = t;
        this.m = m;
        this.LST = cluster.LST;
        this.SST = cluster.SST;
    }

    public void insert(Instance instance, long timestamp) {
        this.N += 1.0;
        this.LST += (double)timestamp;
        this.SST += (double)(timestamp * timestamp);
        for (int i = 0; i < instance.numValues(); ++i) {
            int n = i;
            this.LS[n] = this.LS[n] + instance.value(i);
            int n2 = i;
            this.SS[n2] = this.SS[n2] + instance.value(i) * instance.value(i);
        }
    }

    @Override
    public void add(CFCluster other2) {
        ClustreamKernel other = (ClustreamKernel)other2;
        assert (other.LS.length == this.LS.length);
        this.N += other.N;
        this.LST += other.LST;
        this.SST += other.SST;
        for (int i = 0; i < this.LS.length; ++i) {
            int n = i;
            this.LS[n] = this.LS[n] + other.LS[i];
            int n2 = i;
            this.SS[n2] = this.SS[n2] + other.SS[i];
        }
    }

    public double getRelevanceStamp() {
        if (this.N < (double)(2 * this.m)) {
            return this.getMuTime();
        }
        return this.getMuTime() + this.getSigmaTime() * this.getQuantile((double)this.m / (2.0 * this.N));
    }

    private double getMuTime() {
        return this.LST / this.N;
    }

    private double getSigmaTime() {
        return Math.sqrt(this.SST / this.N - this.LST / this.N * (this.LST / this.N));
    }

    private double getQuantile(double z) {
        assert (z >= 0.0 && z <= 1.0);
        return Math.sqrt(2.0) * ClustreamKernel.inverseError(2.0 * z - 1.0);
    }

    @Override
    public double getRadius() {
        if (this.N == 1.0) {
            return 0.0;
        }
        if (this.t == 1.0) {
            this.t = 1.0;
        }
        return this.getDeviation() * this.radiusFactor;
    }

    @Override
    public CFCluster getCF() {
        return this;
    }

    private double getDeviation() {
        double[] variance = this.getVarianceVector();
        double sumOfDeviation = 0.0;
        for (int i = 0; i < variance.length; ++i) {
            double d = Math.sqrt(variance[i]);
            sumOfDeviation += d;
        }
        return sumOfDeviation / (double)variance.length;
    }

    @Override
    public double[] getCenter() {
        assert (!this.isEmpty());
        double[] res = new double[this.LS.length];
        for (int i = 0; i < res.length; ++i) {
            res[i] = this.LS[i] / this.N;
        }
        return res;
    }

    @Override
    public double getInclusionProbability(Instance instance) {
        if (this.N == 1.0) {
            double distance = 0.0;
            for (int i = 0; i < this.LS.length; ++i) {
                double d = this.LS[i] - instance.value(i);
                distance += d * d;
            }
            if ((distance = Math.sqrt(distance)) < 5.0E-5) {
                return 1.0;
            }
            return 0.0;
        }
        double dist = this.calcNormalizedDistance(instance.toDoubleArray());
        if (dist <= this.getRadius()) {
            return 1.0;
        }
        return 0.0;
    }

    private double[] getVarianceVector() {
        double[] res = new double[this.LS.length];
        for (int i = 0; i < this.LS.length; ++i) {
            double ls = this.LS[i];
            double ss = this.SS[i];
            double lsDivN = ls / this.getWeight();
            double lsDivNSquared = lsDivN * lsDivN;
            double ssDivN = ss / this.getWeight();
            res[i] = ssDivN - lsDivNSquared;
            if (!(res[i] <= 0.0) || !(res[i] > -5.0E-5)) continue;
            res[i] = 1.0E-50;
        }
        return res;
    }

    public boolean isEmpty() {
        return this.N == 0.0;
    }

    private double calcNormalizedDistance(double[] point) {
        double[] variance = this.getVarianceVector();
        double[] center = this.getCenter();
        double res = 0.0;
        for (int i = 0; i < center.length; ++i) {
            double diff = center[i] - point[i];
            res += diff * diff;
        }
        return Math.sqrt(res);
    }

    public static double inverseError(double x) {
        double z = Math.sqrt(Math.PI) * x;
        double res = z / 2.0;
        double z2 = z * z;
        double zProd = z * z2;
        res += 0.041666666666666664 * zProd;
        res += 0.007291666666666667 * (zProd *= z2);
        res += 127.0 * (zProd *= z2) / 80640.0;
        res += 4369.0 * (zProd *= z2) / 1.161216E7;
        res += 34807.0 * (zProd *= z2) / 3.649536E8;
        return res += 2.0036983E7 * (zProd *= z2) / 7.970586624E11;
    }

    @Override
    protected void getClusterSpecificInfo(ArrayList<String> infoTitle, ArrayList<String> infoValue) {
        super.getClusterSpecificInfo(infoTitle, infoValue);
        infoTitle.add("Deviation");
        double[] variance = this.getVarianceVector();
        double sumOfDeviation = 0.0;
        for (int i = 0; i < variance.length; ++i) {
            double d = Math.sqrt(variance[i]);
            sumOfDeviation += d;
        }
        infoValue.add(Double.toString(sumOfDeviation /= (double)variance.length));
    }
}

