/*
 * Decompiled with CFR 0.152.
 */
package moa.clusterers.outliers.Angiulli;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Vector;
import moa.clusterers.outliers.Angiulli.ISBIndex;
import moa.clusterers.outliers.Angiulli.STORMBase;
import moa.clusterers.outliers.Angiulli.StreamObj;
import moa.clusterers.outliers.MyBaseOutlierDetector;
import moa.options.FloatOption;
import moa.options.IntOption;
import weka.core.Instance;

public class ExactSTORM
extends STORMBase {
    public FloatOption radiusOption = new FloatOption("radius", 'r', "Search radius.", 0.1);
    public IntOption kOption = new IntOption("k", 't', "Parameter k.", 50);
    public IntOption queryFreqOption = new IntOption("queryFreq", 'q', "Query frequency.", 1);

    @Override
    public String getObjectInfo(Object obj) {
        int i;
        if (obj == null) {
            return null;
        }
        ISBNodeExact node = (ISBNodeExact)obj;
        ArrayList<String> infoTitle = new ArrayList<String>();
        ArrayList<String> infoValue = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        for (i = 0; i < node.obj.dimensions(); ++i) {
            infoTitle.add("Dim" + (i + 1));
            infoValue.add(String.format("%.3f", node.obj.get(i)));
        }
        infoTitle.add("id");
        infoValue.add(String.format("%d", node.id));
        infoTitle.add("count_after");
        infoValue.add(String.format("%d", node.count_after));
        infoTitle.add("|nn_before|");
        infoValue.add(String.format("%d", node.CountPrecNeighs(this.GetWindowStart())));
        sb.append("<html>");
        sb.append("<table>");
        for (i = 0; i < infoTitle.size() && i < infoValue.size(); ++i) {
            sb.append("<tr><td><b>" + (String)infoTitle.get(i) + ":</b></td><td>" + (String)infoValue.get(i) + "</td></tr>");
        }
        sb.append("</table>");
        sb.append("</html>");
        return sb.toString();
    }

    @Override
    public void Init() {
        super.Init();
        this.m_WindowSize = this.windowSizeOption.getValue();
        this.m_radius = this.radiusOption.getValue();
        this.m_k = this.kOption.getValue();
        this.m_QueryFreq = this.queryFreqOption.getValue();
        this.Println("Init DistanceOutliersExact:");
        this.Println("   window_size: " + this.m_WindowSize);
        this.Println("   radius: " + this.m_radius);
        this.Println("   k: " + this.m_k);
        this.Println("   query_freq: " + this.m_QueryFreq);
        this.objId = FIRST_OBJ_ID;
        this.windowNodes = new Vector();
        this.ISB = new ISBIndex(this.m_radius, this.m_k);
        this.m_nBothInlierOutlier = 0;
        this.m_nOnlyInlier = 0;
        this.m_nOnlyOutlier = 0;
    }

    void RemoveNode(ISBIndex.ISBNode node) {
        this.ISB.Remove(node);
        this.windowNodes.remove(node);
        this.RemoveExpiredOutlier(new MyBaseOutlierDetector.Outlier(node.inst, node.id, node));
        this.UpdateStatistics(node);
    }

    void DeleteExpiredNode() {
        if (this.windowNodes.size() <= 0) {
            return;
        }
        ISBIndex.ISBNode node = (ISBIndex.ISBNode)this.windowNodes.get(0);
        if (node.id < this.GetWindowStart()) {
            if (this.bTrace) {
                this.Print("Delete expired node: ");
                this.PrintNode(node);
            }
            this.RemoveNode(node);
        }
    }

    @Override
    protected void ProcessNewStreamObj(Instance inst) {
        if (this.bShowProgress) {
            this.ShowProgress("Processed " + this.objId + " stream objects.");
        }
        double[] values = this.getInstanceValues(inst);
        StreamObj obj = new StreamObj(values);
        if (this.bTrace) {
            this.Println("\n- - - - - - - - - - - -\n");
        }
        ISBNodeExact nodeNew = new ISBNodeExact(inst, obj, this.objId, this.m_k);
        if (this.bTrace) {
            this.Print("New obj: ");
            this.PrintNode(nodeNew);
        }
        Long l = this.objId;
        Long l2 = this.objId = Long.valueOf(this.objId + 1L);
        this.DeleteExpiredNode();
        nodeNew.count_after = 1;
        if (this.bTrace) {
            this.Println("Perform range query seach:");
        }
        ++this.nRangeQueriesExecuted;
        Vector<ISBIndex.ISBSearchResult> nodes = this.ISB.RangeSearch(nodeNew, this.m_radius);
        for (ISBIndex.ISBSearchResult res : nodes) {
            ISBNodeExact n = (ISBNodeExact)res.node;
            if (this.bTrace) {
                this.Printf("   Found at d=%.2f: ", res.distance);
                this.PrintNode(res.node);
            }
            ++n.count_after;
            nodeNew.AddPrecNeigh(res.node.id);
        }
        if (this.bTrace) {
            this.Println("Insert new node to ISB.");
        }
        this.ISB.Insert(nodeNew);
        this.windowNodes.add(nodeNew);
        if (this.bTrace) {
            this.PrintWindow();
        }
        if (this.CanSearch()) {
            this.SearchOutliers();
        } else {
            this.UpdateNodeStatistics(nodeNew);
        }
    }

    void SearchOutliers() {
        if (this.bTrace) {
            this.Println("Invoke query: ");
        }
        for (int i = 0; i < this.windowNodes.size(); ++i) {
            ISBNodeExact node = (ISBNodeExact)this.windowNodes.get(i);
            if (this.bTrace) {
                this.Print("   Process node: ");
                this.PrintNode(node);
            }
            this.UpdateNodeType(node);
        }
    }

    void UpdateNodeType(ISBNodeExact node) {
        int succ_neighs = node.count_after;
        if (this.bTrace) {
            this.Println("      succ_neighs: " + succ_neighs);
        }
        int prec_neighs = node.CountPrecNeighs(this.GetWindowStart());
        if (this.bTrace) {
            this.Println("      GetWindowStart(): " + this.GetWindowStart());
            node.PrintPrecNeighs();
            this.Println("      prec_neighs: " + prec_neighs);
        }
        if (succ_neighs + prec_neighs < this.m_k) {
            this.SaveOutlier(node);
            if (this.bTrace) {
                this.Print("*** Outlier: ");
                this.PrintNode(node);
            }
        } else {
            this.RemoveOutlier(node);
        }
    }

    void UpdateNodeStatistics(ISBNodeExact node) {
        int succ_neighs = node.count_after;
        int prec_neighs = node.CountPrecNeighs(this.GetWindowStart());
        if (succ_neighs + prec_neighs < this.m_k) {
            ++node.nOutlier;
        } else {
            ++node.nInlier;
        }
    }

    public class ISBNodeExact
    extends ISBIndex.ISBNode {
        public int count_after;
        private ArrayList<Long> nn_before;

        public ISBNodeExact(Instance inst, StreamObj obj, Long id, int k) {
            super(inst, obj, id);
            ExactSTORM.this.m_k = k;
            this.count_after = 0;
            this.nn_before = new ArrayList();
        }

        public void AddPrecNeigh(Long id) {
            int pos = Collections.binarySearch(this.nn_before, id);
            if (pos < 0) {
                this.nn_before.add(-(pos + 1), id);
            }
        }

        public int CountPrecNeighs(Long sinceId) {
            int pos;
            int startPos;
            if (this.nn_before.size() > 0 && (startPos = (pos = Collections.binarySearch(this.nn_before, sinceId)) < 0 ? -(pos + 1) : pos) < this.nn_before.size()) {
                return this.nn_before.size() - startPos;
            }
            return 0;
        }

        public void PrintPrecNeighs() {
            ExactSTORM.this.Print("      nn_before: ");
            Iterator<Long> it = this.nn_before.iterator();
            while (it.hasNext()) {
                ExactSTORM.this.Print(it.next() + " ");
            }
            ExactSTORM.this.Println(" ");
        }
    }
}

