/*
 * Decompiled with CFR 0.152.
 */
package moa.streams.filters;

import java.util.Random;
import moa.AbstractMOAObject;
import moa.core.AutoExpandVector;
import moa.core.DoubleVector;
import moa.core.GaussianEstimator;
import moa.core.InstancesHeader;
import moa.options.FloatOption;
import moa.options.IntOption;
import moa.streams.filters.AbstractStreamFilter;
import weka.core.Instance;

public class AddNoiseFilter
extends AbstractStreamFilter {
    private static final long serialVersionUID = 1L;
    public IntOption randomSeedOption = new IntOption("randomSeed", 'r', "Seed for random noise.", 1);
    public FloatOption attNoiseFractionOption = new FloatOption("attNoise", 'a', "The fraction of attribute values to disturb.", 0.1, 0.0, 1.0);
    public FloatOption classNoiseFractionOption = new FloatOption("classNoise", 'c', "The fraction of class labels to disturb.", 0.1, 0.0, 1.0);
    protected Random random;
    protected AutoExpandVector<Object> attValObservers;

    @Override
    public String getPurposeString() {
        return "Adds random noise to examples in a stream.";
    }

    @Override
    protected void restartImpl() {
        this.random = new Random(this.randomSeedOption.getValue());
        this.attValObservers = new AutoExpandVector();
    }

    @Override
    public InstancesHeader getHeader() {
        return this.inputStream.getHeader();
    }

    @Override
    public Instance nextInstance() {
        Instance inst = (Instance)this.inputStream.nextInstance().copy();
        for (int i = 0; i < inst.numAttributes(); ++i) {
            AbstractMOAObject obs;
            double noiseFrac;
            double d = noiseFrac = i == inst.classIndex() ? this.classNoiseFractionOption.getValue() : this.attNoiseFractionOption.getValue();
            if (inst.attribute(i).isNominal()) {
                obs = (DoubleVector)this.attValObservers.get(i);
                if (obs == null) {
                    obs = new DoubleVector();
                    this.attValObservers.set(i, obs);
                }
                int originalVal = (int)inst.value(i);
                if (!inst.isMissing(i)) {
                    ((DoubleVector)obs).addToValue(originalVal, inst.weight());
                }
                if (!(this.random.nextDouble() < noiseFrac) || ((DoubleVector)obs).numNonZeroEntries() <= 1) continue;
                do {
                    inst.setValue(i, (double)this.random.nextInt(((DoubleVector)obs).numValues()));
                } while ((int)inst.value(i) == originalVal || ((DoubleVector)obs).getValue((int)inst.value(i)) == 0.0);
                continue;
            }
            obs = (GaussianEstimator)this.attValObservers.get(i);
            if (obs == null) {
                obs = new GaussianEstimator();
                this.attValObservers.set(i, obs);
            }
            ((GaussianEstimator)obs).addObservation(inst.value(i), inst.weight());
            inst.setValue(i, inst.value(i) + this.random.nextGaussian() * ((GaussianEstimator)obs).getStdDev() * noiseFrac);
        }
        return inst;
    }

    @Override
    public void getDescription(StringBuilder sb, int indent) {
    }
}

