/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone.rats.output;

import adams.flow.core.AbstractActor;
import adams.flow.core.Unknown;
import adams.flow.standalone.rats.output.AbstractRatOutput;
import adams.flow.webservice.WebServiceClient;
import adams.flow.webservice.WebServiceClientConsumer;
import com.example.customerservice.flow.UpdateCustomer;

public class WebserviceOutput
extends AbstractRatOutput {
    private static final long serialVersionUID = -3752727785209685369L;
    protected WebServiceClient m_Client;

    public String globalInfo() {
        return "Allows to send data to webservices using the supplied client.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("client", "client", (Object)this.getDefaultClient());
    }

    protected WebServiceClient getDefaultClient() {
        return new UpdateCustomer();
    }

    protected String checkClient(WebServiceClient value) {
        if (!(value instanceof WebServiceClientConsumer)) {
            return "Does not implement " + WebServiceClientConsumer.class.getName() + "!";
        }
        return null;
    }

    public void setClient(WebServiceClient value) {
        String msg = this.checkClient(value);
        if (msg == null) {
            this.m_Client = value;
            this.m_Client.setOwner((AbstractActor)this.getOwner());
            this.reset();
        } else {
            this.getLogger().severe("Failed to set client: " + msg);
        }
    }

    public WebServiceClient getClient() {
        return this.m_Client;
    }

    public String clientTipText() {
        return "The webservice client to use.";
    }

    @Override
    public Class[] accepts() {
        if (this.m_Client != null) {
            return ((WebServiceClientConsumer)this.m_Client).accepts();
        }
        return new Class[]{Unknown.class};
    }

    @Override
    protected String doTransmit() {
        String result = null;
        try {
            this.m_Client.setOwner((AbstractActor)this.getOwner());
            ((WebServiceClientConsumer)this.m_Client).setRequestData(this.m_Input);
            this.m_Client.query();
        }
        catch (Exception e) {
            result = this.handleException("Failed to send data to webservice!", e);
        }
        return result;
    }
}

