/*
 * Decompiled with CFR 0.152.
 */
package meka.classifiers.multilabel;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Random;
import java.util.Vector;
import meka.classifiers.multilabel.MCC;
import meka.classifiers.multilabel.MultilabelClassifier;
import meka.classifiers.multilabel.cc.CNode;
import meka.classifiers.multilabel.cc.Trellis;
import meka.core.A;
import meka.core.StatUtils;
import weka.core.Instances;
import weka.core.Option;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;

public class CT
extends MCC
implements TechnicalInformationHandler {
    protected int m_Width = -1;
    protected int m_Connectivity = 1;
    protected String m_DependencyPayoff = "Ibf";
    Trellis trel = null;
    private String info = "";

    @Override
    public String toString() {
        return this.info;
    }

    @Override
    public String globalInfo() {
        return "CC in a trellis structure (rather than a cascaded chain). You set the width and type/connectivity of the trellis, and optionally change the payoff function which guides the placement of nodes (labels) within the trellis.";
    }

    @Override
    public void buildClassifier(Instances D) throws Exception {
        int L = D.classIndex();
        int d = D.numAttributes() - L;
        this.m_R = new Random(this.getSeed());
        if (this.m_Width < 0) {
            this.m_Width = (int)Math.sqrt(L);
            if (this.getDebug()) {
                System.out.println("Setting width to " + this.m_Width);
            }
        }
        if (this.getDebug()) {
            System.out.println("Make Trellis");
        }
        int[] indices = A.make_sequence(L);
        A.shuffle(indices, this.m_R);
        this.trel = new Trellis(indices, this.m_Width, this.m_Connectivity);
        long start = System.currentTimeMillis();
        if (this.m_Is > 0) {
            double[][] I = StatUtils.margDepMatrix(D, this.m_DependencyPayoff);
            if (this.getDebug()) {
                System.out.println("Got " + this.m_DependencyPayoff + "-type Matrix in " + (double)(System.currentTimeMillis() - start) / 1000.0 + "s");
            }
            this.trel = CT.orderTrellis(this.trel, I, this.m_R);
        }
        this.info = String.valueOf((double)(System.currentTimeMillis() - start) / 1000.0);
        if (this.getDebug()) {
            System.out.println("\nTrellis built in: " + this.info + "s");
        }
        if (this.getDebug()) {
            System.out.println("Build Trellis");
        }
        this.nodes = new CNode[L];
        for (int jv : this.trel.indices) {
            if (this.getDebug()) {
                System.out.print(" -> " + jv);
            }
            this.nodes[jv] = new CNode(jv, null, this.trel.trellis[jv]);
            this.nodes[jv].build(D, this.m_Classifier);
        }
        if (this.getDebug()) {
            System.out.println();
        }
        this.confidences = new double[L];
        this.m_Chain = this.trel.indices;
    }

    public static Trellis orderTrellis(Trellis trel, double[][] I, Random rand) {
        int L = I.length;
        int[] Y = new int[L];
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i : trel.indices) {
            list.add(new Integer(i));
        }
        Y[0] = (Integer)list.remove(rand.nextInt(L));
        for (int j = 1; j < L; ++j) {
            double max_w = -1.0;
            int j_ = -1;
            Iterator i$ = list.iterator();
            while (i$.hasNext()) {
                int j_prop = (Integer)i$.next();
                double w = trel.weight(Y, j, j_prop, I);
                if (!(w >= max_w)) continue;
                max_w = w;
                j_ = j_prop;
            }
            list.remove(new Integer(j_));
            Y[j] = j_;
        }
        trel = new Trellis(Y, trel.WIDTH, trel.TYPE);
        return trel;
    }

    public int getType() {
        return this.m_Connectivity;
    }

    public void setType(int c) {
        this.m_Connectivity = c;
    }

    public int getWidth() {
        return this.m_Width;
    }

    public void setWidth(int h) {
        this.m_Width = h;
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.ARTICLE);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Jesse Read, Luca Martino, David Luengo, Pablo Olmos");
        result.setValue(TechnicalInformation.Field.TITLE, "Scalable multi-output label prediction: From classifier chains to classifier trellises");
        result.setValue(TechnicalInformation.Field.JOURNAL, "Pattern Recognition");
        result.setValue(TechnicalInformation.Field.URL, "http://www.sciencedirect.com/science/article/pii/S0031320315000084");
        result.setValue(TechnicalInformation.Field.YEAR, "2015");
        return result;
    }

    @Override
    public Enumeration listOptions() {
        Vector<Object> newVector = new Vector<Object>();
        newVector.addElement(new Option("\tThe width of the trellis.\n\tdefault: " + this.m_Width + " (sqrt[number of labels])", "H", 1, "-H <value>"));
        newVector.addElement(new Option("\tThe density/type of the trellis.\n\tdefault: " + this.m_Connectivity + "\n\trange: 0-3 (0=BR)", "L", 1, "-L <value>"));
        newVector.addElement(new Option("\tThe dependency payoff function.\n\tdefault: " + this.m_DependencyPayoff + "\n\t", "X", 1, "-X <value>"));
        Enumeration enu = super.listOptions();
        while (enu.hasMoreElements()) {
            newVector.addElement(enu.nextElement());
        }
        return newVector.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        int n = this.m_Width = Utils.getOptionPos((char)'H', (String[])options) >= 0 ? Integer.parseInt(Utils.getOption((char)'H', (String[])options)) : this.m_Width;
        if (this.getDebug()) {
            System.out.println("Width set as: " + this.m_Width);
        }
        int n2 = this.m_Connectivity = Utils.getOptionPos((char)'L', (String[])options) >= 0 ? Integer.parseInt(Utils.getOption((char)'L', (String[])options)) : this.m_Connectivity;
        if (this.getDebug()) {
            System.out.println("Trellis Type: " + this.m_Connectivity);
        }
        String string = this.m_DependencyPayoff = Utils.getOptionPos((char)'X', (String[])options) >= 0 ? Utils.getOption((char)'X', (String[])options) : this.m_DependencyPayoff;
        if (this.getDebug()) {
            System.out.println("Dependency Type: " + this.m_DependencyPayoff);
        }
        super.setOptions(options);
    }

    @Override
    public String[] getOptions() {
        ArrayList<String> result = new ArrayList<String>(Arrays.asList(super.getOptions()));
        result.add("-H");
        result.add("" + this.m_Width);
        result.add("-L");
        result.add("" + this.m_Connectivity);
        result.add("-X");
        result.add("" + this.m_DependencyPayoff);
        return result.toArray(new String[result.size()]);
    }

    public static void main(String[] args) {
        MultilabelClassifier.evaluation(new CT(), args);
    }
}

