/*
 * Decompiled with CFR 0.152.
 */
package meka.classifiers.multilabel;

import meka.classifiers.multilabel.MultilabelClassifier;
import meka.core.PSUtils;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;

public class LC
extends MultilabelClassifier
implements OptionHandler {
    private static final long serialVersionUID = -2726090581435923988L;
    private String info = "";

    @Override
    public String globalInfo() {
        return "LC aka LP (Laber Powerset) Method.\nTreats each label combination as a single class in a multi-class learning scheme. The set of possible values of each class is the powerset of labels.\nSee also LP from MULAN:\nhttp://mulan.sourceforge.net";
    }

    @Override
    public void buildClassifier(Instances D) throws Exception {
        this.testCapabilities(D);
        int L = D.classIndex();
        if (this.getDebug()) {
            System.out.print("Transforming Instances ...");
        }
        Instances D_ = PSUtils.LCTransformation(D, L);
        this.m_InstancesTemplate = new Instances(D_, 0);
        this.info = "K = " + this.m_InstancesTemplate.attribute(0).numValues() + ", N = " + D_.numInstances();
        if (this.getDebug()) {
            System.out.print("Building Classifier (" + this.info + "), ...");
        }
        this.m_Classifier.buildClassifier(D_);
        if (this.getDebug()) {
            System.out.println("Done");
        }
    }

    @Override
    public double[] distributionForInstance(Instance x) throws Exception {
        int L = x.classIndex();
        if (L == 1) {
            return new double[]{1.0};
        }
        Instance x_ = PSUtils.convertInstance(x, L, this.m_InstancesTemplate);
        x_.setDataset(this.m_InstancesTemplate);
        double[] y = new double[x_.numClasses()];
        y[(int)this.m_Classifier.classifyInstance((Instance)x_)] = 1.0;
        return PSUtils.convertDistribution(y, L, this.m_InstancesTemplate);
    }

    @Override
    public String toString() {
        return this.info;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision: 9117 $");
    }

    public static void main(String[] args) {
        MultilabelClassifier.evaluation(new LC(), args);
    }
}

