/*
 * Decompiled with CFR 0.152.
 */
package meka.classifiers.multilabel;

import java.util.Arrays;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import meka.classifiers.multilabel.CC;
import meka.classifiers.multilabel.MultilabelClassifier;
import meka.core.A;
import meka.core.CCUtils;
import meka.core.MLUtils;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;

public class MCC
extends CC
implements TechnicalInformationHandler {
    protected int m_Is = 0;
    protected int m_Iy = 10;
    protected int m_Payoff = 0;

    public double likelihood(CC h, Instances D) throws Exception {
        return this.likelihood(h, D, this.m_Payoff);
    }

    public double likelihood(CC h, Instances D, int payoff_fn) throws Exception {
        int L = D.classIndex();
        int N = D.numInstances();
        double s = 1.0;
        for (int i = 0; i < N; ++i) {
            Instance x = D.instance(i);
            double[] y = MLUtils.toDoubleArray(x);
            double[] p = h.probabilityForInstance(x, y);
            if (payoff_fn == 5) {
                s += A.sum(p);
                continue;
            }
            if (payoff_fn == 2) {
                s += Math.log(A.product(p));
                continue;
            }
            s += A.product(p);
        }
        return s;
    }

    @Override
    public void buildClassifier(Instances D) throws Exception {
        this.testCapabilities(D);
        int L = D.classIndex();
        int N = D.numInstances();
        int d = D.numAttributes() - L;
        this.m_R = new Random(this.m_S);
        int[] s = MLUtils.gen_indices(L);
        MLUtils.randomize(s, this.m_R);
        if (this.getDebug()) {
            System.out.println("s_[0] = " + Arrays.toString(s));
        }
        CC h = CCUtils.buildCC(s, D, this.m_Classifier);
        if (this.m_Is > 0) {
            if (this.getDebug()) {
                System.out.println("Optimising s ... (" + this.m_Is + " iterations):");
            }
            double w = this.likelihood(h, new Instances(D));
            if (this.getDebug()) {
                System.out.println("h_{t=0} := " + Arrays.toString(s));
            }
            for (int t = 0; t < this.m_Is; ++t) {
                int[] s_ = Arrays.copyOf(A.swap(s, this.m_R), s.length);
                CC h_ = CCUtils.buildCC(s_, D, this.m_Classifier);
                double w_ = this.likelihood(h_, new Instances(D));
                if (!(w_ > w)) continue;
                w = w_;
                s = s_;
                h = h_;
                if (!this.getDebug()) continue;
                System.out.println("h_{t=" + (t + 1) + "} := " + Arrays.toString(s));
            }
        }
        if (this.getDebug()) {
            System.out.println("---");
        }
        this.setChain(s);
        super.buildClassifier(D);
    }

    @Override
    public double[] distributionForInstance(Instance x) throws Exception {
        double[] y = super.distributionForInstance(x);
        if (this.m_Iy > 0) {
            double w = A.product(this.probabilityForInstance(x, y));
            Instance[] t_ = this.getTransformTemplates(x);
            for (int t = 0; t < this.m_Iy; ++t) {
                double[] y_ = this.sampleForInstanceFast(t_, this.m_R);
                double w_ = A.product(this.getConfidences());
                if (!(w_ > w)) continue;
                if (this.getDebug()) {
                    System.out.println("y' = " + Arrays.toString(y_) + ", :" + w_);
                }
                w = w_;
                y = Arrays.copyOf(y_, y_.length);
            }
        }
        return y;
    }

    public Enumeration listOptions() {
        Vector<Object> newVector = new Vector<Object>();
        newVector.addElement(new Option("\tSets the number of iterations in the chain space (training)\n\tdefault: " + this.m_Is, "Is", 1, "-Is <value>"));
        newVector.addElement(new Option("\tSets the number of iterations in the path space (inference)\n\tdefault: " + this.m_Iy, "Iy", 1, "-Iy <value>"));
        newVector.addElement(new Option("\tSets the type of payoff fn. to use (for I > 0) \n\tdefault: " + this.m_Payoff, "P", 1, "-P <value>"));
        Enumeration enu = super.listOptions();
        while (enu.hasMoreElements()) {
            newVector.addElement(enu.nextElement());
        }
        return newVector.elements();
    }

    public void setOptions(String[] options) throws Exception {
        this.m_Is = Utils.getOptionPos((String)"Is", (String[])options) >= 0 ? Integer.parseInt(Utils.getOption((String)"Is", (String[])options)) : this.m_Is;
        this.m_Iy = Utils.getOptionPos((String)"Iy", (String[])options) >= 0 ? Integer.parseInt(Utils.getOption((String)"Iy", (String[])options)) : this.m_Iy;
        this.m_Payoff = Utils.getOptionPos((char)'P', (String[])options) >= 0 ? Integer.parseInt(Utils.getOption((char)'P', (String[])options)) : this.m_Payoff;
        super.setOptions(options);
    }

    public String[] getOptions() {
        String[] superOptions = super.getOptions();
        String[] options = new String[superOptions.length + 6];
        int current = 0;
        options[current++] = "-Is";
        options[current++] = String.valueOf(this.m_Is);
        options[current++] = "-Iy";
        options[current++] = String.valueOf(this.m_Iy);
        options[current++] = "-P";
        options[current++] = String.valueOf(this.m_Payoff);
        System.arraycopy(superOptions, 0, options, current, superOptions.length);
        return options;
    }

    public void setInferenceInterations(int iy) {
        this.m_Iy = iy;
    }

    public int getInferenceInterations() {
        return this.m_Iy;
    }

    public void setChainIterations(int is) {
        this.m_Is = is;
    }

    public int getChainIterations() {
        return this.m_Is;
    }

    @Override
    public String globalInfo() {
        return "Classifier Chains with Monte Carlo optimization. For more information see:\n" + this.getTechnicalInformation().toString();
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.INPROCEEDINGS);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Jesse Read and Luca Martino and David Luengo");
        result.setValue(TechnicalInformation.Field.TITLE, "Efficient Monte Carlo Optimization for Multi-label Classifier Chains");
        result.setValue(TechnicalInformation.Field.BOOKTITLE, "ICASSP'13: International Conference on Acoustics, Speech, and Signal Processing");
        result.setValue(TechnicalInformation.Field.YEAR, "2013");
        TechnicalInformation additional = new TechnicalInformation(TechnicalInformation.Type.ARTICLE);
        additional.setValue(TechnicalInformation.Field.AUTHOR, "Jesse Read and Luca Martino and David Luengo");
        additional.setValue(TechnicalInformation.Field.TITLE, "Efficient Monte Carlo Optimization for Multi-dimensional Classifier Chains");
        additional.setValue(TechnicalInformation.Field.JOURNAL, "Elsevier Pattern Recognition");
        additional.setValue(TechnicalInformation.Field.YEAR, "2013");
        result.add(additional);
        return result;
    }

    public static void main(String[] args) {
        MultilabelClassifier.evaluation(new MCC(), args);
    }
}

