/*
 * Decompiled with CFR 0.152.
 */
package meka.classifiers.multilabel;

import java.util.HashMap;
import meka.classifiers.multilabel.MultilabelClassifier;
import meka.core.MLUtils;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionUtils;

public class MajorityLabelset
extends MultilabelClassifier {
    private static final long serialVersionUID = -5932291001079843869L;
    protected double[] prediction = null;
    protected HashMap<String, Double> classFreqs = new HashMap();
    protected double maxValue = 0.0;

    @Override
    public String globalInfo() {
        return "Majority Labelset Classifier: Always predict the combination of labels which occurs most frequently in the training set.";
    }

    protected void updateCount(Instance x, int L) {
        String y = MLUtils.toBitString(x, L);
        if (this.classFreqs.containsKey(y)) {
            double freq = this.classFreqs.get(y) + x.weight();
            this.classFreqs.put(y, freq);
            if (this.maxValue < freq) {
                this.maxValue = freq;
                this.prediction = MLUtils.fromBitString(y);
            }
        } else {
            this.classFreqs.put(y, x.weight());
        }
    }

    @Override
    public void buildClassifier(Instances D) throws Exception {
        this.testCapabilities(D);
        int L = D.classIndex();
        this.prediction = new double[L];
        for (int i = 0; i < D.numInstances(); ++i) {
            this.updateCount(D.instance(i), L);
        }
    }

    @Override
    public double[] distributionForInstance(Instance test) throws Exception {
        return this.prediction;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision: 9117 $");
    }

    public static void main(String[] args) {
        MultilabelClassifier.evaluation(new MajorityLabelset(), args);
    }
}

